/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.crest.model.LongNameObject;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.NameValidator;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.constraint.GenericConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxy;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxySet;

public abstract class ContainedObject
extends DesignObject
implements LongNameObject,
ObjectListener {
    private ContainerObject container;
    private boolean nullAllowed = true;
    private boolean unique = false;
    private String constraintName;
    protected boolean useDomainConstraints = true;
    private CheckConstraint check;
    private ConstraintEnumeration valueList;
    private Set avts = new TreeSet();
    private String constraintNotes = "";
    private String constraintComment = "";
    private String constraintCommentInRDBMS = "";
    private StructuredType structuredType = null;
    private CollectionType collectionType = null;
    private String structuredTypeLongName;
    private String collectionTypeLongName;
    public static final String NLS_TYPE_MANUAL = Messages.getString("ContainedObject.Manual");
    public static final String NLS_TYPE_SYSTEM = Messages.getString("ContainedObject.System");
    public static final String NLS_TYPE_DERIVED = Messages.getString("ContainedObject.Derived");
    public static final String NLS_TYPE_AGGREGATE = Messages.getString("ContainedObject.Aggregate");
    public static final String[] SOURCE_TYPE_STATES_DISPLAY = new String[]{"", NLS_TYPE_MANUAL, NLS_TYPE_SYSTEM, NLS_TYPE_DERIVED, NLS_TYPE_AGGREGATE};
    public static final String TYPE_MANUAL = "Manual";
    public static final String TYPE_SYSTEM = "System";
    public static final String TYPE_DERIVED = "Derived";
    public static final String TYPE_AGGREGATE = "Aggregate";
    public static final String[] SOURCE_TYPE_STATES_INTERNAL = new String[]{"", "Manual", "System", "Derived", "Aggregate"};
    private static Set sourceTypeSet = null;
    private String sourceType = "";
    private String formulaDesc = "";
    private StringBuffer buffer = new StringBuffer();
    private String synonym = "";
    private String structAttributeID = "";
    private boolean oid = false;
    protected String scopeId = null;
    private List nestedObjects = new ArrayList();
    private ContainedObject parentObject;
    private int avtSortOrder = 0;
    private String referedAttribute;

    public ContainedObject(DesignPart designPart) {
        super(designPart);
    }

    public void setContainer(ContainerObject container) {
        if (this.isWriteable()) {
            this.container = container;
            if (container != null) {
                this.setBackup(container.isBackup());
            }
        }
    }

    public ContainerObject getContainer() {
        return this.container;
    }

    public boolean belongsTo(ContainerObject container) {
        return this.getContainer() == container;
    }

    public void setNullsAllowed(boolean allowed) {
        if (this.isWriteable() && allowed != this.nullAllowed) {
            this.nullAllowed = allowed;
            if (allowed) {
                this.unique = false;
            }
            this.fireChange(ObjectChangeEvent.NULLS_ALLOWED_CHANGED);
        }
    }

    public boolean getNullsAllowed() {
        if (this instanceof Column && ((Column)this).isIdentityColumn()) {
            return false;
        }
        return this.nullAllowed;
    }

    public void setUnique(boolean unique) {
        if (this.isWriteable()) {
            this.unique = unique;
        }
    }

    public String getConstraintName() {
        if (this.constraintName != null) {
            return this.constraintName;
        }
        return "";
    }

    public void setConstraintName(String name) {
        if (this.isWriteable()) {
            this.constraintName = name;
        }
    }

    public boolean getUseDomainConstraints() {
        return this.useDomainConstraints;
    }

    public void setUseDomainConstraints(boolean value) {
        if (this.isWriteable() && this.useDomainConstraints != value) {
            this.useDomainConstraints = value;
            this.fireChange(ObjectChangeEvent.ATTRIBUTE_DOMAIN_CHANGED);
        }
    }

    public CheckConstraint getCheck() {
        return this.check;
    }

    public void setCheck(CheckConstraint check) {
        if (this.isWriteable()) {
            this.check = check;
            if (check != null) {
                this.check.setDesign(this.getDesign());
            }
        }
    }

    public void addAVT(AVT avt) {
        if (!this.avts.contains(avt)) {
            this.avts.add(avt);
        }
    }

    public Set getAVTs() {
        LogicalDatatype logicalDatatype;
        if (this.avts.size() > 1 && this instanceof ContainedObjectWithDomain && (logicalDatatype = ((ContainedObjectWithDomain)this).getLogicalDatatype()) != null && logicalDatatype.isNumeric()) {
            TreeSet sortedSet = new TreeSet(new AVTNumberComparator());
            sortedSet.addAll(this.avts);
            return sortedSet;
        }
        return this.avts;
    }

    public void removeAVT(AVT avt) {
        if (this.avts.contains(avt)) {
            this.avts.remove(avt);
        }
    }

    public void clearAVTs() {
        this.avts.clear();
    }

    public ConstraintEnumeration getValueList() {
        return this.valueList;
    }

    public void setValueList(ConstraintEnumeration valueList) {
        this.valueList = valueList;
        if (valueList != null) {
            valueList.setDesign(this.getDesign());
        }
    }

    public void setConstraintNotes(String notes) {
        if (this.isWriteable()) {
            this.constraintNotes = this.constraintNotes != null ? notes : "";
        }
    }

    public String getConstraintNotes() {
        return this.constraintNotes;
    }

    public void setConstraintComment(String comment) {
        if (this.isWriteable()) {
            this.constraintComment = this.constraintComment != null ? comment : "";
        }
    }

    public String getConstraintComment() {
        return this.constraintComment;
    }

    public void setConstraintCommentInRDBMS(String comment) {
        if (this.constraintComment != null && !"null".equalsIgnoreCase(this.constraintComment)) {
            this.constraintCommentInRDBMS = comment;
        }
    }

    public String getConstraintCommentInRDBMS() {
        String result = this.constraintCommentInRDBMS;
        result = result == null ? "" : result;
        return result;
    }

    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public String getLongName() {
        this.buffer.setLength(0);
        if (this.container != null) {
            this.buffer.append(this.container.getLongName());
            this.buffer.append('.');
        }
        this.buffer.append(this.getName());
        return this.buffer.toString();
    }

    @Override
    public String getLongName(boolean includeContainerSchema) {
        if (includeContainerSchema) {
            return this.getLongName();
        }
        this.buffer.setLength(0);
        if (this.container != null) {
            this.buffer.append(this.container.getName());
            this.buffer.append('.');
        }
        this.buffer.append(this.getName());
        return this.buffer.toString();
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        if (this.getContainer() != null && this.getContainer().isReadOnly()) {
            return true;
        }
        return super.isReadOnly();
    }

    public boolean isFKElement() {
        return false;
    }

    @Override
    public boolean isContainedObject() {
        return true;
    }

    public ContainedObject getDelegateElement() {
        return null;
    }

    public int getIndex() {
        if (this.getContainer() != null) {
            return this.getContainer().getIndexOf(this);
        }
        return -1;
    }

    public int getPositionInContainerOneBased() {
        return this.getIndex() + 1;
    }

    public void moveToIndex(int index) {
        if (this.getContainer() != null) {
            this.getContainer().moveToIndex(this, index);
        }
    }

    @Override
    public Object getParent() {
        if (this.getContainer() != null) {
            return this.getContainer();
        }
        return super.getParent();
    }

    @Override
    public void remove() {
        if (this.parentObject != null) {
            this.parentObject.removeNestedObject(this);
        }
        this.removeNestedObjects();
        this.parentObject = null;
        boolean firstTime = !this.getIsBeingRemoved();
        super.remove();
        if (firstTime && this.getContainer() != null) {
            this.getContainer().remove(this);
        }
    }

    public void removeNestedObjects() {
        Object[] nest = this.nestedObjects.toArray();
        for (int i = 0; i < nest.length; ++i) {
            ContainedObject cob = (ContainedObject)nest[i];
            cob.remove();
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (event.isType(ObjectChangeEvent.NAME_CHANGED)) {
            this.setName(this.getName());
        }
    }

    public String getSynonym() {
        return this.synonym;
    }

    public void setSynonym(String synonym) {
        if (!this.synonym.equals(synonym)) {
            this.synonym = synonym;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    private boolean checkSourceType(String value) {
        if (sourceTypeSet == null) {
            sourceTypeSet = new HashSet();
            sourceTypeSet.addAll(Arrays.asList(SOURCE_TYPE_STATES_INTERNAL));
        }
        return sourceTypeSet.contains(value);
    }

    public String getFormulaDesc() {
        return this.formulaDesc;
    }

    public void setFormulaDesc(String formulaDesc) {
        if (formulaDesc != null && formulaDesc.equals(this.formulaDesc)) {
            return;
        }
        this.formulaDesc = formulaDesc;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        if (sourceType != null && sourceType.equals(this.sourceType)) {
            return;
        }
        if (this.checkSourceType(sourceType)) {
            this.sourceType = sourceType;
        }
    }

    public String getStructAttributeID() {
        return this.structAttributeID;
    }

    public void setStructAttributeID(String structAttributeID) {
        this.structAttributeID = structAttributeID != null ? structAttributeID : "";
    }

    public boolean isOid() {
        return this.oid;
    }

    public void setOid(boolean oid) {
        this.oid = oid;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public ContainerObject getScope() {
        if (this.scopeId == null) {
            return null;
        }
        return (ContainerObject)this.getDesign().getDesignObject(this.scopeId);
    }

    public StructuredType getStructuredType() {
        return this.structuredType;
    }

    public void setStructuredType(StructuredType structuredType) {
        this.structuredType = structuredType;
    }

    public String getStructuredTypeLongName() {
        StructuredType structuredType = this.getStructuredType();
        if (structuredType != null) {
            StructuredTypeProxy stp;
            StructuredTypeProxySet stpSet;
            StorageDesign sd = this.getDesign().getRelationalDesign().getStorageDesign();
            if (sd != null && (stpSet = sd.getStructuredTypeProxySet()) != null && (stp = (StructuredTypeProxy)stpSet.getProxy(structuredType.getObjectID())) != null) {
                return stp.getLongName();
            }
            return structuredType.getName();
        }
        return this.structuredTypeLongName;
    }

    public void setStructuredTypeLongName(String longName) {
        StructuredType structuredType = null;
        if (longName == null || longName.isEmpty()) {
            this.structuredTypeLongName = null;
        } else {
            this.structuredTypeLongName = longName;
            int ind = longName.indexOf(46);
            if (ind > -1) {
                StructuredTypeProxy stp;
                StructuredTypeProxySet stpSet;
                String user = longName.substring(0, ind);
                String name = longName.substring(ind + 1);
                StorageDesign sd = this.getDesign().getRelationalDesign().getStorageDesign();
                if (sd != null && (stpSet = sd.getStructuredTypeProxySet()) != null && (stp = stpSet.getBySchemaAndName(user, name)) != null) {
                    structuredType = stp.getStructuredType();
                }
            } else {
                structuredType = (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(longName);
            }
        }
        this.setStructuredType(structuredType);
    }

    public ContainedObject getParentObject() {
        return this.parentObject;
    }

    public void setParentObject(ContainedObject parentObject) {
        if (this.parentObject != parentObject) {
            if (this.parentObject != null) {
                this.parentObject.removeNestedObject(this);
            }
            this.parentObject = parentObject;
            if (this.parentObject != null) {
                this.parentObject.addNestedObject(this);
                this.setName(this.getShortName());
            }
        }
    }

    public void addNestedObject(ContainedObject nested) {
        if (!this.nestedObjects.contains(nested)) {
            this.nestedObjects.add(nested);
        }
    }

    public void removeNestedObject(ContainedObject nested) {
        this.nestedObjects.remove(nested);
    }

    public boolean isAtomic() {
        return this.getStructuredType() == null;
    }

    public boolean isNested() {
        return this.parentObject != null;
    }

    @Override
    public boolean setName(String name) {
        String pnameDot;
        int ind;
        if (this.parentObject != null && (ind = name.lastIndexOf(pnameDot = this.parentObject.getName() + ".")) > -1) {
            name = name.substring(ind + pnameDot.length());
        }
        return super.setName(name);
    }

    @Override
    public String getName() {
        Object name = super.getName();
        if (this.parentObject != null) {
            name = this.parentObject.getName() + "." + (String)name;
        }
        return name;
    }

    @Override
    public String getFormatedName(NameValidator sd, boolean quoted) {
        Object fname = super.getName();
        if (quoted || this.getNameHasQuotes() || !sd.isValidName((String)fname)) {
            fname = "\"" + (String)fname + "\"";
        }
        if (this.parentObject != null) {
            fname = this.parentObject.getFormatedName(sd, quoted) + "." + (String)fname;
        }
        return fname;
    }

    public String getShortName() {
        String pnameDot;
        int ind;
        String name = super.getName();
        if (this.parentObject != null && (ind = name.lastIndexOf(pnameDot = this.parentObject.getName() + ".")) > -1) {
            name = name.substring(ind + pnameDot.length());
        }
        return name;
    }

    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
    }

    public String getCollectionTypeLongName() {
        CollectionType CollectionType2 = this.getCollectionType();
        if (CollectionType2 != null) {
            CollectionTypeProxy ctp;
            CollectionTypeProxySet ctpSet;
            StorageDesign sd = this.getDesign().getRelationalDesign().getStorageDesign();
            if (sd != null && (ctpSet = sd.getCollectionTypeProxySet()) != null && (ctp = (CollectionTypeProxy)ctpSet.getProxy(CollectionType2.getObjectID())) != null) {
                return ctp.getLongName();
            }
            return CollectionType2.getName();
        }
        return this.collectionTypeLongName;
    }

    public void setCollectionTypeLongName(String longName) {
        CollectionType CollectionType2 = null;
        if (longName == null || longName.isEmpty()) {
            this.collectionTypeLongName = null;
        } else {
            this.collectionTypeLongName = longName;
            int ind = longName.indexOf(46);
            if (ind > -1) {
                CollectionTypeProxy ctp;
                CollectionTypeProxySet ctpSet;
                String user = longName.substring(0, ind);
                String name = longName.substring(ind + 1);
                StorageDesign sd = this.getDesign().getRelationalDesign().getStorageDesign();
                if (sd != null && (ctpSet = sd.getCollectionTypeProxySet()) != null && (ctp = ctpSet.getByOwnerAndName(user, name)) != null) {
                    CollectionType2 = ctp.getCollectionType();
                }
            } else {
                CollectionType2 = (CollectionType)this.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(longName);
            }
        }
        this.setCollectionType(CollectionType2);
    }

    public String getSize() {
        return "";
    }

    @Override
    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
        if (dirty && this.getContainer() != null) {
            this.getContainer().setDirty(dirty);
        }
    }

    public int getAVTSortOrder() {
        return this.avtSortOrder;
    }

    public void setAVTSortOrder(int sortOrder) {
        this.avtSortOrder = sortOrder;
    }

    public List getNestedObjects() {
        return this.nestedObjects;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        DesignObject object = null;
        if ("structuredType".equalsIgnoreCase(propertyName)) {
            object = this.getDesign().getDataTypesDesign().getStructuredTypeSet().getObjectByID(id);
        } else if ("collectionType".equalsIgnoreCase(propertyName)) {
            object = this.getDesign().getDataTypesDesign().getCollectionTypeSet().getObjectByID(id);
        }
        if (object != null) {
            return object;
        }
        return super.translateIdToObject(propertyName, id);
    }

    public AVT createAVT() {
        return new AVT();
    }

    public List getAVTList() {
        ArrayList<AVT> list = new ArrayList<AVT>();
        for (AVT avt : this.getAVTs()) {
            list.add(avt);
        }
        return list;
    }

    public void applyAVTList(List avtList) {
        this.avts.clear();
        this.avts.addAll(avtList);
    }

    @Override
    public void setObjectID(String id) {
        String oldID = this.getObjectID();
        super.setObjectID(id);
        ContainerObject container = this.getContainer();
        if (container != null && oldID == null) {
            container.putInLocalIDMap(id, this);
        }
        if (container != null && id != null && oldID != null && !id.equals(oldID)) {
            container.updateLocalObjectId(oldID, id);
        }
    }

    public String getReferedAttribute() {
        return this.referedAttribute;
    }

    public void setReferedAttribute(String referedAttribute) {
        this.referedAttribute = referedAttribute;
    }

    public void setMandatory(boolean mandatory) {
        this.setNullsAllowed(!mandatory);
    }

    public boolean isMandatory() {
        return !this.getNullsAllowed();
    }

    @Override
    public boolean isRemoteObject() {
        if (this.getContainer() != null) {
            return this.getContainer().isRemoteObject();
        }
        return false;
    }

    public boolean isInOptionalFK() {
        return false;
    }

    public boolean isSurrogateColumn() {
        return false;
    }

    public void setCheckConstraintValue(String condition) {
        String checkPart = condition;
        if (!"".equals(checkPart)) {
            CheckConstraint cconstraint = this.getCheck();
            if (cconstraint == null) {
                cconstraint = new CheckConstraint();
            }
            cconstraint.add(GenericConstraint.getStaticInstance(), checkPart);
            this.setUseDomainConstraints(false);
            this.setCheck(cconstraint);
        }
    }

    private class AVTNumberComparator
    implements Comparator {
        private AVTNumberComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                double d1 = Double.parseDouble(((AVT)o1).getBeginValue());
                double d2 = Double.parseDouble(((AVT)o2).getBeginValue());
                if (d1 > d2) {
                    return 1;
                }
                if (d1 < d2) {
                    return -1;
                }
                return 0;
            }
            catch (Exception e) {
                return ((AVT)o1).getBeginValue().compareTo(((AVT)o2).getBeginValue());
            }
        }
    }
}

