/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.datatype.MDExplicitSized;

public abstract class MDPackedSized
extends MDExplicitSized {
    public static final int MAX_PRECISION = 31;
    protected int scale;
    protected int precision;
    protected String precisionStr = "";

    @Override
    public void setScale(int scale) {
        this.scale = scale;
        this.fireSizeChange();
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public void setPrecision(int precision) {
        this.precision = precision;
        this.precisionStr = String.valueOf(precision);
        this.fireSizeChange();
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public String getSize() {
        return Integer.toString(this.getPrecision() / 2 + 1);
    }

    @Override
    public boolean isPacked() {
        return true;
    }

    @Override
    public String getSQL() {
        StringBuffer b = new StringBuffer();
        this.appendTo(b);
        return b.toString();
    }

    @Override
    public void appendTo(StringBuffer buffer) {
        buffer.append(this.getName());
        boolean comma = false;
        if (this.getPrecision() > 0) {
            buffer.append(" (");
            buffer.append(this.getPrecisionStr());
            comma = true;
            if (this.getScale() > 0) {
                if (comma) {
                    buffer.append(',');
                }
                buffer.append(this.getScale());
            } else if ("*".equals(this.precisionStr) && this.hasScale()) {
                if (comma) {
                    buffer.append(',');
                }
                buffer.append(this.getScale());
            }
            buffer.append(')');
        }
    }

    @Override
    public boolean hasPrecision() {
        return true;
    }

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public String getPrecisionText() {
        return Messages.getString("MDPackedSized.Precision");
    }

    @Override
    public String getScaleText() {
        return Messages.getString("MDPackedSized.Scale");
    }

    @Override
    public String getPrecisionStr() {
        return this.precisionStr;
    }

    @Override
    public void setPrecisionStr(String precisionStr) {
        if (!"precision".equalsIgnoreCase(precisionStr)) {
            this.precisionStr = precisionStr;
            int pr = this.getMaxPrecision();
            try {
                pr = Integer.valueOf(this.precisionStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.precision = pr;
        }
    }

    public int getMaxPrecision() {
        return 38;
    }
}

