/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.mle_js;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.mle_js.MOHEnvironment;
import oracle.dbtools.crest.imports.metadata.mle_js.MOHModule;
import oracle.dbtools.crest.model.PropertiesObject;
import oracle.dbtools.mle_js.MLEEnvironment;
import oracle.dbtools.mle_js.MLEModule;
import oracle.dbtools.util.Closeables;

public class DBMExtractionHandlerMLE_JS {
    int release = 0;
    int version = 11;
    double dbVersion = 11.0;
    private Boolean dba = null;

    public DBMExtractionHandlerMLE_JS(Connection conn) {
        this.init(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void init(Connection conn) {
        ResultSet rs;
        PreparedStatement statement;
        block4: {
            String sql = "with\nfunction ver return number is\nbegin\n return dbms_db_version.version;\nend;\nfunction rel return number is\nbegin \n return dbms_db_version.release;\nend;\nselect ver version , rel release from dual";
            statement = null;
            rs = null;
            try {
                statement = conn.prepareStatement(sql);
                rs = statement.executeQuery();
                if (rs == null || !rs.next()) break block4;
                this.version = rs.getInt(1);
                this.release = rs.getInt(2);
                this.dbVersion = (double)this.version + (double)this.release / 10.0;
                rs.close();
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                catch (Throwable throwable2) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                    throw throwable2;
                }
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDbaAccess(Connection conn, List<String> names) {
        if (this.getDBVersion() >= 12.2 && names.size() > 0) {
            ResultSet rs;
            PreparedStatement statement;
            block7: {
                boolean bl;
                String sql1 = "WITH\n    FUNCTION HAS_DBA_ACCESS RETURN VARCHAR2 AS\n        NAME VARCHAR2(200);\n        TYPE TNAMES IS\n            VARRAY(40) OF VARCHAR2(128);\n        NAMES TNAMES := TNAMES(";
                String sql2 = ");\n    BEGIN\n        FOR I IN 1..NAMES.COUNT LOOP\n            NAME := SYS.DBMS_ASSERT.SQL_OBJECT_NAME(NAMES(I));\n        END LOOP;\n        RETURN 'true';\n    EXCEPTION\n        WHEN OTHERS THEN\n            RETURN 'false';\n    END;\nSELECT HAS_DBA_ACCESS FROM DUAL";
                String sql = null;
                for (String name : names) {
                    if (sql == null) {
                        sql = sql1 + "'" + name + "'";
                        continue;
                    }
                    sql = (String)sql + ",'" + name + "'";
                }
                sql = sql + sql2;
                statement = null;
                rs = null;
                try {
                    statement = conn.prepareStatement(sql);
                    rs = statement.executeQuery();
                    if (rs == null || !rs.next()) break block7;
                    String dba = rs.getString(1);
                    rs.close();
                    bl = "TRUE".equalsIgnoreCase(dba);
                }
                catch (Throwable e) {
                    try {
                        e.printStackTrace();
                        System.out.println(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                        throw throwable;
                    }
                    Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, statement});
                return bl;
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        }
        return false;
    }

    public boolean hasDbaAccess(Connection conn) {
        if (this.dba == null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("SYS.DBA_MLE_PROCEDURES");
            list.add("SYS.DBA_MLE_MODULES");
            list.add("SYS.DBA_MLE_ENVS");
            this.dba = this.hasDbaAccess(conn, list) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.dba;
    }

    public static void main(String[] args) {
    }

    public int getRelease() {
        return this.release;
    }

    public int getVersion() {
        return this.version;
    }

    public double getDBVersion() {
        return this.dbVersion;
    }

    public MLEModule getMLEModule(Connection conn, String owner, String name) {
        MOHModule moh = new MOHModule(this);
        DBObject dbo = new DBObject(true, name, "MODULE", owner);
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        list.add(dbo);
        List<PropertiesObject> res = null;
        try {
            res = moh.generate(conn, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res != null && res.size() == 1) {
            return (MLEModule)res.get(0);
        }
        return null;
    }

    public MLEEnvironment getMLEEnvironment(Connection conn, String owner, String name) {
        MOHEnvironment moh = new MOHEnvironment(this);
        DBObject dbo = new DBObject(true, name, "ENVIRONMENT", owner);
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        list.add(dbo);
        List<PropertiesObject> res = null;
        try {
            res = moh.generate(conn, list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res != null && res.size() == 1) {
            return (MLEEnvironment)res.get(0);
        }
        return null;
    }

    public PropertiesObject getMLEJSObject(Connection conn, String type, String owner, String name) {
        if (type != null) {
            switch (type.toUpperCase()) {
                case "MODULE": {
                    return this.getMLEModule(conn, owner, name);
                }
                case "ENVIRONMENT": {
                    return this.getMLEEnvironment(conn, owner, name);
                }
            }
        }
        return null;
    }
}

