/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.DBMExtractionHandlerOracle;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Join;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.JSONObjToStreamTransformer;
import oracle.dbtools.crest.model.metadata.MDTransformationManager;
import oracle.dbtools.crest.model.metadata.MetaFileLoader;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.persistence.LogicalDataTypesReader;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.util.Closeables;

public class Dependencies {
    static String PHYS_PROPS = "physicalProperties";
    static String LOCATIONS_AS_STRING = "locationsAsString";
    private static String webPath = "/WEB-INF/datamodeler";
    static String fact = "Fact";
    static String dimension = "Dimension";

    public static void main(String[] args) {
        Design.dmInternalsDistDir = "D:/Projects/DMWS/DistributedData/datamodeler";
        File file = new File("d:/sales_mv_log.json");
        try {
            FileInputStream is = new FileInputStream(file);
            if (is != null) {
                Object jdoc = null;
                try {
                    Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521/pdb1.osddm", "system", "system");
                    BufferedWriter out = new BufferedWriter(new OutputStreamWriter(System.out));
                    Dependencies.processTableDependenciesStarSchema(conn, out, "GLOBAL", "UNITS_FACT");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.error(e);
        }
    }

    public static void processTableDependenciesStarSchema(Connection conn, Writer osw, String schema, String item) {
        Design.dmInternalsDistDir = webPath;
        MetaFileLoader.DMWEB = true;
        Design des = Dependencies.getDesign(false, false, false);
        DBMExtractionHandlerOracle handler = new DBMExtractionHandlerOracle(des);
        handler.init(conn);
        ArrayList<Hlp> list = new ArrayList<Hlp>();
        Hlp h = new Hlp(schema, item);
        list.add(h);
        HashMap<String, Hlp> tables = new HashMap<String, Hlp>();
        tables.put(h.getID(), h);
        Dependencies.processTableDependenciesStarSchemaFK(conn, osw, schema, item, list, tables, handler.dbaUser);
        Dependencies.processTableDependenciesStarSchemaBJI(conn, osw, schema, item, list, tables, handler.dbaUser);
        Dependencies.processTableDependenciesStarSchemaMViews(conn, osw, schema, item, list, tables, handler.dbaUser);
        int ver = AbstractDBMExtractionHandler.getOracleVersionInt(conn);
        if (ver > 11) {
            Dependencies.processTableDependenciesStarSchemaAttributeClustering(conn, osw, schema, item, list, tables, handler.dbaUser);
        }
        if (ver > 12) {
            Dependencies.processTableDependenciesStarSchemaAnalyticViews(conn, osw, schema, item, list, tables, handler.dbaUser);
            Dependencies.processTableDependenciesStarSchemaOLAP(conn, osw, schema, item, list, tables, handler.dbaUser);
        }
        Dependencies.processTableDependenciesStarSchemaDimensions(conn, osw, schema, item, list, tables, handler.dbaUser);
        List<DBObject> objects = Dependencies.getDBObjects(list);
        Dependencies.returnDependenciesDetails(conn, osw, objects, des, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTableDependenciesStarSchemaBJI(Connection conn, Writer osw, String schema, String item, List<Hlp> list, Map<String, Hlp> tables, boolean dbaUser) {
        String sql = "select distinct inner_table_owner fowner, inner_table_name ftable,inner_table_column fcolumn,outer_table_owner downer,outer_table_name dtable, outer_table_column dcolumn  , index_owner, index_name  from all_join_ind_columns  where inner_table_owner = ? and inner_table_name = ?";
        if (dbaUser) {
            sql = "select distinct inner_table_owner fowner, inner_table_name ftable,inner_table_column fcolumn,outer_table_owner downer,outer_table_name dtable, outer_table_column dcolumn  , index_owner, index_name  from dba_join_ind_columns  where inner_table_owner = ? and inner_table_name = ?";
        }
        String type = "BJI/";
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, schema);
            ps.setString(2, item);
            try (ResultSet rs = ps.executeQuery();){
                if (rs != null) {
                    Hlp first = tables.get((schema + "." + item).toUpperCase());
                    if (first == null) {
                        first = new Hlp(schema, item);
                        tables.put(first.getID(), first);
                    }
                    if (first.type.isEmpty()) {
                        first.type = fact;
                    }
                    while (rs.next()) {
                        Hlp h;
                        Hlp h2;
                        String sch = rs.getString(1);
                        String name = rs.getString(2);
                        String column = rs.getString(3);
                        String dsch = rs.getString(4);
                        String dname = rs.getString(5);
                        String dcolumn = rs.getString(6);
                        String isch = rs.getString(7);
                        String iname = rs.getString(8);
                        if (fact.equalsIgnoreCase(first.type)) {
                            Join join = new Join(sch, name, column, dsch, dname, dcolumn);
                            join.addDiscoverySource(type + isch + "." + iname);
                            first.addJoin(join);
                        }
                        if ((h2 = tables.get((h = new Hlp(dsch, dname)).getID())) == null) {
                            h.type = dimension;
                            list.add(h);
                            tables.put(h.getID(), h);
                            continue;
                        }
                        h2.type = dimension;
                    }
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            Logger.error_("processTableDependencies() ", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    Logger.error_("processTableDependencies() ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTableDependenciesStarSchemaMViews(Connection conn, Writer osw, String schema, String item, List<Hlp> list, Map<String, Hlp> tables, boolean dbaUser) {
        String sql = "select distinct detailobj1_owner, detailobj1_relation, detailobj1_column, detailobj2_owner, detailobj2_relation, detailobj2_column \n , owner, mview_name, operator  from all_mview_joins \n where detailobj1_owner = ? and detailobj1_relation = ? and (owner,mview_name) in (select distinct owner,mview_name from all_mview_aggregates)";
        if (dbaUser) {
            sql = "select distinct detailobj1_owner, detailobj1_relation, detailobj1_column, detailobj2_owner, detailobj2_relation, detailobj2_column \n , owner, mview_name, operator  from dba_mview_joins \n where detailobj1_owner = ? and detailobj1_relation = ? and (owner,mview_name) in (select distinct owner,mview_name from all_mview_aggregates)";
        }
        String type = "MView/";
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, schema);
            ps.setString(2, item);
            try (ResultSet rs = ps.executeQuery();){
                if (rs != null) {
                    Hlp first = tables.get((schema + "." + item).toUpperCase());
                    if (first == null) {
                        first = new Hlp(schema, item);
                        tables.put(first.getID(), first);
                    }
                    if (first.type.isEmpty()) {
                        first.type = fact;
                    }
                    while (rs.next()) {
                        Hlp h;
                        Hlp h2;
                        String sch = rs.getString(1);
                        String name = rs.getString(2);
                        String column = rs.getString(3);
                        String dsch = rs.getString(4);
                        String dname = rs.getString(5);
                        String dcolumn = rs.getString(6);
                        String isch = rs.getString(7);
                        String iname = rs.getString(8);
                        if (fact.equalsIgnoreCase(first.type)) {
                            Join join = new Join(sch, name, column, dsch, dname, dcolumn);
                            join.addDiscoverySource(type + isch + "." + iname);
                            first.addJoin(join);
                        }
                        if ((h2 = tables.get((h = new Hlp(dsch, dname)).getID())) == null) {
                            h.type = dimension;
                            list.add(h);
                            tables.put(h.getID(), h);
                            continue;
                        }
                        h2.type = dimension;
                    }
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            Logger.error_("processTableDependencies() ", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    Logger.error_("processTableDependencies() ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTableDependenciesStarSchemaDimensions(Connection conn, Writer osw, String schema, String item, List<Hlp> list, Map<String, Hlp> tables, boolean dbaUser) {
        String sql = "with level1_col as\n(select k.owner, k.dimension_name, k.level_name, k.column_name from all_dim_level_key k,all_dim_child_of c\nwhere c.position=1 and c.owner= ? and c.owner=k.owner and c.child_level_name=k.level_name),\ndim_keys as\n(select /*+ MATERIALIZE */ distinct  d.detailobj_owner towner, d.detailobj_name tname, l.column_name, l.owner downer, l.dimension_name dname from level1_col l, all_dim_levels d \nwhere d.owner= ? and d.owner = l.owner and d.dimension_name = l.dimension_name and d.level_name = l.level_name)\nselect c.owner, c.table_name,c.column_name, d.towner,d.tname, d.column_name,d.downer, d.dname from all_tab_columns c, dim_keys d\nwhere c.owner = ? and c.table_name = ? and c.column_name = d.column_name";
        if (dbaUser) {
            sql = "with level1_col as\n(select k.owner, k.dimension_name, k.level_name, k.column_name from dba_dim_level_key k,dba_dim_child_of c\nwhere c.position=1 and c.owner= ? and c.owner=k.owner and c.child_level_name=k.level_name),\ndim_keys as\n(select /*+ MATERIALIZE */ distinct  d.detailobj_owner towner, d.detailobj_name tname, l.column_name, l.owner downer, l.dimension_name dname from level1_col l, dba_dim_levels d \nwhere d.owner= ? and d.owner = l.owner and d.dimension_name = l.dimension_name and d.level_name = l.level_name)\nselect c.owner, c.table_name,c.column_name, d.towner,d.tname, d.column_name,d.downer, d.dname from dba_tab_columns c, dim_keys d\nwhere c.owner = ? and c.table_name = ? and c.column_name = d.column_name";
        }
        String type = "Dimension_ColName/";
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, schema);
            ps.setString(2, schema);
            ps.setString(3, schema);
            ps.setString(4, item);
            try (ResultSet rs = ps.executeQuery();){
                if (rs != null) {
                    Hlp first = tables.get((schema + "." + item).toUpperCase());
                    if (first == null) {
                        first = new Hlp(schema, item);
                        tables.put(first.getID(), first);
                    }
                    if (first.type.isEmpty()) {
                        first.type = fact;
                    }
                    while (rs.next()) {
                        Hlp h;
                        Hlp h2;
                        String sch = rs.getString(1);
                        String name = rs.getString(2);
                        String column = rs.getString(3);
                        String dsch = rs.getString(4);
                        String dname = rs.getString(5);
                        String dcolumn = rs.getString(6);
                        String isch = rs.getString(7);
                        String iname = rs.getString(8);
                        if (fact.equalsIgnoreCase(first.type)) {
                            Join join = new Join(sch, name, column, dsch, dname, dcolumn);
                            join.addDiscoverySource(type + isch + "." + iname);
                            first.addJoin(join);
                        }
                        if ((h2 = tables.get((h = new Hlp(dsch, dname)).getID())) == null) {
                            h.type = dimension;
                            list.add(h);
                            tables.put(h.getID(), h);
                            continue;
                        }
                        h2.type = dimension;
                    }
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            Logger.error_("processTableDependencies() ", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    Logger.error_("processTableDependencies() ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTableDependenciesStarSchemaOLAP(Connection conn, Writer osw, String schema, String item, List<Hlp> list, Map<String, Hlp> tables, boolean dbaUser) {
        String sql = "with cube as \n (select /*+ MATERIALIZE */ a.owner,a.d_top_obj_name cube, b.p_obj_owner downer,b.p_top_obj_name dim from all_cube_dependencies a, all_cube_dependencies b\n where a.d_obj_type = 'CUBE MAP' and a.p_obj_owner = ? and a.p_top_obj_name = ? and a.owner = b.owner \n  and a.d_top_obj_name = b.d_top_obj_name and b.d_obj_type = 'DIMENSIONALITY'),\n fact_fks as \n (select distinct c.owner,c.cube,a.d_sub_obj_name2 dim,a.p_obj_owner fowner,a.p_top_obj_name ftable,a.p_sub_obj_name1 fcol from all_cube_dependencies a, cube c\n where a.owner = c.owner and c.cube = a.d_top_obj_name and a.d_obj_type = 'CUBE DIMENSIONALITY MAP' and a.p_obj_type = 'COLUMN'),\n dim_level as \n (select distinct c.owner,c.cube,a.d_sub_obj_name2 dim, a.p_sub_obj_name2 lev from all_cube_dependencies a, cube c\n where a.owner = c.owner and c.cube = a.d_top_obj_name and a.d_obj_type = 'CUBE DIMENSIONALITY MAP' and a.p_obj_type = 'HIERARCHY LEVEL'\n ),\n level_keys as\n (select distinct l.owner, l.dim, a.p_obj_owner dtowner,a.p_top_obj_name dtable,a.p_sub_obj_name1 dcol from all_cube_dependencies a, dim_level l\n where a.owner = l.owner and l.dim = a.d_top_obj_name and l.lev = a.d_sub_obj_name2 and a.d_obj_type = 'HIER LEVEL MAP' and a.p_obj_type = 'COLUMN'\n and a.dependency_type = 'KEY EXPRESSION'\n union\n select distinct l.downer, l.dim, a.p_obj_owner downer,a.p_top_obj_name dtable,a.p_sub_obj_name1 dcol from all_cube_dependencies a, cube l\n where a.owner = l.downer and l.dim = a.d_top_obj_name  and a.d_obj_type = 'SOLVED VALUE HIER MAP' and a.dependency_type = 'KEY EXPRESSION')\n select fowner, ftable, f.fcol,k.dtowner, k.dtable,k.dcol, f.owner, f.cube, f.dim from fact_fks f, level_keys k\n where k.owner = f.owner and k.dim = f.dim";
        if (dbaUser) {
            sql = " with cube as \n (select /*+ MATERIALIZE */ a.owner,a.d_top_obj_name cube, b.p_obj_owner downer,b.p_top_obj_name dim from dba_cube_dependencies a, dba_cube_dependencies b\n where a.d_obj_type = 'CUBE MAP' and a.p_obj_owner = ? and a.p_top_obj_name = ? and a.owner = b.owner \n  and a.d_top_obj_name = b.d_top_obj_name and b.d_obj_type = 'DIMENSIONALITY'),\n fact_fks as \n (select distinct c.owner,c.cube,a.d_sub_obj_name2 dim,a.p_obj_owner fowner,a.p_top_obj_name ftable,a.p_sub_obj_name1 fcol from dba_cube_dependencies a, cube c\n where a.owner = c.owner and c.cube = a.d_top_obj_name and a.d_obj_type = 'CUBE DIMENSIONALITY MAP' and a.p_obj_type = 'COLUMN'),\n dim_level as \n (select distinct c.owner,c.cube,a.d_sub_obj_name2 dim, a.p_sub_obj_name2 lev from dba_cube_dependencies a, cube c\n where a.owner = c.owner and c.cube = a.d_top_obj_name and a.d_obj_type = 'CUBE DIMENSIONALITY MAP' and a.p_obj_type = 'HIERARCHY LEVEL'\n ),\n level_keys as\n (select distinct l.owner, l.dim, a.p_obj_owner dtowner,a.p_top_obj_name dtable,a.p_sub_obj_name1 dcol from dba_cube_dependencies a, dim_level l\n where a.owner = l.owner and l.dim = a.d_top_obj_name and l.lev = a.d_sub_obj_name2 and a.d_obj_type = 'HIER LEVEL MAP' and a.p_obj_type = 'COLUMN'\n and a.dependency_type = 'KEY EXPRESSION'\n union\n select distinct l.downer, l.dim, a.p_obj_owner downer,a.p_top_obj_name dtable,a.p_sub_obj_name1 dcol from dba_cube_dependencies a, cube l\n where a.owner = l.downer and l.dim = a.d_top_obj_name  and a.d_obj_type = 'SOLVED VALUE HIER MAP' and a.dependency_type = 'KEY EXPRESSION' )\n --select * from dim_level;\n select fowner, ftable, f.fcol,k.dtowner, k.dtable,k.dcol, f.owner, f.cube, f.dim from fact_fks f, level_keys k\n where k.owner = f.owner and k.dim = f.dim";
        }
        String type = "OLAP-Cube/";
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, schema);
            ps.setString(2, item);
            try (ResultSet rs = ps.executeQuery();){
                if (rs != null) {
                    Hlp first = tables.get((schema + "." + item).toUpperCase());
                    if (first == null) {
                        first = new Hlp(schema, item);
                        tables.put(first.getID(), first);
                    }
                    if (first.type.isEmpty()) {
                        first.type = fact;
                    }
                    while (rs.next()) {
                        Hlp h;
                        Hlp h2;
                        String sch = rs.getString(1);
                        String name = rs.getString(2);
                        String column = rs.getString(3);
                        String dsch = rs.getString(4);
                        String dname = rs.getString(5);
                        String dcolumn = rs.getString(6);
                        String isch = rs.getString(7);
                        String iname = rs.getString(8);
                        String dim = rs.getString(9);
                        if (fact.equalsIgnoreCase(first.type)) {
                            Join join = new Join(sch, name, column, dsch, dname, dcolumn);
                            join.addDiscoverySource(type + isch + "." + iname + "/" + dim);
                            first.addJoin(join);
                        }
                        if ((h2 = tables.get((h = new Hlp(dsch, dname)).getID())) == null) {
                            h.type = dimension;
                            list.add(h);
                            tables.put(h.getID(), h);
                            continue;
                        }
                        h2.type = dimension;
                    }
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            Logger.error_("processTableDependencies() OLAP", e);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    Logger.error_("processTableDependencies() OLAP", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void processTableDependenciesStarSchemaAttributeClustering(Connection conn, Writer osw, String schema, String item, List<Hlp> list, Map<String, Hlp> tables, boolean dbaUser) {
        String sql = "select tab1_owner, tab1_name,tab1_column,tab2_owner, tab2_name,tab2_column, owner, table_name\n from all_clustering_joins\n where owner = ? and table_name = ?";
        if (dbaUser) {
            sql = "select tab1_owner, tab1_name,tab1_column,tab2_owner, tab2_name,tab2_column, owner, table_name\n from dba_clustering_joins\n where owner = ? and table_name = ?";
        }
        String type = "AtrClustering/";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, schema);
            ps.setString(2, item);
            rs = ps.executeQuery();
            if (rs != null) {
                Hlp first = tables.get((schema + "." + item).toUpperCase());
                if (first == null) {
                    first = new Hlp(schema, item);
                    tables.put(first.getID(), first);
                }
                if (first.type.isEmpty()) {
                    first.type = fact;
                }
                while (rs.next()) {
                    Hlp h;
                    Hlp h2;
                    String sch = rs.getString(1);
                    String name = rs.getString(2);
                    String column = rs.getString(3);
                    String dsch = rs.getString(4);
                    String dname = rs.getString(5);
                    String dcolumn = rs.getString(6);
                    String isch = rs.getString(7);
                    String iname = rs.getString(8);
                    if (fact.equalsIgnoreCase(first.type)) {
                        Join join = new Join(sch, name, column, dsch, dname, dcolumn);
                        join.addDiscoverySource(type + isch + "." + iname);
                        first.addJoin(join);
                    }
                    if ((h2 = tables.get((h = new Hlp(dsch, dname)).getID())) == null) {
                        h.type = dimension;
                        list.add(h);
                        tables.put(h.getID(), h);
                        continue;
                    }
                    h2.type = dimension;
                }
                rs.close();
            }
            Closeables.close((Object)rs);
            if (ps == null) return;
        }
        catch (SQLException e) {
            Logger.error_("processTableDependencies() ", e);
            return;
        }
        try {
            ps.close();
            return;
        }
        catch (SQLException e) {
            Logger.error_("processTableDependencies() ", e);
            return;
        }
        finally {
            Closeables.close(rs);
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    Logger.error_("processTableDependencies() ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void processTableDependenciesStarSchemaAnalyticViews(Connection conn, Writer osw, String schema, String item, List<Hlp> list, Map<String, Hlp> tables, boolean dbaUser) {
        type = "AnView/";
        cont_id = 0;
        sql1 = "select SYS_CONTEXT('USERENV', 'CON_ID') ID FROM DUAL";
        ps1 = null;
        rs = null;
        try {
            ps1 = conn.prepareStatement(sql1);
            rs = ps1.executeQuery();
            if (rs != null && rs.next()) {
                cont_id = rs.getInt(1);
            }
            rs.close();
        }
        catch (Exception e) {
            try {
                Logger.error_("Dependencies.Error in getting container ID", e);
            }
            catch (Throwable var13_16) {
                Closeables.close(rs);
                if (ps1 != null) {
                    try {
                        ps1.close();
                    }
                    catch (Exception e) {
                        Logger.error_("Dependencies.Error in getting container ID", e);
                    }
                }
                throw var13_16;
            }
            Closeables.close((Object)rs);
            if (ps1 != null) {
                try {
                    ps1.close();
                }
                catch (Exception e) {
                    Logger.error_("Dependencies.Error in getting container ID", e);
                }
            } else {
                ** GOTO lbl40
            }
        }
        Closeables.close((Object)rs);
        if (ps1 != null) {
            try {
                ps1.close();
            }
            catch (Exception e) {
                Logger.error_("Dependencies.Error in getting container ID", e);
            }
        }
        sql = "with fact_dim as\n (select v.table_owner fowner,v.table_name ftname, v.table_alias falias,v.owner vowner,v.analytic_view_name vname,\n  d.dimension_owner downer, d.dimension_name dname,d.dimension_alias dalias\n from all_analytic_views v, all_analytic_view_dimensions d\n where v.origin_con_id = ? and d.origin_con_id = v.origin_con_id and v.owner = d.owner and d.analytic_view_name = v.analytic_view_name\n  and v.table_owner = ? and v.table_name = ? ), \ndim_t as\n (select p.owner,p.dimension_name,p.table_owner, p.table_name, p.table_alias, a.attribute_name, a.column_name from all_attribute_dim_tables p, all_attribute_dim_attrs a\n where a.origin_con_id = ? and p.origin_con_id = a.origin_con_id and p.owner = a.owner and a.dimension_name = p.dimension_name\n  and a.table_alias = p.table_alias) \nselect distinct fowner,ftname,s.av_key_column fkcolumn,t.table_owner ref_table_owner,t.table_name ref_table_name, t.column_name ref_column,f.vowner,f.vname from fact_dim f, dim_t t, all_analytic_view_keys s\n where s.origin_con_id = ? and f.downer = t.owner and f.dname = t.dimension_name and f.vname = s.analytic_view_name and t.attribute_name=s.ref_dimension_attr \n  and dalias = s.dimension_alias and falias = s.av_key_table_alias ";
        if (dbaUser) {
            sql = "with fact_dim as\n (select v.table_owner fowner,v.table_name ftname, v.table_alias falias,v.owner vowner,v.analytic_view_name vname,\n  d.dimension_owner downer, d.dimension_name dname,d.dimension_alias dalias\n from dba_analytic_views v, dba_analytic_view_dimensions d\n where v.origin_con_id = ? and d.origin_con_id = v.origin_con_id and v.owner = d.owner and d.analytic_view_name = v.analytic_view_name\n  and v.table_owner = ? and v.table_name = ? ), \ndim_t as\n (select p.owner,p.dimension_name,p.table_owner, p.table_name, p.table_alias, a.attribute_name, a.column_name from dba_attribute_dim_tables p, dba_attribute_dim_attrs a\n where a.origin_con_id = ? and p.origin_con_id = a.origin_con_id and p.owner = a.owner and a.dimension_name = p.dimension_name\n  and a.table_alias = p.table_alias) \nselect distinct fowner,ftname,s.av_key_column fkcolumn,t.table_owner ref_table_owner,t.table_name ref_table_name, t.column_name ref_column,f.vowner,f.vname from fact_dim f, dim_t t, dba_analytic_view_keys s\n where s.origin_con_id = ? and f.downer = t.owner and f.dname = t.dimension_name and f.vname = s.analytic_view_name and t.attribute_name=s.ref_dimension_attr \n  and dalias = s.dimension_alias and falias = s.av_key_table_alias ";
        }
        ps = null;
        try {
            ps = conn.prepareStatement(sql);
            ps.setInt(1, cont_id);
            ps.setString(2, schema);
            ps.setString(3, item);
            ps.setInt(4, cont_id);
            ps.setInt(5, cont_id);
            rs = ps.executeQuery();
            if (rs != null) {
                first = tables.get((schema + "." + item).toUpperCase());
                if (first == null) {
                    first = new Hlp(schema, item);
                    tables.put(first.getID(), first);
                }
                if (first.type.isEmpty()) {
                    first.type = Dependencies.fact;
                }
                while (rs.next()) {
                    sch = rs.getString(1);
                    name = rs.getString(2);
                    column = rs.getString(3);
                    dsch = rs.getString(4);
                    dname = rs.getString(5);
                    dcolumn = rs.getString(6);
                    isch = rs.getString(7);
                    iname = rs.getString(8);
                    if (Dependencies.fact.equalsIgnoreCase(first.type)) {
                        join = new Join(sch, name, column, dsch, dname, dcolumn);
                        join.addDiscoverySource(type + isch + "." + iname);
                        first.addJoin(join);
                    }
                    if ((h2 = tables.get((h = new Hlp(dsch, dname)).getID())) == null) {
                        h.type = Dependencies.dimension;
                        list.add(h);
                        tables.put(h.getID(), h);
                        continue;
                    }
                    h2.type = Dependencies.dimension;
                }
                rs.close();
            }
        }
        catch (SQLException e) {
            Logger.error_("processTableDependencies() ", e);
        }
        finally {
            Closeables.close((Object)rs);
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    Logger.error_("processTableDependencies() ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void processTableDependenciesStarSchemaFK(Connection conn, Writer osw, String schema, String item, List<Hlp> list, Map<String, Hlp> tables, boolean dbaUser) {
        if (item == null) return;
        if (item.isEmpty()) return;
        StringBuffer sb = new StringBuffer();
        sb.append("with constr_join as \n");
        sb.append("  ( \n");
        sb.append("    select a.owner, \n");
        sb.append("      a.table_name, \n");
        sb.append("      a.CONSTRAINT_NAME, \n");
        sb.append("      a.R_OWNER, \n");
        sb.append("      a.R_CONSTRAINT_NAME, \n");
        sb.append("      B.TABLE_NAME as R_Table_name \n");
        if (dbaUser) {
            sb.append("    from DBA_CONSTRAINTS a, \n");
            sb.append("      DBA_CONSTRAINTS b \n");
        } else {
            sb.append("    from ALL_CONSTRAINTS a, \n");
            sb.append("      ALL_CONSTRAINTS b \n");
        }
        sb.append("    where A.R_OWNER = B.OWNER \n");
        sb.append("      and A.R_CONSTRAINT_NAME = B.CONSTRAINT_NAME \n");
        sb.append("  ) \n");
        sb.append("select R_OWNER, \n");
        sb.append("  R_TABLE_NAME \n");
        sb.append("from constr_join a \n");
        sb.append("where a.owner = ? \n");
        sb.append("  and a.table_name = ?");
        String sql = sb.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, schema);
            ps.setString(2, item);
            rs = ps.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String sch = rs.getString(1);
                    String name = rs.getString(2);
                    Hlp h = new Hlp(sch, name);
                    if (schema.equals(sch) && item.equals(name)) continue;
                    list.add(h);
                    tables.put(h.getID(), h);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
            if (ps == null) return;
        }
        catch (SQLException e) {
            Logger.error_("processTableDependencies() ", e);
            return;
        }
        try {
            ps.close();
            return;
        }
        catch (SQLException e) {
            Logger.error_("processTableDependencies() ", e);
            return;
        }
        finally {
            Closeables.close(rs);
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    Logger.error_("processTableDependencies() ", e);
                }
            }
        }
    }

    static List<DBObject> getDBObjects(List<Hlp> tables) {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (Hlp item : tables) {
            DBObject dbo = new DBObject(true, item.name, "TABLE", item.schema);
            dbo.dwhType = item.type;
            if (item.joins.size() > 0) {
                dbo.joins = new ArrayList<Join>(item.joins.values());
            }
            list.add(dbo);
        }
        return list;
    }

    static void returnDependenciesDetails(Connection conn, Writer osw, List<DBObject> objects, Design des, DBMExtractionHandlerOracle handler) {
        boolean physProps = false;
        RelationalDesign relModel = des.getRelationalDesign();
        relModel.setSelectedRDBMSSite(handler.getRDBMSSite());
        Dependencies.checkForExternalTables(conn, objects, handler.dbaUser);
        StorageDesign sd = relModel.getStorageDesign();
        sd.openStorageDesign();
        ImportLogger importLog = new ImportLogger();
        try {
            handler.generateDesign(conn, objects, importLog);
        }
        catch (Exception e) {
            Logger.error_("returnDependenciesDetails() ", e);
        }
        TableSet ts = relModel.getTableSet();
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<List> list2 = new ArrayList<List>();
        ArrayList l1 = new ArrayList();
        ts.addAllElementsTo(l1);
        list2.add(l1);
        types.add("items");
        if (ts.size() != objects.size()) {
            ArrayList<DBObject> views = new ArrayList<DBObject>();
            for (DBObject dbo : objects) {
                Table table = ts.getBySchemaAndName(dbo.getSchema(), dbo.getName());
                if (table != null) continue;
                DBObject obj = new DBObject(true, dbo.getName(), "VIEW", dbo.getSchema());
                obj.dwhType = dbo.dwhType;
                obj.joins = dbo.joins;
                views.add(obj);
            }
            if (views.size() > 0) {
                try {
                    handler.generateDesign(conn, views, importLog);
                }
                catch (Exception e) {
                    Logger.error_("returnDependenciesDetails() ", e);
                }
                relModel.getTableViewSet().addAllElementsTo(l1);
            }
        }
        Dependencies.transformObjectsToJson(osw, list2, types, physProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkForExternalTables(Connection conn, List<DBObject> objects, boolean dbaUser) {
        Statement statement_ext = null;
        ResultSet rs_ext = null;
        try {
            if (statement_ext == null) {
                String sql = "select 1 from " + (dbaUser ? "DBA_EXTERNAL_TABLES" : "ALL_EXTERNAL_TABLES") + " WHERE owner = ? AND table_name = ?";
                statement_ext = conn.prepareStatement(sql);
            }
            for (DBObject dbo : objects) {
                if (!dbo.getType().equalsIgnoreCase("TABLE")) continue;
                statement_ext.setString(1, dbo.getSchema());
                statement_ext.setString(2, dbo.getName());
                rs_ext = statement_ext.executeQuery();
                if (rs_ext == null) continue;
                if (rs_ext.next()) {
                    dbo.setType("EXTERNAL TABLE");
                }
                rs_ext.close();
            }
        }
        catch (Exception e) {
            Logger.error_("checkForExternalTables() ", e);
        }
        finally {
            Closeables.close(rs_ext);
            if (statement_ext != null) {
                try {
                    statement_ext.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private static void transformObjectsToJson(Writer osw, List<List> objects, List<String> types, boolean physProps) {
        try {
            MDTransformationManager trMan = XMLTransformationManager.getInstance().getMDTransformationManager();
            MDTransformationManager.TrObjects trs = trMan.getTransformersFor(Table.class);
            if (trs != null && trs.getFromObjectToJsonStreamTransformer() != null && trs.getFromObjectToJsonStreamTransformer() instanceof JSONObjToStreamTransformer) {
                ArrayList<String> list = new ArrayList<String>(JSONObjToStreamTransformer.POPERTIES_TO_SKIP);
                if (!physProps) {
                    if (!list.contains(PHYS_PROPS)) {
                        list.add(PHYS_PROPS);
                    }
                } else {
                    list.remove(PHYS_PROPS);
                }
                list.add(LOCATIONS_AS_STRING);
                ((JSONObjToStreamTransformer)trs.getFromObjectToJsonStreamTransformer()).transformFromListOfObjects(objects, types, osw, false, list);
            }
            osw.flush();
        }
        catch (Exception e) {
            Logger.error_("transformObjectsToJson() ", e);
        }
    }

    static Design getDesign(boolean allDetails, boolean triggers, boolean spatial) {
        Design des = new Design();
        LogicalDataTypesReader lr = new LogicalDataTypesReader();
        lr.recreateLogicalTypes(des);
        RelationalDesign relModel = des.addRelationalDesign();
        des.setRelationalDesign(relModel);
        des.setPropagatePKChahges(false);
        des.setImporting(true);
        des.setLoading(true);
        Settings s = des.getSettings();
        if (!allDetails) {
            s.setImportPartitions(false);
            s.setImportTriggers(false);
            s.setScanForUsedStructuredTypes(false);
            s.setImportSpatialProperties(false);
            s.setImportSecondaryTables(false);
        } else {
            s.setImportPartitions(true);
            s.setImportTriggers(triggers);
            s.setScanForUsedStructuredTypes(true);
            s.setImportSpatialProperties(spatial);
            s.setImportSecondaryTables(false);
        }
        return des;
    }

    static class Hlp {
        String schema;
        String name;
        String type = "";
        Map<String, Join> joins = new TreeMap<String, Join>();

        Hlp(String schema, String name) {
            this.schema = schema;
            this.name = name;
        }

        String getID() {
            return (this.schema + "." + this.name).toUpperCase();
        }

        public String toString() {
            return this.getID();
        }

        public void addJoin(Join join) {
            Join t = this.joins.get(join.getID());
            if (t != null) {
                t.addDiscoverySource(join.getDiscoverySource());
            } else {
                this.joins.put(join.getID(), join);
            }
        }
    }
}

