/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.domains;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.AbstractConstraint;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;

public class DomainPropertiesComparator
extends EngPropertiesComparator {
    private Domain left_co;
    private Domain right_co;
    private static String LOGICAL_AND_DATA_TYPES = "Logical Type / Data Type";

    DomainPropertiesComparator(Domain left_co, Domain right_co) {
        super(left_co, right_co);
        this.left_co = left_co;
        this.right_co = right_co;
        this.initPropertiesList();
    }

    private static String getType(Domain co) {
        String type = co.getDataType().toString();
        return type;
    }

    private void processDataType(Domain left_co, Domain right_co) {
        String left_log_t = left_co != null ? left_co.getLogicalDatatype().getName() : "";
        String right_log_t = right_co != null ? right_co.getLogicalDatatype().getName() : "";
        String left_type = left_co != null ? DomainPropertiesComparator.getType(left_co) : "";
        String right_type = right_co != null ? DomainPropertiesComparator.getType(right_co) : "";
        EngPropertyHolder ph = new EngPropertyHolder(LOGICAL_AND_DATA_TYPES);
        ph.setLeftValue(left_log_t + " / " + left_type);
        ph.setRightValue(right_log_t + " / " + right_type);
        if (left_co != null && right_co != null && !left_type.equalsIgnoreCase(right_type)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        EngPropertyHolder ph = new EngPropertyHolder(SYNONYM);
        ph.setLeftValue(this.left_co != null ? this.left_co.getSynonym() : "");
        ph.setRightValue(this.right_co != null ? this.right_co.getSynonym() : "");
        if (this.left_co != null && this.right_co != null && !this.left_co.getSynonym().equals(this.right_co.getSynonym())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        this.processDataType(this.left_co, this.right_co);
        this.propertiesList.add(this.createCheckConstrPH());
        this.propertiesList.add(this.createRangeConstrPH());
        this.propertiesList.add(this.createLOVConstraintPH());
        this.initCommentsAndNotes();
    }

    @Override
    protected void copyPropertiesFromLeftToRight() {
        if (this.left_co != null && this.right_co != null) {
            this.right_co.setTemporaryWriteable(true);
            super.copyPropertiesFromLeftToRight();
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(LOGICAL_AND_DATA_TYPES)) {
                    this.right_co.setLogicalDatatype(this.left_co.getLogicalDatatype());
                    this.right_co.setDataTypeParameter("precision", this.left_co.getDataTypeParameter("precision"));
                    this.right_co.setDataTypeParameter("scale", this.left_co.getDataTypeParameter("scale"));
                    this.right_co.setDataTypeParameter("size", this.left_co.getDataTypeParameter("size"));
                    continue;
                }
                if (ph.getName().equals(SYNONYM)) {
                    this.right_co.setSynonym(this.left_co.getSynonym());
                    continue;
                }
                if (ph.getName().equals(CHECK_CONSTRAINT)) {
                    DomainPropertiesComparator.copyCheckConstrant(this.left_co, this.right_co);
                    continue;
                }
                if (ph.getName().equals(RANGE_CONSTRAINT)) {
                    DomainPropertiesComparator.copyRangeConstrant(this.left_co, this.right_co);
                    continue;
                }
                if (!ph.getName().equals(LOV_CONSTRAINT)) continue;
                DomainPropertiesComparator.copyLOVConstrant(this.left_co, this.right_co);
            }
            this.right_co.setTemporaryWriteable(false);
        }
    }

    private EngPropertyHolder createCheckConstrPH() {
        EngPropertyHolder ph = new EngPropertyHolder(CHECK_CONSTRAINT);
        if (this.left_co != null && this.left_co.getCheck() != null) {
            CheckConstraint left_check = this.left_co.getCheck();
            ph.setLeftValue(left_check.toString());
        } else {
            ph.setLeftValue("");
        }
        if (this.right_co != null && this.right_co.getCheck() != null) {
            CheckConstraint right_check = this.right_co.getCheck();
            ph.setRightValue(right_check.toString());
        } else {
            ph.setRightValue("");
        }
        if (this.left_co != null && this.right_co != null && (this.left_co.getCheck() != null && this.right_co.getCheck() == null || this.left_co.getCheck() == null && this.right_co.getCheck() != null || (this.left_co.getCheck() != null || this.right_co.getCheck() != null) && !this.left_co.getCheck().equals(this.right_co.getCheck()))) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        return ph;
    }

    private EngPropertyHolder createLOVConstraintPH() {
        EngPropertyHolder ph = new EngPropertyHolder(LOV_CONSTRAINT);
        String leftValue = "";
        if (this.left_co != null && this.left_co.getValueList() != null) {
            ConstraintEnumeration left_check = this.left_co.getValueList();
            leftValue = left_check.getValuesAsString().replaceAll("'", "");
        }
        ph.setLeftValue(leftValue);
        String rightValue = "";
        if (this.right_co != null && this.right_co.getValueList() != null) {
            ConstraintEnumeration right_check = this.right_co.getValueList();
            rightValue = right_check.getValuesAsString().replaceAll("'", "");
        }
        ph.setRightValue(rightValue);
        if (this.left_co != null && this.right_co != null && !leftValue.equals(rightValue)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        return ph;
    }

    private EngPropertyHolder createRangeConstrPH() {
        EngPropertyHolder ph = new EngPropertyHolder(RANGE_CONSTRAINT);
        if (this.left_co != null) {
            ph.setLeftValue(this.getAVTsToString(this.left_co));
        } else {
            ph.setLeftValue("");
        }
        if (this.right_co != null) {
            ph.setRightValue(this.getAVTsToString(this.right_co));
        } else {
            ph.setRightValue("");
        }
        if (this.left_co != null && this.right_co != null && !this.haveEqualAVTs(this.left_co, this.right_co)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        return ph;
    }

    private String getAVTsToString(Domain co) {
        StringBuffer sb = new StringBuffer();
        for (AVT avt : co.getAVTs()) {
            sb.append(avt.toString()).append("\n ");
        }
        return sb.toString();
    }

    private boolean haveEqualAVTs(Domain left_co, Domain right_co) {
        Object[] right_ar;
        Object[] left_ar = left_co.getAVTs().toArray();
        if (left_ar.length != (right_ar = right_co.getAVTs().toArray()).length) {
            return false;
        }
        for (int i = 0; i < left_ar.length; ++i) {
            if (left_ar[i].equals(right_ar[i])) continue;
            return false;
        }
        return true;
    }

    public static void copyCheckConstrant(Domain left_dom, Domain right_dom) {
        CheckConstraint left_c = left_dom.getCheck();
        if (left_c == null) {
            right_dom.setCheck(null);
            return;
        }
        CheckConstraint right_c = right_dom.getCheck();
        if (right_c == null) {
            right_c = new CheckConstraint();
            right_c.setDesign(right_dom.getDesign());
        }
        right_dom.setCheck(right_c);
        left_c.copyTo(right_c);
    }

    public static void copyLOVConstrant(Domain left_dom, Domain right_dom) {
        ConstraintEnumeration left_c = left_dom.getValueList();
        if (left_c == null) {
            right_dom.setValueList(null);
            return;
        }
        ConstraintEnumeration right_c = right_dom.getValueList();
        if (right_c == null) {
            right_c = new ConstraintEnumeration();
            right_c.setDesign(right_dom.getDesign());
        }
        right_dom.setValueList(right_c);
        ((AbstractConstraint)left_c).copyTo(right_c);
    }

    public static void copyRangeConstrant(Domain left_dom, Domain right_dom) {
        right_dom.setAVTSortOrder(left_dom.getAVTSortOrder());
        Iterator it = left_dom.getAVTs().iterator();
        right_dom.clearAVTs();
        while (it.hasNext()) {
            AVT avt = (AVT)it.next();
            AVT newAVT = new AVT(avt.getBeginValue(), avt.getEndValue(), avt.getDescription());
            right_dom.addAVT(newAVT);
        }
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
    }
}

