/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.exports.ddl.oracle.v9i.SSBIndexOraclev9i;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;

public class SSBSpatialTableOraclev9i
extends AbstractSSBOracle {
    private SSBIndexOraclev9i ssbIndex = null;
    private Object sType;
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        if (((ModelIDObject)object).isMarkedGenerate()) {
            Table table = null;
            TableProxyOracle tableProxy = null;
            if (object instanceof TableProxyOracle) {
                tableProxy = (TableProxyOracle)object;
                table = (Table)tableProxy.getObject();
                this.storageDesign = tableProxy.getStorageDesign();
            } else if (object instanceof Table) {
                table = (Table)object;
                Design design = table.getDesign();
                RDBMSSite site = table.getSelectedRDBMSSite();
                this.storageDesign = design.getStorageDesign(site, table);
                tableProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
            }
            if (table != null && table.isSpatialTable() && !table.getSpatialDefinitions().isEmpty()) {
                for (SpatialColumnDefObject spObjects : table.getSpatialDefinitions()) {
                    if (spObjects.getSpatialColumn() == null && !spObjects.isFunction()) continue;
                    this.appendRegisterSpatialTable(buffer, table, tableProxy, spObjects, prettyPrint);
                    this.appendSpatialIndex(buffer, spObjects, prettyPrint);
                }
            }
        }
    }

    private void appendRegisterSpatialTable(StringBuffer oldbuffer, Table table, TableProxyOracle tableProxy, SpatialColumnDefObject spObjects, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        SSBSpatialTableOraclev9i.appendNewLine(oldbuffer, prettyPrint, 0);
        SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, "INSERT");
        SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, "INTO");
        SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, "USER_SDO_GEOM_METADATA");
        String advancedComment = buffer.toString();
        this.appendSpatialColumnDefinition(buffer, table, tableProxy, spObjects, prettyPrint);
        this.appendFunctionDefinition(buffer, table, tableProxy, spObjects, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBSpatialTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        SSBSpatialTableOraclev9i.appendLineFinisher(buffer, prettyPrint);
        SSBSpatialTableOraclev9i.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
    }

    private void appendFunctionDefinition(StringBuffer buffer, Table table, TableProxyOracle tableProxy, SpatialColumnDefObject spObjects, boolean prettyPrint) {
        if (spObjects.isFunction()) {
            SSBSpatialTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSpatialTableOraclev9i.appendString(buffer, "VALUES");
            SSBSpatialTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, '(');
            SSBSpatialTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBSpatialTableOraclev9i.appendString(buffer, '\'');
            if (tableProxy != null) {
                SSBSpatialTableOraclev9i.appendString(buffer, this.storageDesign.getFormatedName(tableProxy));
            } else {
                SSBSpatialTableOraclev9i.appendString(buffer, this.storageDesign.getFormatedName(table));
            }
            SSBSpatialTableOraclev9i.appendString(buffer, '\'');
            SSBSpatialTableOraclev9i.appendString(buffer, ',');
            SSBSpatialTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            SSBSpatialTableOraclev9i.appendString(buffer, '\'');
            SSBSpatialTableOraclev9i.appendString(buffer, spObjects.getFuncExpression());
            SSBSpatialTableOraclev9i.appendString(buffer, '\'');
            SSBSpatialTableOraclev9i.appendString(buffer, ',');
            SSBSpatialTableOraclev9i.appendSpace(buffer);
            this.appendTableDimensional(buffer, spObjects, prettyPrint);
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, ',');
            SSBSpatialTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            if (spObjects.getSystemID() == null || spObjects.getSystemID().trim().equals("")) {
                SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, "NULL");
            } else {
                SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, spObjects.getSystemID());
            }
            SSBSpatialTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSpatialTableOraclev9i.appendString(buffer, ')');
        }
    }

    private void appendSpatialColumnDefinition(StringBuffer buffer, Table table, TableProxyOracle tableProxy, SpatialColumnDefObject spObjects, boolean prettyPrint) {
        if (spObjects.getSpatialColumn() != null) {
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, '(');
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, "TABLE_NAME");
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, ',');
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, "COLUMN_NAME");
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, ',');
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, "DIMINFO");
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, ',');
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, "SRID");
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, ')');
            SSBSpatialTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, "VALUES");
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, '(');
            SSBSpatialTableOraclev9i.appendString(buffer, '\'');
            if (tableProxy != null) {
                SSBSpatialTableOraclev9i.appendString(buffer, this.storageDesign.getFormatedName(tableProxy));
            } else {
                SSBSpatialTableOraclev9i.appendString(buffer, this.storageDesign.getFormatedName(table));
            }
            SSBSpatialTableOraclev9i.appendString(buffer, '\'');
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, ',');
            SSBSpatialTableOraclev9i.appendString(buffer, '\'');
            Datatype colType = spObjects.getSpatialColumn().getDataType();
            String columnName = this.storageDesign.getFormatedName(spObjects.getSpatialColumn());
            if (this.sType == null) {
                this.sType = this.storageDesign.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName("SDO_GEOMETRY");
            }
            if (colType instanceof StructuredType) {
                StructuredType st = (StructuredType)colType;
                for (TypeElement te : st.getAllElements()) {
                    if (te.getType() != this.sType) continue;
                    columnName = columnName.concat(".").concat(this.storageDesign.getFormatedName(te));
                    break;
                }
            }
            SSBSpatialTableOraclev9i.appendString(buffer, columnName);
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, '\'');
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, ',');
            this.appendTableDimensional(buffer, spObjects, prettyPrint);
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, ',');
            SSBSpatialTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
            if (spObjects.getSystemID() == null || spObjects.getSystemID().trim().equals("")) {
                SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, "NULL");
            } else {
                SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, spObjects.getSystemID());
            }
            SSBSpatialTableOraclev9i.appendNewLine(buffer, prettyPrint, 1);
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendTableDimensional(StringBuffer buffer, SpatialColumnDefObject spObjects, boolean prettyPrint) {
        SSBSpatialTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
        SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, "MDSYS.SDO_DIM_ARRAY");
        SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, '(');
        Iterator it = spObjects.getTableDimensions().iterator();
        while (it.hasNext()) {
            SpatialColumnDefObject.TableDimension td = (SpatialColumnDefObject.TableDimension)it.next();
            SSBSpatialTableOraclev9i.appendNewLine(buffer, prettyPrint, 3);
            SSBSpatialTableOraclev9i.appendStringWithSpace(buffer, "MDSYS.SDO_DIM_ELEMENT");
            SSBSpatialTableOraclev9i.appendString(buffer, '(');
            SSBSpatialTableOraclev9i.appendString(buffer, '\'');
            SSBSpatialTableOraclev9i.appendString(buffer, this.storageDesign.getFormatedName(td.getName()));
            SSBSpatialTableOraclev9i.appendString(buffer, '\'');
            SSBSpatialTableOraclev9i.appendString(buffer, ',');
            SSBSpatialTableOraclev9i.appendString(buffer, td.getLowBoundary());
            SSBSpatialTableOraclev9i.appendString(buffer, ',');
            SSBSpatialTableOraclev9i.appendString(buffer, td.getUpperBoundary());
            SSBSpatialTableOraclev9i.appendString(buffer, ',');
            SSBSpatialTableOraclev9i.appendString(buffer, td.getTolerance());
            SSBSpatialTableOraclev9i.appendString(buffer, ')');
            if (!it.hasNext()) continue;
            SSBSpatialTableOraclev9i.appendString(buffer, ',');
        }
        SSBSpatialTableOraclev9i.appendNewLine(buffer, prettyPrint, 2);
        SSBSpatialTableOraclev9i.appendString(buffer, ')');
    }

    protected void appendSpatialIndex(StringBuffer buffer, SpatialColumnDefObject spObjects, boolean prettyPrint) {
        Index object = spObjects.getSpatialIndex();
        if (this.ssbIndex == null) {
            this.ssbIndex = new SSBIndexOraclev9i();
        }
        if (this.ssbIndex.canHandle(object)) {
            this.ssbIndex.doAppend(buffer, object, prettyPrint);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableProxyOracle || object instanceof Table;
    }
}

