/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ExternalTableColumnOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ExternalTableOraclev10g;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBExternalTableOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        ExternalTableOraclev10g table = (ExternalTableOraclev10g)object;
        this.storageDesign = table.getStorageDesign();
        if (table.getColumns().size() != 0) {
            this.appendPrompt(buffer, table, "TABLE");
            this.appendComment(oldbuffer, table);
            this.appendCreate(buffer, table);
            advancedComment = buffer.toString();
            this.appendElementList(buffer, table, prettyPrint);
            this.appendExternalTableClause(buffer, table, prettyPrint);
            this.appendRejectLimit(buffer, table, prettyPrint);
            this.appendParallel(buffer, table, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            SSBExternalTableOraclev10g.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.appendPermissions(oldbuffer, table);
            this.incrementCreateTable();
        } else {
            SSBExternalTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            oldbuffer.append("-- Error - External table ");
            oldbuffer.append(this.storageDesign.getFormatedLongNameDDL(table));
            oldbuffer.append(" has no columns");
            this.incrementErrors();
            SSBExternalTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            SSBExternalTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        }
    }

    private void appendCreate(StringBuffer buffer, ExternalTableOraclev10g table) {
        SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "CREATE");
        SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "TABLE");
        SSBExternalTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(table));
    }

    private void appendElementList(StringBuffer buffer, ExternalTableOraclev10g table, boolean prettyPrint) {
        SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        StorageObjectCollection columns = table.getColumns();
        ExternalTableColumnOraclev10g column = null;
        for (int i = 0; i < columns.size(); ++i) {
            if (i == 0) {
                SSBExternalTableOraclev10g.appendStringWithSpace(buffer, '(');
                SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            } else {
                SSBExternalTableOraclev10g.appendStringWithSpace(buffer, ',');
                SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            }
            column = (ExternalTableColumnOraclev10g)columns.getElement(i);
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(column));
            String colDatatype = column.getDatatype();
            if (colDatatype.startsWith("TIMESTAMP")) {
                SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "TIMESTAMP");
                if (column.getPrecision() > 0) {
                    buffer.append('(').append(column.getPrecision());
                    SSBExternalTableOraclev10g.appendStringWithSpace(buffer, ')');
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append('(').append("6");
                    SSBExternalTableOraclev10g.appendStringWithSpace(buffer, ')');
                }
                if (colDatatype.indexOf("WITH") <= -1) continue;
                SSBExternalTableOraclev10g.appendStringWithSpace(buffer, colDatatype.substring(10));
                continue;
            }
            if (colDatatype.equalsIgnoreCase("INTERVAL YEAR TO MONTH")) {
                SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "INTERVAL YEAR");
                if (column.getPrecision() > 0) {
                    buffer.append('(').append(column.getPrecision());
                    SSBExternalTableOraclev10g.appendStringWithSpace(buffer, ')');
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append('(').append("2");
                    SSBExternalTableOraclev10g.appendStringWithSpace(buffer, ')');
                }
                SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "TO MONTH");
                continue;
            }
            if (colDatatype.equalsIgnoreCase("INTERVAL DAY TO SECOND")) {
                SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "INTERVAL DAY");
                if (column.getPrecision() > 0) {
                    buffer.append('(').append(column.getPrecision());
                    SSBExternalTableOraclev10g.appendStringWithSpace(buffer, ')');
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append('(').append("2");
                    SSBExternalTableOraclev10g.appendStringWithSpace(buffer, ')');
                }
                SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "TO SECOND");
                if (column.getScale() > 0) {
                    buffer.append('(').append(column.getScale());
                    SSBExternalTableOraclev10g.appendStringWithSpace(buffer, ')');
                    continue;
                }
                if (!this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) continue;
                buffer.append('(').append("6");
                SSBExternalTableOraclev10g.appendStringWithSpace(buffer, ')');
                continue;
            }
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, colDatatype);
            if (colDatatype.indexOf("CHAR") > -1 || colDatatype.equals("RAW") || colDatatype.equals("UROWID")) {
                if (column.getSize() > 0) {
                    buffer.append('(').append(column.getSize());
                    if (!column.getUnits().equalsIgnoreCase("") && (colDatatype.equalsIgnoreCase("CHAR") || colDatatype.equalsIgnoreCase("VARCHAR2") || colDatatype.equalsIgnoreCase("VARCHAR"))) {
                        buffer.append(' ').append(column.getUnits());
                    }
                    SSBExternalTableOraclev10g.appendStringWithSpace(buffer, ')');
                    continue;
                }
                if ((colDatatype.equals("CHAR") || colDatatype.equals("NCHAR")) && this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    buffer.append('(').append("1");
                    SSBExternalTableOraclev10g.appendStringWithSpace(buffer, ')');
                    continue;
                }
                if (!colDatatype.equals("UROWID") || !this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) continue;
                buffer.append('(').append("4000");
                SSBExternalTableOraclev10g.appendStringWithSpace(buffer, ')');
                continue;
            }
            if (column.getPrecision() <= 0) continue;
            buffer.append('(').append(column.getPrecision());
            if (column.getScale() != 0) {
                SSBExternalTableOraclev10g.appendStringWithSpace(buffer, ',');
                buffer.append(column.getScale());
            }
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
        SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBExternalTableOraclev10g.appendStringWithSpace(buffer, ')');
    }

    private void appendExternalTableClause(StringBuffer buffer, ExternalTableOraclev10g table, boolean prettyPrint) {
        SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "ORGANIZATION");
        SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "EXTERNAL");
        SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBExternalTableOraclev10g.appendStringWithSpace(buffer, '(');
        if (!"".equalsIgnoreCase(table.getAccessDriverType().trim())) {
            SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "TYPE");
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, table.getAccessDriverType());
        }
        if (table.getDefaultDir() != null) {
            SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "DIRECTORY");
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(table.getDefaultDir()));
        }
        if (table.getAccessParametersType().equalsIgnoreCase("Opaque Format Spec")) {
            SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "ACCESS");
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "PARAMETERS");
            SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, '(');
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, table.getOpaqueFormatSpec());
            SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, ')');
        } else if (table.getAccessParametersType().equalsIgnoreCase("CLOB Subquery")) {
            SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "ACCESS");
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "PARAMETERS");
            SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "USING");
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "CLOB");
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, table.getClobSubquery());
        }
        SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "LOCATION");
        SSBExternalTableOraclev10g.appendStringWithSpace(buffer, '(');
        if (!table.getLocation().startsWith("'")) {
            SSBExternalTableOraclev10g.appendString(buffer, '\'');
        }
        SSBExternalTableOraclev10g.appendString(buffer, table.getLocation());
        if (!table.getLocation().endsWith("'")) {
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, '\'');
        }
        SSBExternalTableOraclev10g.appendStringWithSpace(buffer, ')');
        SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        SSBExternalTableOraclev10g.appendStringWithSpace(buffer, ')');
    }

    private void appendParallel(StringBuffer buffer, ExternalTableOraclev10g table, boolean prettyPrint) {
        if (table.getParallel().equalsIgnoreCase("PARALLEL")) {
            SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "PARALLEL");
            int parallelNum = table.getParallelNum();
            if (parallelNum > 0) {
                SSBExternalTableOraclev10g.appendStringWithSpace(buffer, parallelNum);
            }
        } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
            SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "NOPARALLEL");
        }
    }

    private void appendRejectLimit(StringBuffer buffer, ExternalTableOraclev10g table, boolean prettyPrint) {
        String rejectLimit = table.getRejectLimit();
        if (rejectLimit.length() > 0) {
            SSBExternalTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "REJECT");
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "LIMIT");
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, rejectLimit);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof ExternalTableOraclev10g && ((ExternalTableOraclev10g)object).isMarkedGenerate();
    }

    protected void appendPermissions(StringBuffer oldBuffer, ExternalTableOracle externalTableOracle) {
        StorageDesignOracle storageDesignOracle = externalTableOracle.getStorageDesignOracle();
        StringBuffer buffer = new StringBuffer();
        PermissionsSetOracle permissionsSet = storageDesignOracle.getPermissionsSet();
        for (PermissionsOracle permissions : permissionsSet) {
            if (!externalTableOracle.equals(permissions.getExternalTableOracle()) || permissions.getUser() == null && permissions.getRole() == null) continue;
            if (StringUtilities.isNotEmpty(permissions.getPrivileges())) {
                this.appendPrivileges(oldBuffer, buffer, permissions, externalTableOracle, storageDesignOracle, false);
            }
            if (!StringUtilities.isNotEmpty(permissions.getPrivilegesWithGrantOption())) continue;
            this.appendPrivileges(oldBuffer, buffer, permissions, externalTableOracle, storageDesignOracle, true);
        }
    }

    private void appendPrivileges(StringBuffer oldBuffer, StringBuffer buffer, PermissionsOracle permissions, ExternalTableOracle externalTableOracle, StorageDesignOracle storageDesignOracle, boolean withGrantOption) {
        buffer.append(NEWLINE);
        this.appendComment(buffer, permissions);
        SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "GRANT");
        if (withGrantOption) {
            buffer.append(permissions.getPrivilegesWithGrantOption());
        } else {
            buffer.append(permissions.getPrivileges());
        }
        this.appendObject(buffer, externalTableOracle, storageDesignOracle);
        this.appendTo(buffer, permissions, storageDesignOracle);
        if (withGrantOption) {
            this.appendGrantOption(buffer, permissions);
        }
        String advancedComment = buffer.toString();
        buffer.append(NEWLINE);
        buffer.append(';');
        buffer.append(NEWLINE);
        this.appendToBuffer(oldBuffer, buffer, advancedComment);
    }

    private void appendObject(StringBuffer buffer, ExternalTableOracle externalTableOracle, StorageDesign storageDesign) {
        buffer.append(NEWLINE);
        SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "ON");
        SSBExternalTableOraclev10g.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(externalTableOracle));
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOracle permissions) {
        if (permissions.getRole() == null) {
            SSBExternalTableOraclev10g.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }
}

