/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ano;

import java.io.IOException;
import java.util.Vector;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.net.ano.Ano;
import oracle.net.ano.AnoComm;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public abstract class Service
implements SQLnetDef,
Diagnosable {
    static final int AUTHENTICATION = 1;
    static final int ENCRYPTION = 2;
    static final int DATAINTEGRITY = 3;
    static final int SUPERVISOR = 4;
    static final String[] SERVICES_CLASSNAME = new String[]{"", "SupervisorService", "AuthenticationService", "EncryptionService", "DataIntegrityService"};
    protected Ano ano;
    protected AnoComm comm;
    protected SessionAtts sAtts;
    protected int level;
    protected int[] userChoiceDriversId;
    protected byte[] selectedDrivers;
    protected int service;
    protected long version;
    protected short algID;

    int init(SessionAtts sAtts) throws NetException {
        this.sAtts = sAtts;
        this.ano = sAtts.ano;
        this.comm = sAtts.ano.anoComm;
        this.level = 0;
        this.selectedDrivers = new byte[0];
        return 1;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.sAtts.getDiagnosable();
    }

    void verifyInit(String[] drivers) throws NetException {
    }

    void sendHeader(int serviceSubPackets) throws NetException, IOException {
        this.comm.writeUB2(this.service);
        this.comm.writeUB2(serviceSubPackets);
        this.comm.writeUB4(0L);
    }

    void sendServiceData() throws NetException, IOException {
        this.sendHeader(2);
        this.comm.sendVersion();
        this.comm.sendRaw(this.selectedDrivers);
    }

    int getServiceDataLength() {
        return 12 + this.selectedDrivers.length;
    }

    abstract void receiveServiceData(int var1) throws NetException, IOException;

    abstract void validateResponse() throws NetException, IOException;

    void activateAlgorithm() throws NetException, IOException {
    }

    int howManyBytesNeeded() {
        return 8 + this.getServiceDataLength();
    }

    static int[] receiveHeader(AnoComm comm) throws NetException, IOException {
        int receivedServiceL = comm.readUB2();
        int numSubPacketsL = comm.readUB2();
        int oracleErrorL = (int)comm.readUB4();
        int[] ret = new int[]{receivedServiceL, numSubPacketsL, oracleErrorL};
        return ret;
    }

    void receiveSelection(int numSubPackets) throws NetException, IOException {
        this.receiveServiceData(numSubPackets);
        this.validateResponse();
    }

    int[] createDriversListWithLevel(int[] userChoiceDriversId, int level) throws NetException {
        int[] ret = null;
        switch (level) {
            case 0: {
                ret = new int[userChoiceDriversId.length + 1];
                ret[0] = 0;
                for (int i = 0; i < userChoiceDriversId.length; ++i) {
                    ret[i + 1] = userChoiceDriversId[i];
                }
                break;
            }
            case 1: {
                ret = new int[]{0};
                break;
            }
            case 2: {
                int i = 0;
                ret = new int[userChoiceDriversId.length + 1];
                for (i = 0; i < userChoiceDriversId.length; ++i) {
                    ret[i] = userChoiceDriversId[i];
                }
                ret[i] = 0;
                break;
            }
            case 3: {
                ret = userChoiceDriversId;
                break;
            }
            default: {
                throw new NetException(18904);
            }
        }
        return ret;
    }

    String[] getValidUserChoices(String[] userList, String[] availList) throws NetException {
        if (userList == null || userList.length == 0) {
            if (availList[0] == "") {
                userList = new String[availList.length - 1];
                for (int i = 0; i < userList.length; ++i) {
                    userList[i] = availList[i + 1];
                }
            } else {
                userList = availList;
            }
        }
        Vector<String> vec = new Vector<String>(10);
        for (int i = 0; i < userList.length; ++i) {
            int j;
            if (userList[i].equals("")) {
                throw new NetException(18903);
            }
            for (j = 0; j < availList.length; ++j) {
                if (!availList[j].equalsIgnoreCase(userList[i])) continue;
                vec.addElement(availList[j]);
                break;
            }
            if (j != availList.length) continue;
            throw new NetException(18903);
        }
        int vec_size = vec.size();
        String[] finalList = new String[vec_size];
        for (int i = 0; i < vec_size; ++i) {
            finalList[i] = (String)vec.elementAt(i);
        }
        return finalList;
    }

    byte getDriverID(String[] driverClasses, String str) throws NetException {
        for (byte i = 0; i < driverClasses.length; i = (byte)(i + 1)) {
            if (!str.equals(driverClasses[i])) continue;
            return i;
        }
        throw new NetException(18909);
    }

    public static String getLevelString(int level) throws NetException {
        String sLevel;
        switch (level) {
            case 0: {
                sLevel = "ACCEPTED";
                break;
            }
            case 1: {
                sLevel = "REJECTED";
                break;
            }
            case 2: {
                sLevel = "REQUESTED";
                break;
            }
            case 3: {
                sLevel = "REQUIRED";
                break;
            }
            default: {
                throw new NetException(18922);
            }
        }
        return sLevel;
    }

    public static String getServiceName(int service) throws NetException {
        String serviceName;
        switch (service) {
            case 1: {
                serviceName = "AUTHENTICATION";
                break;
            }
            case 2: {
                serviceName = "ENCRYPTION";
                break;
            }
            case 3: {
                serviceName = "DATAINTEGRITY";
                break;
            }
            case 4: {
                serviceName = "SUPERVISOR";
                break;
            }
            default: {
                throw new NetException(18923);
            }
        }
        return serviceName;
    }

    public boolean isActive() {
        return false;
    }
}

