/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl.cache;

import oracle.soda.rdbms.impl.cache.CacheOfDescriptorCaches;
import oracle.soda.rdbms.impl.cache.DescriptorCache;
import oracle.soda.rdbms.impl.cache.LRUCache;
import oracle.soda.rdbms.impl.cache.SynchronizedDescriptorCache;

public class SynchronizedCacheOfDescriptorCaches
implements CacheOfDescriptorCaches {
    private final LRUCache<String, DescriptorCache> cacheOfDescriptorCaches;
    private final int numberOfDescriptors;

    public SynchronizedCacheOfDescriptorCaches(int n, int n2) {
        this.cacheOfDescriptorCaches = new LRUCache(n);
        this.numberOfDescriptors = n2;
    }

    @Override
    public synchronized DescriptorCache putIfAbsentAndGet(String string) {
        if (this.cacheOfDescriptorCaches.containsKey(string)) {
            return (DescriptorCache)this.cacheOfDescriptorCaches.get(string);
        }
        SynchronizedDescriptorCache synchronizedDescriptorCache = new SynchronizedDescriptorCache(this.numberOfDescriptors);
        this.cacheOfDescriptorCaches.put(string, synchronizedDescriptorCache);
        return synchronizedDescriptorCache;
    }

    @Override
    public synchronized DescriptorCache remove(String string) {
        return (DescriptorCache)this.cacheOfDescriptorCaches.remove(string);
    }

    @Override
    public synchronized void clear() {
        for (DescriptorCache descriptorCache : this.cacheOfDescriptorCaches.values()) {
            descriptorCache.clear();
        }
    }

    @Override
    public synchronized void clear(String string) {
        DescriptorCache descriptorCache = (DescriptorCache)this.cacheOfDescriptorCaches.get(string);
        if (descriptorCache != null) {
            descriptorCache.clear();
        }
    }
}

