/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import jakarta.json.JsonException;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.io.InputStream;
import java.math.BigDecimal;
import oracle.json.common.JsonFactoryProvider;
import oracle.json.parser.DocumentLoader;
import oracle.json.parser.OrderBySpecification;

public class FilterLoader
extends DocumentLoader {
    private boolean parseOrderBy = false;
    private boolean orderByParsed = false;
    static final String MULTIPLE_ORDERBY_OPS = "SODA FOR JAVA: ENCOUNTERED MULTIPLE $orderby";
    private boolean queryParsed = false;
    static final String MULTIPLE_QUERY_OPS = "SODA FOR JAVA: ENCOUNTERED MULTIPLE $query";
    public static final String ORDERBY = "$orderby";
    public static final String QUERY = "$query";
    private OrderBySpecification orderBySpec = new OrderBySpecification();

    public FilterLoader(JsonFactoryProvider jsonFactoryProvider, InputStream inputStream) throws JsonException {
        super(jsonFactoryProvider, inputStream);
    }

    @Override
    protected JsonObjectBuilder parseObject(int n) throws JsonParsingException {
        JsonObjectBuilder jsonObjectBuilder = this.jProvider.createObjectBuilder();
        String string = null;
        String string2 = null;
        block11: while (this.parser.hasNext()) {
            JsonParser.Event event = this.parser.next();
            switch (event) {
                case START_OBJECT: {
                    if (n == 0) {
                        this.parseOrderBy = ORDERBY.equals(string);
                    }
                    jsonObjectBuilder.add(string, this.parseObject(n + 1));
                    if (n == 0) {
                        this.parseOrderBy = false;
                    }
                    this.appendOrderBy(n, string, null);
                    string = null;
                    continue block11;
                }
                case START_ARRAY: {
                    jsonObjectBuilder.add(string, this.parseArray(n + 1));
                    this.appendOrderBy(n, string, null);
                    string = null;
                    continue block11;
                }
                case END_OBJECT: {
                    return jsonObjectBuilder;
                }
                case KEY_NAME: {
                    string = this.parser.getString();
                    if (this.orderByParsed) {
                        if (string.equals(ORDERBY) && n == 0) {
                            throw new JsonParsingException(MULTIPLE_ORDERBY_OPS, null);
                        }
                    } else if (string.equals(ORDERBY) && n == 0) {
                        this.orderByParsed = true;
                    }
                    if (this.queryParsed) {
                        if (!string.equals(QUERY) || n != 0) continue block11;
                        throw new JsonParsingException(MULTIPLE_QUERY_OPS, null);
                    }
                    if (!string.equals(QUERY) || n != 0) continue block11;
                    this.queryParsed = true;
                    continue block11;
                }
                case VALUE_STRING: {
                    string2 = this.parser.getString();
                    jsonObjectBuilder.add(string, string2);
                    this.appendOrderBy(n, string, string2);
                    string = null;
                    continue block11;
                }
                case VALUE_NUMBER: {
                    BigDecimal bigDecimal = this.parser.getBigDecimal();
                    if (bigDecimal.stripTrailingZeros().scale() <= 0) {
                        jsonObjectBuilder.add(string, bigDecimal.toBigInteger());
                    } else {
                        jsonObjectBuilder.add(string, bigDecimal);
                    }
                    this.appendOrderBy(n, string, bigDecimal.toString());
                    string = null;
                    continue block11;
                }
                case VALUE_NULL: {
                    jsonObjectBuilder.addNull(string);
                    this.appendOrderBy(n, string, null);
                    string = null;
                    continue block11;
                }
                case VALUE_TRUE: {
                    jsonObjectBuilder.add(string, true);
                    this.appendOrderBy(n, string, null);
                    string = null;
                    continue block11;
                }
                case VALUE_FALSE: {
                    jsonObjectBuilder.add(string, false);
                    this.appendOrderBy(n, string, null);
                    string = null;
                    continue block11;
                }
            }
            throw new IllegalStateException();
        }
        return jsonObjectBuilder;
    }

    private void appendOrderBy(int n, String string, String string2) {
        if (!this.parseOrderBy || n != 1) {
            return;
        }
        this.orderBySpec.appendOrderBy(string, string2);
    }

    public OrderBySpecification getOrderBySpec() {
        return this.orderBySpec;
    }
}

