/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import java.util.logging.Logger;
import oracle.json.common.Configuration;
import oracle.json.common.ConnectionPool;
import oracle.json.common.JsonFactoryProvider;
import oracle.soda.rdbms.impl.cache.CacheOfDescriptorCaches;
import oracle.soda.rdbms.impl.cache.ConcurrentCacheOfDescriptorCaches;

public class SharedServices {
    private static final Logger log = Logger.getLogger(SharedServices.class.getName());
    private final Configuration conf;
    private final ConnectionPool connPool;
    private final CacheOfDescriptorCaches cacheOfDescriptorCaches;
    private final JsonFactoryProvider jProvider;

    public SharedServices(Configuration configuration, boolean bl) {
        this.conf = configuration;
        this.jProvider = new JsonFactoryProvider();
        this.cacheOfDescriptorCaches = new ConcurrentCacheOfDescriptorCaches(100);
        this.connPool = bl ? this.createConnectionPool(configuration) : null;
    }

    public SharedServices(Configuration configuration) {
        this(configuration, false);
    }

    public JsonFactoryProvider getJsonFactoryProvider() {
        return this.jProvider;
    }

    public ConnectionPool getConnectionPool() {
        return this.connPool;
    }

    public CacheOfDescriptorCaches getCacheOfDescriptorCaches() {
        return this.cacheOfDescriptorCaches;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public synchronized void destroy() {
        if (this.connPool != null) {
            log.fine("Closing connection pool");
            this.connPool.shutdown();
        }
    }

    private ConnectionPool createConnectionPool(Configuration configuration) {
        ConnectionPool connectionPool = configuration.poolSize > 0 ? new ConnectionPool(configuration.dbUri, configuration.dbUser, configuration.dbPasswrd, configuration.poolSize) : new ConnectionPool(configuration.dbUri, configuration.dbUser, configuration.dbPasswrd);
        return connectionPool;
    }
}

