/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasetools.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteDatabaseToolsConnectionRequest
extends BmcRequest<Void> {
    private String databaseToolsConnectionId;
    private String ifMatch;
    private String opcRequestId;
    private Boolean isLockOverride;

    public String getDatabaseToolsConnectionId() {
        return this.databaseToolsConnectionId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getIsLockOverride() {
        return this.isLockOverride;
    }

    public Builder toBuilder() {
        return new Builder().databaseToolsConnectionId(this.databaseToolsConnectionId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).isLockOverride(this.isLockOverride);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseToolsConnectionId=").append(String.valueOf(this.databaseToolsConnectionId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",isLockOverride=").append(String.valueOf(this.isLockOverride));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteDatabaseToolsConnectionRequest)) {
            return false;
        }
        DeleteDatabaseToolsConnectionRequest other = (DeleteDatabaseToolsConnectionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseToolsConnectionId, other.databaseToolsConnectionId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.isLockOverride, other.isLockOverride);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseToolsConnectionId == null ? 43 : this.databaseToolsConnectionId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.isLockOverride == null ? 43 : this.isLockOverride.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDatabaseToolsConnectionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseToolsConnectionId = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private Boolean isLockOverride = null;

        public Builder databaseToolsConnectionId(String databaseToolsConnectionId) {
            this.databaseToolsConnectionId = databaseToolsConnectionId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder isLockOverride(Boolean isLockOverride) {
            this.isLockOverride = isLockOverride;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDatabaseToolsConnectionRequest o) {
            this.databaseToolsConnectionId(o.getDatabaseToolsConnectionId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.isLockOverride(o.getIsLockOverride());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDatabaseToolsConnectionRequest build() {
            DeleteDatabaseToolsConnectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteDatabaseToolsConnectionRequest buildWithoutInvocationCallback() {
            DeleteDatabaseToolsConnectionRequest request = new DeleteDatabaseToolsConnectionRequest();
            request.databaseToolsConnectionId = this.databaseToolsConnectionId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.isLockOverride = this.isLockOverride;
            return request;
        }
    }
}

