/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasetools.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ConnectionType implements BmcEnum
{
    OracleDatabase("ORACLE_DATABASE"),
    Mysql("MYSQL"),
    Postgresql("POSTGRESQL"),
    GenericJdbc("GENERIC_JDBC"),
    UnknownEnumValue(null);

    private static final Logger LOG;
    private final String value;
    private static Map<String, ConnectionType> map;

    private ConnectionType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static ConnectionType create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        LOG.warn("Received unknown value '{}' for enum 'ConnectionType', returning UnknownEnumValue", (Object)key);
        return UnknownEnumValue;
    }

    static {
        LOG = LoggerFactory.getLogger(ConnectionType.class);
        map = new HashMap<String, ConnectionType>();
        for (ConnectionType v : ConnectionType.values()) {
            if (v == UnknownEnumValue) continue;
            map.put(v.getValue(), v);
        }
    }
}

