/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.tns;

import java.util.Objects;
import java.util.stream.Stream;
import oracle.dbtools.core.collections.Buffer;
import oracle.dbtools.core.collections.Slice;
import oracle.dbtools.core.text.CharSequenceTrait;
import oracle.dbtools.core.tns.OracleConfiguration;
import oracle.dbtools.core.tns.Token;
import oracle.dbtools.core.tns.TokenStream;

class TokenBuffer
extends Slice.Base<Token>
implements Buffer<Token>,
CharSequenceTrait {
    private final Buffer<Token> tokens;
    private transient int line;
    private transient int column;

    TokenBuffer() {
        this(Buffer.buffer());
    }

    private TokenBuffer(Buffer<Token> tokens) {
        this.tokens = tokens;
    }

    static TokenBuffer open() {
        return new TokenBuffer();
    }

    public static TokenBuffer name(String name) {
        return TokenBuffer.open().atom(name);
    }

    public static TokenBuffer comments(String ... comments) {
        TokenBuffer buffer = TokenBuffer.open();
        for (String comment : comments) {
            buffer.comment(comment);
        }
        return buffer;
    }

    public TokenBuffer line(int line) {
        this.line = line;
        return this;
    }

    public TokenBuffer column(int column) {
        this.column = column;
        return this;
    }

    public TokenBuffer add(Token token) {
        Objects.requireNonNull(token);
        if (this.tokens.isEmpty()) {
            this.line = token.start().line();
            this.column = token.start().column();
        }
        this.tokens.add(token);
        if (Token.Type.EOL == token.type()) {
            ++this.line;
            this.column = 0;
        } else {
            this.column += token.length();
        }
        return this;
    }

    @Override
    public Token get(int index) throws IndexOutOfBoundsException {
        return this.tokens.get(index);
    }

    TokenBuffer token(Token.Type type) {
        return this.token(type, null);
    }

    TokenBuffer token(Token.Type type, CharSequence text) {
        OracleConfiguration.Position position = OracleConfiguration.Position.of(this.line, this.column);
        return this.add(Token.builder().type(type).position(position).text(text).build());
    }

    TokenBuffer comment(CharSequence text) {
        return this.token(Token.Type.COMMENT, text);
    }

    TokenBuffer eol() {
        return this.eol("\n");
    }

    TokenBuffer eol(CharSequence text) {
        return this.token(Token.Type.EOL, text);
    }

    TokenBuffer beginPair() {
        return this.token(Token.Type.BEGIN);
    }

    TokenBuffer endPair() {
        return this.token(Token.Type.END);
    }

    TokenBuffer separator() {
        return this.token(Token.Type.SEPARATOR);
    }

    TokenBuffer eq() {
        return this.token(Token.Type.EQ);
    }

    TokenBuffer singleQuoted(CharSequence text) {
        return this.token(Token.Type.SINGLE_QUOTED_ATOM, text);
    }

    TokenBuffer doubleQuoted(CharSequence text) {
        return this.token(Token.Type.DOUBLE_QUOTED_ATOM, text);
    }

    TokenBuffer unquotedAtom(CharSequence text) {
        return this.token(Token.Type.UNQUOTED_ATOM, text);
    }

    TokenBuffer atom(CharSequence text) {
        return this.unquotedAtom(text);
    }

    TokenBuffer whitespace(CharSequence text) {
        return this.token(Token.Type.WHITESPACE, text);
    }

    @Override
    public Stream<Token> stream() {
        return this.tokens.stream();
    }

    @Override
    public String toString() {
        return this.join("");
    }

    public TokenBuffer space() {
        return this.space(1);
    }

    public TokenBuffer space(int count) {
        return this.whitespace(" ".repeat(count));
    }

    public TokenBuffer clear() {
        this.tokens.clear();
        return this;
    }

    public TokenStream trim() {
        return this.slice().trim();
    }

    @Override
    public int size() {
        return this.tokens.size();
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size();
    }

    @Override
    public TokenStream slice() {
        return this.slice(0, this.size());
    }

    public TokenStream slice(int offset, int length) {
        return TokenStream.of(this.tokens.slice(offset, length));
    }

    public TokenStream slice(int offset) {
        return this.slice(offset, this.tokens.size() - offset);
    }

    public final TokenStream close() {
        return this.slice();
    }
}

