/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.tns;

import java.util.Objects;
import oracle.dbtools.core.text.CharSequenceTrait;
import oracle.dbtools.core.tns.CodePointValidator;
import oracle.dbtools.core.tns.OracleConfiguration;

class Token
implements CharSequenceTrait {
    private static final String EOL = "\n";
    private static final String START_LIST = "(";
    private static final String END_LIST = ")";
    static final String EQ = "=";
    private static final String SEPARATOR = ",";
    private final Type type;
    private final OracleConfiguration.Position start;
    private final String text;
    final transient String rendered;

    private Token(Builder builder) {
        this.type = builder.type;
        this.text = builder.text == null ? null : builder.text.toString();
        this.rendered = Token.render(builder.type, builder.text);
        this.start = builder.position;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static String escape(CharSequence text, int charToEscape) {
        StringBuilder buffer = new StringBuilder(text.length() + 8);
        text.codePoints().forEach(c -> {
            if (charToEscape == c) {
                buffer.appendCodePoint(92);
            } else if (92 == c) {
                buffer.appendCodePoint(92);
            }
            buffer.appendCodePoint(c);
        });
        return buffer.toString();
    }

    static String unescape(CharSequence text, int charToUnescape) {
        StringBuilder buffer = new StringBuilder(text.length());
        char[] chars = text.toString().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char next;
            char c = chars[i];
            boolean append = true;
            if ('\\' == c && ('\\' == (next = chars[i + 1]) || charToUnescape == next)) {
                append = false;
            }
            if (!append) continue;
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static String render(Type type, CharSequence text) {
        switch (type.ordinal()) {
            case 6: {
                return "#" + String.valueOf(text);
            }
            case 7: {
                return "'" + Token.escape(text, 39) + "'";
            }
            case 8: {
                return "\"" + Token.escape(text, 34) + "\"";
            }
            case 0: {
                return START_LIST;
            }
            case 1: {
                return END_LIST;
            }
            case 2: {
                return EQ;
            }
            case 4: {
                return SEPARATOR;
            }
            case 3: {
                return text == null ? EOL : text.toString();
            }
        }
        return text == null ? "" : text.toString();
    }

    boolean isValue() {
        return this.type().isValue();
    }

    boolean isSemantic() {
        return this.type().isSemantic();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        return this.type() == token.type() && Objects.equals(this.start(), token.start()) && Objects.equals(this.text(), token.text());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type(), this.start(), this.text()});
    }

    @Override
    public String toString() {
        return this.rendered;
    }

    OracleConfiguration.Position start() {
        return this.start;
    }

    OracleConfiguration.Position end() {
        if (this.type() == Type.EOL) {
            return OracleConfiguration.Position.of(this.start().line() + 1, 0);
        }
        return this.start().plus(0, this.text() == null ? 1 : this.text().length());
    }

    String text() {
        return this.text;
    }

    Type type() {
        return this.type;
    }

    static final class Builder {
        private OracleConfiguration.Position position = OracleConfiguration.Position.of(0, 0);
        private Type type;
        private CharSequence text;

        private Builder() {
        }

        Builder position(OracleConfiguration.Position position) {
            Objects.requireNonNull(position);
            this.position = position;
            return this;
        }

        Builder type(Type type) {
            Objects.requireNonNull(type);
            this.type = type;
            return this;
        }

        Builder text(CharSequence text) {
            this.text = text;
            return this;
        }

        Token build() {
            return new Token(this);
        }
    }

    static enum Type {
        BEGIN,
        END,
        EQ,
        EOL(c -> 13 == c || 10 == c),
        SEPARATOR,
        WHITESPACE(CodePointValidator.WHITESPACE),
        COMMENT(CodePointValidator.NO_NEW_LINE),
        SINGLE_QUOTED_ATOM(CodePointValidator.NO_LINE_BREAKS),
        DOUBLE_QUOTED_ATOM(CodePointValidator.NO_LINE_BREAKS),
        UNQUOTED_ATOM(CodePointValidator.UNQUOTED);

        final CodePointValidator validator;

        private Type() {
            this(CodePointValidator.NO_VALUE);
        }

        private Type(CodePointValidator validator) {
            this.validator = validator;
        }

        boolean isValue() {
            return this == SINGLE_QUOTED_ATOM || this == DOUBLE_QUOTED_ATOM || this == UNQUOTED_ATOM;
        }

        boolean isSemantic() {
            switch (this.ordinal()) {
                case 3: 
                case 5: 
                case 6: {
                    return false;
                }
            }
            return true;
        }
    }
}

