/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.tns;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import oracle.dbtools.core.tns.OracleConfiguration;
import oracle.dbtools.core.tns.OracleConfigurationSyntaxException;
import oracle.dbtools.core.tns.Token;

abstract class SyntaxErrors {
    SyntaxErrors() {
    }

    static OracleConfigurationSyntaxException unbalancedParens(Token actual, Throwable cause) {
        OracleConfiguration.Position position = actual.start();
        String message = "Unbalanced parentheses detected";
        OracleConfiguration.SyntaxError syntaxError = OracleConfiguration.SyntaxError.builder().kind(OracleConfiguration.SyntaxError.Kind.UNBALANCED_PARENS).position(position).message("Unbalanced parentheses detected").build();
        throw OracleConfigurationSyntaxException.of(syntaxError, cause);
    }

    static OracleConfigurationSyntaxException expected(Token actual, Token.Type ... expected) {
        return SyntaxErrors.expected(actual.start(), actual.charAt(0), expected);
    }

    static OracleConfigurationSyntaxException expected(OracleConfiguration.Position position, int actual, Token.Type ... expected) {
        String pattern = "Expected one of: {0}, but got: {1}";
        String exp = Arrays.stream(expected).map(Enum::toString).collect(Collectors.joining(","));
        String act = Character.toString(actual);
        String message = MessageFormat.format("Expected one of: {0}, but got: {1}", exp, act);
        OracleConfiguration.SyntaxError error = OracleConfiguration.SyntaxError.of(position, message);
        return OracleConfigurationSyntaxException.of(error);
    }

    static void allow(Token actual, Token.Type ... allowed) throws OracleConfigurationSyntaxException {
        List<Token.Type> legal = List.of(allowed);
        if (!legal.contains((Object)actual.type())) {
            throw SyntaxErrors.expected(actual, allowed);
        }
    }
}

