/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.tns;

import java.io.Reader;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.Stream;
import oracle.dbtools.core.collections.Iterables;
import oracle.dbtools.core.collections.Slice;
import oracle.dbtools.core.tns.EntryStream;
import oracle.dbtools.core.tns.Lexer;
import oracle.dbtools.core.tns.OracleConfiguration;
import oracle.dbtools.core.tns.OracleConfigurationSyntaxException;
import oracle.dbtools.core.tns.Token;
import oracle.dbtools.core.tns.TokenBuffer;
import oracle.dbtools.core.tns.TokenStream;
import oracle.dbtools.core.util.Throwables;

class EntryParser {
    private final Lexer lexer;

    private EntryParser(Lexer lexer) {
        this.lexer = lexer;
    }

    static EntryParser of(Lexer lexer) {
        return new EntryParser(lexer);
    }

    EntryStream parse(Stream<Token> content, Consumer<OracleConfigurationSyntaxException> onSyntaxError) {
        EntryGatherer gatherer = new EntryGatherer(onSyntaxError);
        Stream entries = content.flatMap(gatherer::parseNextEntry);
        Stream<OracleConfiguration.Entry> lastEntry = Stream.generate(gatherer::lastEntry).takeWhile(Objects::nonNull);
        return EntryStream.of(Stream.concat(entries, lastEntry), onSyntaxError);
    }

    public EntryStream parse(Reader content, Consumer<OracleConfigurationSyntaxException> onSyntaxError) {
        Stream<Token> tokens = this.lexer.parse(content);
        return this.parse(tokens, onSyntaxError);
    }

    public EntryStream parse(CharSequence content) {
        Stream<Token> tokens = this.lexer.parse(content);
        return this.parse(tokens, Throwables::raise);
    }

    private static class EntryGatherer {
        private final Consumer<OracleConfigurationSyntaxException> onSyntaxError;
        private final TokenBuffer tokens;
        private int depth;

        EntryGatherer(Consumer<OracleConfigurationSyntaxException> onSyntaxError) {
            this.onSyntaxError = onSyntaxError;
            this.tokens = new TokenBuffer();
        }

        private Slice<Token> semanticTokens() {
            return this.tokens.stream().filter(Token::isSemantic).collect(Slice.toSlice());
        }

        private Token previousToken() {
            Slice<Token> semanticTokens = this.semanticTokens();
            return semanticTokens.isEmpty() ? null : semanticTokens.last();
        }

        private void validate(final Token token) {
            String text = token.text();
            if (text != null) {
                IntConsumer validator = new IntConsumer(){
                    private int column;
                    {
                        this.column = token.start().column();
                    }

                    @Override
                    public void accept(int c) {
                        if (token.type().validator.test(c)) {
                            ++this.column;
                        } else {
                            OracleConfiguration.Position errorPosition = OracleConfiguration.Position.of(token.start().line(), this.column);
                            String pattern = "Character: {0} is not permitted in token of type: {1}";
                            String message = MessageFormat.format("Character: {0} is not permitted in token of type: {1}", Character.toString(c), token.type().name());
                            OracleConfiguration.SyntaxError error = OracleConfiguration.SyntaxError.of(errorPosition, message);
                            throw OracleConfigurationSyntaxException.of(error);
                        }
                    }
                };
                text.codePoints().forEach(validator);
            }
        }

        Stream<OracleConfiguration.Entry> parseNextEntry(Token token) {
            OracleConfiguration.Entry entry = null;
            try {
                entry = this.checkForMalformedEntry(token);
                this.validate(token);
                this.tokens.add(token);
                switch (token.type()) {
                    case EOL: {
                        if (entry != null) break;
                        entry = this.checkForSingleLineEntry(token);
                        break;
                    }
                    case BEGIN: {
                        ++this.depth;
                        break;
                    }
                    case END: {
                        --this.depth;
                        if (this.depth != 0) break;
                        entry = this.emitEntry();
                    }
                }
                if (entry != null) {
                    return Stream.of(entry);
                }
            }
            catch (OracleConfigurationSyntaxException e) {
                this.onSyntaxError.accept(e);
            }
            return Stream.empty();
        }

        private OracleConfiguration.Entry checkForMalformedEntry(Token token) {
            Token previous = this.previousToken();
            if (token.isValue() && previous != null && previous.type() == Token.Type.END) {
                return this.emitEntry();
            }
            return null;
        }

        private OracleConfiguration.Entry checkForSingleLineEntry(Token token) {
            boolean allSameLine;
            int line = token.start().line();
            Slice<Token> tokens = this.semanticTokens();
            int equals = Iterables.indexOf(tokens, t -> t.type() == Token.Type.EQ);
            boolean bl = allSameLine = tokens.stream().filter(t -> t.start().line() == line).count() == (long)tokens.size();
            if (allSameLine && equals != -1) {
                Slice<Token> rhs = tokens.slice(equals + 1);
                boolean noNesting = rhs.stream().noneMatch(t -> t.type() == Token.Type.BEGIN || t.type() == Token.Type.END);
                if (!rhs.isEmpty() && noNesting) {
                    return this.emitEntry();
                }
            }
            return null;
        }

        private OracleConfiguration.Entry emitEntry() {
            OracleConfiguration.Entry entry = OracleConfiguration.Entry.of(this.tokens.slice());
            this.tokens.clear();
            this.depth = 0;
            return entry;
        }

        OracleConfiguration.Entry lastEntry() {
            TokenStream tokens = this.tokens.trim();
            if (tokens.isEmpty()) {
                return null;
            }
            return this.emitEntry();
        }
    }
}

