/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.secrets;

import java.util.Arrays;
import oracle.dbtools.core.secrets.BinarySecret;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.core.text.Text;

class TextSecretImpl
implements TextSecret {
    private static final TextSecret NONE = new TextSecretImpl(BinarySecret.none());
    private final BinarySecret secret;

    TextSecretImpl(BinarySecret secret) {
        this.secret = secret;
    }

    public static TextSecret none() {
        return NONE;
    }

    static TextSecret of(BinarySecret secret) {
        if (secret == null || !secret.isPresent()) {
            return TextSecretImpl.none();
        }
        return new TextSecretImpl(secret);
    }

    static char[] asCharacters(byte[] content) {
        return Text.decode(content);
    }

    @Override
    public BinarySecret asSecret() {
        return this.secret;
    }

    @Override
    public void close() {
        this.secret.close();
    }

    @Override
    public boolean isPresent() {
        return this.secret.isPresent();
    }

    @Override
    public void set(TextSecret.Setter<String> setter) {
        this.map(text -> {
            String string = new String(text);
            setter.accept(string);
            return null;
        });
    }

    @Override
    public void setChars(TextSecret.Setter<char[]> setter, boolean duplicate) {
        this.map(text -> {
            char[] copy = duplicate ? Arrays.copyOf(text, text.length) : text;
            setter.accept(copy);
            return null;
        });
    }

    public int hashCode() {
        return this.secret.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextSecretImpl)) {
            return false;
        }
        TextSecretImpl secret = (TextSecretImpl)o;
        return this.secret.equals(secret.secret);
    }
}

