/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.jdbc.tns;

import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import oracle.dbtools.core.system.SystemContext;

public class TnsLocation {
    static final String ORACLE_HOME = "ORACLE_HOME";
    static final String USER_HOME_DIR = "USER Home dir";
    static final String DRIVER_PATH = "Driver path";
    static final String TNS_NAMES = "tnsnames.ora";
    static final String HIDDEN_TNS_NAMES = ".tnsnames";
    static final String ETC = "/etc";
    static final String USER_HOME = "user.home";
    static final String DRIVER_HOME = "jdbc.driver.home";
    static final String TNS_ADMIN = "TNS_ADMIN";
    private static final Resolver EXPLICIT_SYSTEM_PROPERTY = new SystemPropertyResolver("oracle.net.tns_admin", "oracle.net.tns_admin", new String[0]);
    private static final Resolver USER_HOME_SYSTEM_PROPERTY = new SystemPropertyResolver("USER Home dir", "user.home", new String[0]);
    private static final Resolver ETC_PATH = new PathResolver("/etc", OperatingSystem.UNIX);
    private static final Resolver TNS_ADMIN_ENVIRONMENT_VARIABLE = new EnvironmentVariableResolver("TNS_ADMIN", "TNS_ADMIN", new String[0]);
    private static final Resolver DRIVER_HOME_SYSTEM_PROPERTY = new SystemPropertyResolver("Driver path", "jdbc.driver.home", "network", "admin");
    private static final Resolver ORACLE_HOME_ENVIRONMENT_VARIABLE = new EnvironmentVariableResolver("ORACLE_HOME", "ORACLE_HOME", "network", "admin");
    private static final List<Resolver> BUILT_IN_RESOLVERS = List.of(EXPLICIT_SYSTEM_PROPERTY, USER_HOME_SYSTEM_PROPERTY, ETC_PATH, TNS_ADMIN_ENVIRONMENT_VARIABLE, DRIVER_HOME_SYSTEM_PROPERTY, ORACLE_HOME_ENVIRONMENT_VARIABLE);
    private final SystemContext systemContext;
    private final List<Resolver> resolvers;
    private final transient Path folder;
    private final Map<String, Path> candidates;

    private TnsLocation(Builder builder) {
        this.systemContext = builder.systemContext;
        this.resolvers = List.copyOf(builder.resolvers);
        LinkedHashMap<String, Path> candidates = new LinkedHashMap<String, Path>();
        Path folder = null;
        for (Resolver resolver : this.resolvers) {
            Path candidate = resolver.resolve(this.systemContext);
            if (candidate == null) continue;
            if (folder == null) {
                folder = candidate;
            }
            candidates.put(resolver.name(), candidate);
        }
        this.folder = folder;
        this.candidates = Collections.unmodifiableMap(candidates);
    }

    private static boolean exists(Path path) {
        return Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]);
    }

    public static boolean hasTns(Path folder) {
        Path normal = folder.resolve(TNS_NAMES);
        Path hidden = folder.resolve(HIDDEN_TNS_NAMES);
        return TnsLocation.exists(normal) || TnsLocation.exists(hidden);
    }

    public static List<Resolver> builtInResolvers() {
        return BUILT_IN_RESOLVERS;
    }

    public static TnsLocation of(SystemContext systemContext) {
        return TnsLocation.builder().resolvers(TnsLocation.builtInResolvers()).systemContext(systemContext).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Path folder() {
        return this.folder;
    }

    public Map<String, Path> candidates() {
        return this.candidates;
    }

    public Path file() {
        return this.file(this.folder());
    }

    public Path file(Path path) {
        if (path != null && Files.exists(path, new LinkOption[0])) {
            if (Files.isRegularFile(path, new LinkOption[0])) {
                return path;
            }
            Path folder = path;
            Path normal = folder.resolve(TNS_NAMES);
            if (TnsLocation.exists(normal)) {
                return normal;
            }
            Path hidden = folder.resolve(HIDDEN_TNS_NAMES);
            if (TnsLocation.exists(hidden)) {
                return hidden;
            }
        }
        return null;
    }

    public Builder modify() {
        return TnsLocation.builder().systemContext(this.systemContext).resolvers(this.resolvers);
    }

    public static final class Builder {
        private final List<Resolver> resolvers = new ArrayList<Resolver>();
        private SystemContext systemContext;

        private Builder() {
        }

        public Builder systemContext(SystemContext systemContext) {
            this.systemContext = systemContext;
            return this;
        }

        public Builder resolver(Resolver resolver) {
            this.resolvers.add(resolver);
            return this;
        }

        public Builder resolvers(Iterable<? extends Resolver> resolvers) {
            resolvers.forEach(this::resolver);
            return this;
        }

        public TnsLocation build() {
            return new TnsLocation(this);
        }
    }

    public static interface Resolver {
        public String name();

        public Path resolve(SystemContext var1);

        public static abstract class Base
        implements Resolver {
            private final String name;

            protected Base(CharSequence name) {
                this.name = name.toString();
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public Path resolve(SystemContext systemContext) {
                try (Stream<Path> candidates = this.searchLocations(systemContext);){
                    Path path = candidates.filter(TnsLocation::hasTns).findFirst().orElse(null);
                    return path;
                }
            }

            protected abstract Stream<Path> searchLocations(SystemContext var1);
        }
    }

    private static class SystemPropertyResolver
    extends SystemContextResolver {
        SystemPropertyResolver(String name, String systemProperty, String ... relativePath) {
            super(name, (SystemContext systemContext) -> systemContext.getSystemProperty(systemProperty), relativePath);
        }
    }

    private static class PathResolver
    extends Resolver.Base {
        private final Set<OperatingSystem> operatingSystems;
        private final String path;

        PathResolver(String path, OperatingSystem ... operatingSystems) {
            this(path, path, operatingSystems);
        }

        PathResolver(String name, String path, OperatingSystem ... operatingSystems) {
            super(name);
            this.path = path;
            this.operatingSystems = operatingSystems.length == 0 ? EnumSet.allOf(OperatingSystem.class) : EnumSet.copyOf(Arrays.asList(operatingSystems));
        }

        @Override
        protected Stream<Path> searchLocations(SystemContext systemContext) {
            OperatingSystem operatingSystem = OperatingSystem.of(systemContext);
            if (this.operatingSystems.contains((Object)operatingSystem)) {
                return Stream.ofNullable(systemContext.getPath(this.path, new String[0]));
            }
            return Stream.empty();
        }
    }

    private static enum OperatingSystem {
        WINDOWS("\\"),
        UNIX("/");

        private final String separator;

        private OperatingSystem(String separator) {
            this.separator = separator;
        }

        static OperatingSystem of(FileSystem fileSystem) {
            return Arrays.stream(OperatingSystem.values()).filter(os -> os.separator.equals(fileSystem.getSeparator())).findFirst().orElse(UNIX);
        }

        static OperatingSystem of(SystemContext systemContext) {
            FileSystem fileSystem = systemContext.fileSystem();
            return fileSystem == null ? UNIX : OperatingSystem.of(fileSystem);
        }
    }

    private static class EnvironmentVariableResolver
    extends SystemContextResolver {
        EnvironmentVariableResolver(String name, String environmentVariable, String ... relativePath) {
            super(name, (SystemContext systemContext) -> systemContext.getEnvironmentVariable(environmentVariable), relativePath);
        }
    }

    private static class SystemContextResolver
    extends Resolver.Base {
        private final Function<SystemContext, String> locationSupplier;
        private final String[] relativePath;

        SystemContextResolver(String name, Function<SystemContext, String> locationSupplier, String ... relativePath) {
            super(name);
            this.locationSupplier = locationSupplier;
            this.relativePath = relativePath;
        }

        @Override
        protected Stream<Path> searchLocations(SystemContext systemContext) {
            String path = this.locationSupplier.apply(systemContext);
            if (path != null) {
                Path location = systemContext.getPath(path, this.relativePath);
                return Stream.ofNullable(location);
            }
            return Stream.empty();
        }
    }
}

