/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.io.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.core.io.file.PathType;

class PosixAccessPermission {
    static final PosixAccessPermission SECURE_FOLDER = PosixAccessPermission.builder().type(PathType.FOLDER).permissions(List.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE)).build();
    static final PosixAccessPermission SECURE_FILE = PosixAccessPermission.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
    private final FileAttribute<Set<PosixFilePermission>> permissions;
    private final PathType type;

    private PosixAccessPermission(Builder builder) {
        this.type = builder.type;
        EnumSet<PosixFilePermission> permissions = EnumSet.copyOf(builder.permissions);
        this.permissions = PosixFilePermissions.asFileAttribute(permissions);
    }

    public static PosixAccessPermission of(PosixFilePermission ... permissions) {
        return PosixAccessPermission.builder().permissions(List.of(permissions)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public PathType type() {
        return this.type;
    }

    public String toString() {
        return this.permissions.toString();
    }

    public Path create(Path path) throws IOException {
        switch (this.type) {
            case FOLDER: {
                return Files.createDirectories(path, this.permissions);
            }
        }
        return Files.createFile(path, this.permissions);
    }

    public boolean verify(Path path) throws IOException {
        if (this.type().matches(path)) {
            Set<PosixFilePermission> actual = Files.getPosixFilePermissions(path, new LinkOption[0]);
            return this.permissions.value().equals(actual);
        }
        return false;
    }

    public Path configure(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            PosixFileAttributeView posixView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
            posixView.setPermissions(this.permissions.value());
        }
        return path;
    }

    public static final class Builder {
        private final Set<PosixFilePermission> permissions = new LinkedHashSet<PosixFilePermission>();
        private PathType type = PathType.FILE;

        private Builder() {
        }

        public Builder type(PathType type) {
            this.type = type;
            return this;
        }

        public Builder permission(PosixFilePermission permission) {
            this.permissions.add(permission);
            return this;
        }

        public Builder permissions(Iterable<PosixFilePermission> permissions) {
            permissions.forEach(this::permission);
            return this;
        }

        public PosixAccessPermission build() {
            return new PosixAccessPermission(this);
        }
    }
}

