/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.io.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryFlag;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserPrincipal;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.core.io.file.AclFileAttribute;
import oracle.dbtools.core.io.file.PathType;

class AclAccessPermission {
    static final AclAccessPermission SECURE_FILE = AclAccessPermission.of(AclEntryPermission.values());
    static final AclAccessPermission SECURE_FOLDER = AclAccessPermission.builder().type(PathType.FOLDER).flags(List.of(AclEntryFlag.FILE_INHERIT, AclEntryFlag.DIRECTORY_INHERIT)).permissions(List.of(AclEntryPermission.values())).build();
    private final PathType type;
    private final Set<AclEntryPermission> permissions;
    private final Set<AclEntryFlag> flags;

    private AclAccessPermission(Builder builder) {
        this.type = builder.type;
        this.flags = builder.flags.isEmpty() ? Set.of() : EnumSet.copyOf(builder.flags);
        this.permissions = EnumSet.copyOf(builder.permissions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AclAccessPermission of(AclEntryPermission ... permissions) {
        return AclAccessPermission.builder().permissions(List.of(permissions)).build();
    }

    private UserPrincipal userPrincipal(Path path) throws IOException {
        UserPrincipal userPrincipal = path.getFileSystem().getUserPrincipalLookupService().lookupPrincipalByName(System.getProperty("user.name"));
        return userPrincipal;
    }

    private FileAttribute<List<AclEntry>>[] fileAttributes(Path path) throws IOException {
        if (this.permissions.isEmpty()) {
            return new FileAttribute[0];
        }
        AclFileAttribute fileAttribute = AclFileAttribute.of(this.aclEntry(path));
        return new FileAttribute[]{fileAttribute};
    }

    public Path create(Path path) throws IOException {
        FileAttribute<List<AclEntry>>[] fileAttributes = this.fileAttributes(path);
        switch (this.type) {
            case FOLDER: {
                Files.createDirectories(path, fileAttributes);
                break;
            }
            default: {
                Files.createFile(path, fileAttributes);
            }
        }
        return path;
    }

    private AclEntry aclEntry(Path path) throws IOException {
        UserPrincipal userPrincipal = this.userPrincipal(path);
        AclEntry aclEntry = AclEntry.newBuilder().setPrincipal(userPrincipal).setFlags(this.flags).setPermissions(this.permissions).setType(AclEntryType.ALLOW).build();
        return aclEntry;
    }

    public PathType type() {
        return this.type;
    }

    public boolean verify(Path path) throws IOException {
        if (this.permissions.isEmpty()) {
            return Files.exists(path, new LinkOption[0]);
        }
        AclEntry expectedAcl = this.aclEntry(path);
        List<AclEntry> expected = List.of(expectedAcl);
        AclFileAttributeView aclView = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        List<AclEntry> entries = aclView.getAcl();
        return expected.equals(entries);
    }

    public Path configure(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            AclEntry acl = this.aclEntry(path);
            AclFileAttributeView aclView = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
            aclView.setAcl(List.of(acl));
        }
        return path;
    }

    public static final class Builder {
        private final Set<AclEntryFlag> flags;
        private final Set<AclEntryPermission> permissions;
        private PathType type = PathType.FILE;

        private Builder() {
            this.flags = new LinkedHashSet<AclEntryFlag>();
            this.permissions = new LinkedHashSet<AclEntryPermission>();
        }

        public Builder type(PathType type) {
            this.type = type;
            return this;
        }

        public Builder flag(AclEntryFlag flag) {
            this.flags.add(flag);
            return this;
        }

        public Builder flags(Iterable<AclEntryFlag> flags) {
            flags.forEach(this::flag);
            return this;
        }

        public Builder permission(AclEntryPermission permission) {
            this.permissions.add(permission);
            return this;
        }

        public Builder permissions(Iterable<AclEntryPermission> permissions) {
            permissions.forEach(this::permission);
            return this;
        }

        public AclAccessPermission build() {
            return new AclAccessPermission(this);
        }
    }
}

