/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.jobs;

import java.sql.Connection;
import java.util.List;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.extension.jobs.JobsMessages;
import oracle.dbtools.extension.jobs.completers.JobNameCompleter;
import oracle.dbtools.raptor.backgroundTask.jobs.JobsProcessor;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.command.ParsedCommandListener;
import oracle.dbtools.raptor.newscriptrunner.util.completer.SemanticCompleter;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ExpressionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Node;
import oracle.dbtools.raptor.newscriptrunner.util.parser.OptionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.StringList;

public class BackgroundCommand
extends ParsedCommandListener
implements SQLCLService {
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        Id command = parsedCommand.getType().getId();
        if (command == Symbol.BACKGROUND) {
            try {
                JobsProcessor.Job job = JobsProcessor.run((ScriptRunnerContext)ctx, (Connection)conn, (ISQLCommand)cmd, (String)((String)parsedCommand.getGrammarValue()), (String)((String)parsedCommand.getOptionValue((Id)Symbol.TASKNAME)), (List)((List)parsedCommand.getOptionValue((Id)Symbol.WAIT4)));
                ctx.writeln(JobsMessages.format("Jobs.Run.Started", job.getId()));
            }
            catch (RuntimeException e) {
                ctx.writeln(e.getMessage());
            }
        }
        return true;
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return JobsMessages.getString("BACKGROUND_DESC");
    }

    public String getExtensionName() {
        return "Background";
    }

    public String getExtensionVersion() {
        return JobsMessages.getString("SQLclVersion.VERSION");
    }

    public String getDescription() {
        return JobsMessages.getString("BACKGROUND_DESC");
    }

    protected Type createType() {
        return Factory.type((Id)Symbol.BACKGROUND).abbrevs(new String[]{"bg"}).add(((OptionBuilder)((OptionBuilder)((OptionBuilder)Factory.option((Id)Symbol.WAIT4).abbrevs(new String[]{"W4"}).dataType(List.class)).completer(new SemanticCompleter[]{new JobNameCompleter()})).transformer(new Transformer[]{new StringList()})).build()).add(((OptionBuilder)Factory.option((Id)Symbol.TASKNAME).completer(new SemanticCompleter[]{new JobNameCompleter()})).abbrevs(new String[]{"TN"}).build()).set(Factory.grammar().dataType(String.class).defaultValue((Object)"").add(Factory.rule((Id)Symbol.START).eq((ExpressionBuilder)Factory.seq(this::commandSpec, (ExpressionBuilder[])new ExpressionBuilder[]{Factory.literal((String)"commandspec")})).helpId()).build()).build();
    }

    private String commandSpec(List<Node> childNodes, TransformContext context, Environment environment) {
        return (String)childNodes.get(0).getValue();
    }

    public static enum Symbol implements Id
    {
        BACKGROUND,
        START,
        TASKNAME,
        WAIT4;

    }
}

