/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.diff;

import java.util.List;
import oracle.dbtools.extension.project.diff.ObjectDiff;
import oracle.dbtools.extension.project.diff.TypeInfo;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.ParsedSql;

public class TypeDiff
extends ObjectDiff {
    TypeInfo ty1 = null;
    TypeInfo ty2 = null;

    public TypeDiff(ParsedSql parsed1, ParsedSql parsed2) throws Exception {
        super(parsed1, parsed2);
        this.ty1 = new TypeInfo((Parsed)parsed1);
        this.ty2 = new TypeInfo((Parsed)parsed2);
    }

    @Override
    public String alters() {
        Object ret = "";
        String alterPrefix = "alter type " + this.ty1.name + "\n";
        int i = 0;
        List<ParseNode> fields = this.newClauses(this.ty1.fields, this.ty2.fields);
        Object content = "";
        for (ParseNode parseNode : fields) {
            if (this.ty1.findInAlters(this.ty2.target.content(parseNode)) != null) continue;
            if (i++ != 0) {
                content = (String)content + ",";
            }
            content = (String)content + this.ty2.target.content(parseNode);
        }
        if (0 < ((String)content).length()) {
            ret = (String)ret + alterPrefix + "add ATTRIBUTE (" + (String)content + ") cascade;\n";
        }
        content = "";
        List<ParseNode> methods = this.newClauses(this.ty1.methods, this.ty2.methods);
        for (ParseNode n : methods) {
            if (i++ != 0) {
                content = (String)content + ",";
            }
            content = (String)content + "add " + this.ty2.target.content(n) + " cascade";
            ParseNode dNode = null;
            for (ParseNode n1 : this.ty1.methods) {
                if (!this.ty1.methodName(n1).equals(this.ty2.methodName(n))) continue;
                dNode = n1;
                break;
            }
            if (dNode == null) continue;
            Object drop = this.ty1.target.content(dNode);
            ParseNode callSpecs = null;
            for (ParseNode n1 : dNode.descendants()) {
                if (!n1.contains("call_specification")) continue;
                callSpecs = n1;
            }
            if (callSpecs != null) {
                drop = this.ty1.target.getInput().substring(((LexerToken)this.ty1.target.getSrc().get((int)dNode.from)).begin, ((LexerToken)this.ty1.target.getSrc().get((int)(callSpecs.from - 1))).begin);
            }
            ret = (String)ret + alterPrefix + "drop " + (String)drop + " cascade;\n";
        }
        if (0 < ((String)content).length()) {
            ret = (String)ret + alterPrefix + (String)content + ";\n";
        }
        List<ParseNode> list = this.newClauses(this.ty1.extraAlters, this.ty2.extraAlters);
        block4: for (ParseNode n : list) {
            for (ParseNode field : this.ty2.fieldsInAlters.keySet()) {
                ParseNode alter = this.ty2.fieldsInAlters.get(field);
                if (!alter.equals(n) || this.ty1.findInFields(this.ty2.target.content(field)) == null) continue;
                continue block4;
            }
            String s = this.ty2.target.content(n);
            s = this.prefixObjectName(s, n);
            ret = (String)ret + s + ";\n";
        }
        return ret;
    }

    protected String prefixObjectName(String ddl, ParseNode node) {
        if (!node.contains("alt_ty_stmts")) {
            return ddl;
        }
        int pos = this.ty1.name.indexOf(".");
        if (pos < 0) {
            return ddl;
        }
        String owner = this.ty1.name.substring(0, pos);
        String name = this.ty1.name.substring(pos + 1);
        int insertPos = ((String)ddl).indexOf(name, "alter type".length());
        ddl = ((String)ddl).substring(0, insertPos) + owner + "." + ((String)ddl).substring(insertPos);
        return ddl;
    }
}

