/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.diff;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.extension.project.diff.Row;

public class Table {
    TreeMap<Integer, String> header;
    List<Row> grid;
    String tableName;
    String columns = null;

    public Table(String tableName, Connection conn) throws SQLException {
        ResultSet rs;
        this.tableName = tableName;
        this.header = new TreeMap();
        this.grid = new ArrayList<Row>();
        int dot = tableName.indexOf(".");
        String owner = tableName.substring(0, dot);
        String table = tableName.substring(dot + 1);
        String cols = "";
        try (Statement stmt = conn.createStatement();){
            rs = stmt.executeQuery("select column_name,data_type from dba_tab_columns \nwhere table_name = '" + table + "' and owner = '" + owner + "' \norder by column_id");
            try {
                int i = -1;
                while (rs.next()) {
                    String type = rs.getString("data_type");
                    if (!"NUMBER".equals(type) && !"VARCHAR2".equals(type) && !"NCHAR".equals(type) && !"NVARCHAR2".equals(type) && !"CHAR".equals(type) && !"DATE".equals(type) && !"BOOLEAN".equals(type) && !"BINARY_DOUBLE".equals(type) && !"BINARY_FLOAT".equals(type) && !"FLOAT".equals(type) && !"NUMBER_LIST".equals(type) && !"STRING_LIST".equals(type) && !"VECTOR".equals(type) && !"JSON".equals(type)) continue;
                    this.header.put(++i, rs.getString("column_name"));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        stmt = conn.createStatement();
        try {
            rs = stmt.executeQuery("select " + this.columnList() + " from " + tableName);
            try {
                while (rs.next()) {
                    this.grid.add(new Row(this.header, rs));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    String columnList() {
        if (this.columns != null) {
            return this.columns;
        }
        this.columns = "";
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < this.header.size(); ++i) {
            if (i != 0) {
                ret.append(",");
            }
            if (i % 5 == 0) {
                ret.append("\n");
            }
            ret.append(this.header.get(i));
        }
        this.columns = ret.toString();
        return this.columns;
    }

    public int cardinality() {
        return this.grid.size();
    }
}

