/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.diff;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.extension.project.diff.ColProperties;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;

public abstract class ParseDiff {
    public Map<String, String> add = new TreeMap<String, String>();
    public Map<String, String> modify = new TreeMap<String, String>();
    public List<String> delete = new LinkedList<String>();
    public Map<String, String> rename = new TreeMap<String, String>();

    public ParseDiff(List<ParseNode> dl1, Parsed t1, List<ParseNode> dl2, Parsed t2) {
        int nameIndex = this.nameIndex();
        TreeMap<Integer, Integer> matches = new TreeMap<Integer, Integer>();
        ParseDiff.addDeleteModify(dl1, t1, dl2, t2, matches, this.add, this.modify, this.delete, nameIndex);
        block0: for (int i1 = 0; i1 < dl1.size(); ++i1) {
            if (matches.containsKey(i1)) continue;
            for (int i2 = 0; i2 < dl2.size(); ++i2) {
                ColProperties cp2;
                ColProperties cp1;
                if (matches.containsValue(i2) || !ColProperties.sameType(cp1 = new ColProperties(t1, dl1.get(i1)), cp2 = new ColProperties(t2, dl2.get(i2))) || !ColProperties.sameConstraint(cp1, cp2) || ParseDiff.adjustedPos(i1, matches.keySet()) != ParseDiff.adjustedPos(i2, matches.values())) continue;
                this.rename.put(((LexerToken)t1.getSrc().get((int)(dl1.get((int)i1).from + nameIndex))).content, ((LexerToken)t2.getSrc().get((int)(dl2.get((int)i2).from + nameIndex))).content);
                this.delete.remove(((LexerToken)t1.getSrc().get((int)(dl1.get((int)i1).from + nameIndex))).content);
                matches.put(i1, i2);
                continue block0;
            }
        }
        for (int i2 = 0; i2 < dl2.size(); ++i2) {
            if (matches.containsValue(i2)) continue;
            this.add.put(((LexerToken)t2.getSrc().get((int)(dl2.get((int)i2).from + nameIndex))).content, new ColProperties(t2, dl2.get(i2)).reduce(null));
        }
        this.oneRename(dl1, t1, dl2, t2);
    }

    private static void addDeleteModify(List<ParseNode> dl1, Parsed t1, List<ParseNode> dl2, Parsed t2, Map<Integer, Integer> matches, Map<String, String> add, Map<String, String> modify, List<String> delete, int nameIndex) {
        block0: for (int i1 = 0; i1 < dl1.size(); ++i1) {
            if (matches.containsKey(i1)) continue;
            for (int i2 = 0; i2 < dl2.size(); ++i2) {
                ColProperties cp2;
                String def2;
                if (matches.containsValue(i2)) continue;
                String def1 = t1.content(dl1.get(i1));
                if (LexerToken.equals((String)def1, (String)(def2 = t2.content(dl2.get(i2))))) {
                    matches.put(i1, i2);
                    continue block0;
                }
                ColProperties cp1 = new ColProperties(t1, dl1.get(i1));
                if (!ColProperties.sameName(cp1, cp2 = new ColProperties(t2, dl2.get(i2)))) continue;
                if (cp1.type != null && (cp1.type.contains("ANSI_supported_datatypes") || cp1.type.contains("Oracle_built_in_datatypes") || cp1.type.contains("XML_types") && cp1.type.to - cp1.type.from == cp2.type.to - cp2.type.from)) {
                    Object newChange = new ColProperties(t2, dl2.get(i2)).reduce(cp1);
                    if (def1.contains("not null") && !def2.contains("not null")) {
                        newChange = (String)newChange + " null";
                    }
                    if (def1.contains("not null") && def2.contains("not null")) {
                        int cut = ((String)newChange).indexOf("not null");
                        newChange = ((String)newChange).substring(0, cut);
                    }
                    modify.put(def1, (String)newChange);
                } else {
                    delete.add(((LexerToken)t1.getSrc().get((int)(dl1.get((int)i1).from + nameIndex))).content);
                    add.put(def2, new ColProperties(t2, dl2.get(i2)).reduce(cp1));
                }
                matches.put(i1, i2);
                continue block0;
            }
            delete.add(((LexerToken)t1.getSrc().get((int)(dl1.get((int)i1).from + nameIndex))).content);
        }
    }

    private void oneRename(List<ParseNode> dl1, Parsed t1, List<ParseNode> dl2, Parsed t2) {
        boolean isSimpler;
        int nameIndex = this.nameIndex();
        TreeMap<String, String> add = new TreeMap<String, String>();
        TreeMap<String, String> modify = new TreeMap<String, String>();
        LinkedList<String> delete = new LinkedList<String>();
        TreeMap<String, String> rename = new TreeMap<String, String>();
        TreeMap<Integer, Integer> matches = new TreeMap<Integer, Integer>();
        block0: for (int i1 = 0; i1 < dl1.size(); ++i1) {
            if (matches.containsKey(i1)) continue;
            for (int i2 = 0; i2 < dl2.size(); ++i2) {
                String def2;
                if (matches.containsValue(i2)) continue;
                ColProperties cp1 = new ColProperties(t1, dl1.get(i1));
                ColProperties cp2 = new ColProperties(t2, dl2.get(i2));
                String def1 = t1.content(dl1.get(i1));
                if (LexerToken.equals((String)def1, (String)(def2 = t2.content(dl2.get(i2))))) {
                    matches.put(i1, i2);
                    continue block0;
                }
                if (!ColProperties.sameType(cp1, cp2) || !ColProperties.sameConstraint(cp1, cp2) || ParseDiff.adjustedPos(i1, matches.keySet()) != ParseDiff.adjustedPos(i2, matches.values()) || ColProperties.sameName(cp1, cp2)) continue;
                rename.put(((LexerToken)t1.getSrc().get((int)(dl1.get((int)i1).from + nameIndex))).content, ((LexerToken)t2.getSrc().get((int)(dl2.get((int)i2).from + nameIndex))).content);
                matches.put(i1, i2);
                break block0;
            }
        }
        ParseDiff.addDeleteModify(dl1, t1, dl2, t2, matches, add, modify, delete, nameIndex);
        for (int i2 = 0; i2 < dl2.size(); ++i2) {
            if (matches.containsValue(i2)) continue;
            add.put(((LexerToken)t2.getSrc().get((int)(dl2.get((int)i2).from + nameIndex))).content, new ColProperties(t2, dl2.get(i2)).reduce(null));
        }
        boolean bl = isSimpler = add.size() + delete.size() + modify.size() + rename.size() < this.add.size() + this.delete.size() + this.modify.size() + this.rename.size();
        if (ParseDiff.contains(t1.getSrc(), new String[]{"sys", "."})) {
            boolean bl2 = isSimpler = delete.size() + modify.size() < this.delete.size() + this.modify.size();
        }
        if (isSimpler) {
            this.add = add;
            this.delete = delete;
            this.modify = modify;
            this.rename = rename;
        }
    }

    public static boolean contains(List<LexerToken> src, String[] subseq) {
        block0: for (int j = 0; j <= src.size() - subseq.length; ++j) {
            for (int i = 0; i < subseq.length; ++i) {
                if (!src.get((int)(i + j)).content.equalsIgnoreCase(subseq[i])) continue block0;
            }
            return true;
        }
        return false;
    }

    static int adjustedPos(int p, Collection<Integer> skip) {
        if (skip == null) {
            return 0;
        }
        int ret = 0;
        for (int s : skip) {
            if (s >= p) continue;
            ++ret;
        }
        return ret;
    }

    public abstract int nameIndex();
}

