/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.stage;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.extension.project.commands.stage.utils.StageConstants;
import oracle.dbtools.extension.project.commands.verify.VerifyMessages;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;
import oracle.dbtools.extension.project.core.verify.services.stage.SoftObjectIsolationUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class StageSoftObjectIsolationSprintChange
implements VerifyServiceInterface {
    @Override
    public String getName() {
        return "stagesoftobjectisolationsprintchange";
    }

    @Override
    public String getGroup() {
        return "stage";
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        Path nextFolderPath = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), "dist/releases/next");
        File nextFolderFile = new File(nextFolderPath.toString());
        if (nextFolderFile.isDirectory()) {
            File[] nextFolderSubFolders = nextFolderFile.listFiles();
            if (nextFolderSubFolders != null && this.containsCodeOrChanges(nextFolderSubFolders)) {
                Path codeFolderPath = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), "dist/releases/next/code");
                File codeFolderFile = new File(codeFolderPath.toString());
                if (codeFolderFile.isDirectory()) {
                    if (StageConstants.isReleaseIsolation()) {
                        this.addMessage(VerifyServiceInterface.MessageLevel.INFO, VerifyMessages.getString("STAGESOFTOBJECTISOLATIONSPRINTCHANGE_CODE_PRESENT_RELEASE"));
                        return true;
                    }
                    this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.getString("STAGESOFTOBJECTISOLATIONSPRINTCHANGE_CODE_PRESENT_CHANGE"));
                    return false;
                }
                Path changesFolderPath = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), "dist/releases/next/changes");
                List<String> subfoldersList = SoftObjectIsolationUtils.subfoldersFromSoftObjects(new File(changesFolderPath.toString()));
                if (!subfoldersList.isEmpty()) {
                    if (StageConstants.isReleaseIsolation()) {
                        this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.getString("STAGESOFTOBJECTISOLATIONSPRINTCHANGE_SOFTOBJECTS_PRESENT_RELEASE"));
                        return false;
                    }
                    this.addMessage(VerifyServiceInterface.MessageLevel.INFO, VerifyMessages.getString("STAGESOFTOBJECTISOLATIONSPRINTCHANGE_SOFTOBJECTS_PRESENT_CHANGE"));
                    return true;
                }
                this.addMessage(VerifyServiceInterface.MessageLevel.WARN, VerifyMessages.getString("STAGESOFTOBJECTISOLATIONSPRINTCHANGE_SOFTOBJECTS_ABSENT"));
                return true;
            }
            this.addMessage(VerifyServiceInterface.MessageLevel.INFO, VerifyMessages.getString("STAGESOFTOBJECTISOLATIONSPRINTCHANGE_NEXT_EMPTY"));
            return true;
        }
        this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.getString("STAGESOFTOBJECTISOLATIONSPRINTCHANGE_NEXT_MISSING"));
        return false;
    }

    private boolean containsCodeOrChanges(File[] nextFolderSubFolders) {
        for (File file : nextFolderSubFolders) {
            if (!file.isDirectory() || !file.getName().contains("code") && !file.getName().contains("changes")) continue;
            return true;
        }
        return false;
    }
}

