/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.stage;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import oracle.dbtools.extension.project.commands.verify.VerifyMessages;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class StageChangeLogComplete
implements VerifyServiceInterface {
    private static final List<String> allowedExtensions = Arrays.asList("sql", "pks", "pkb", "pls");
    private static String changelogFileExtension = ".xml";

    @Override
    public String getName() {
        return "StageChangeLogComplete";
    }

    @Override
    public String getGroup() {
        return "Stage";
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        try {
            StringBuilder processErrors = new StringBuilder();
            List<Path> allowedPaths = Arrays.asList(Paths.get(ProjectConfig.getCurrentWorkingProjectRoot().toString(), "dist/releases/apex"), Paths.get(ProjectConfig.getCurrentWorkingProjectRoot().toString(), "dist/releases/next"), Paths.get(ProjectConfig.getCurrentWorkingProjectRoot().toString(), "dist/releases/ords"));
            changelogFileExtension = ProjectSettings.getSettingAsString("stage.generatedFormat").equalsIgnoreCase("sql") ? ".sql" : ".xml";
            Path releasePath = Paths.get(ProjectConfig.getCurrentWorkingProjectRoot().toString(), "dist/releases");
            List<File> filesList = this.listFirstLevel(releasePath);
            for (File file : filesList) {
                if (!allowedPaths.contains(file.toPath())) continue;
                processErrors.append((CharSequence)this.process(file.toPath()));
            }
            if (processErrors.length() > 0) {
                this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, processErrors.toString());
                return false;
            }
            this.addMessage(VerifyServiceInterface.MessageLevel.INFO, VerifyMessages.format("STAGECHANGELOGCOMPLETE_SUCCESS", new Object[0]));
            return true;
        }
        catch (Exception e) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, e.getMessage(), "exception", e);
            return false;
        }
    }

    public StringBuilder process(Path dir) throws IOException {
        StringBuilder errors = new StringBuilder();
        if (Files.isDirectory(dir, new LinkOption[0])) {
            List<File> filesList = this.listFirstLevel(dir);
            if (dir.equals(Paths.get(ProjectConfig.getCurrentWorkingProjectRoot().toString(), "dist/releases/next")) || dir.equals(Paths.get(ProjectConfig.getCurrentWorkingProjectRoot().toString(), "dist/releases/next/changes"))) {
                filesList.forEach(file -> {
                    try {
                        errors.append((CharSequence)this.process(file.toPath()));
                    }
                    catch (IOException e) {
                        errors.append("Failed to access file: ").append(file.toPath()).append("\n");
                    }
                });
            } else {
                String changelogFileName = dir.toFile().getName() + ".changelog" + changelogFileExtension;
                if (dir.toFile().getParentFile().getName().equalsIgnoreCase("changes")) {
                    changelogFileName = "stage.changelog" + changelogFileExtension;
                }
                if (!filesList.isEmpty()) {
                    File changeLogFile = this.findChangeLogFile(filesList, changelogFileName);
                    if (changeLogFile == null) {
                        errors.append(VerifyMessages.format("STAGECHANGELOGCOMPLETE_FILE_NOT_FOUND", String.valueOf(dir) + "/" + changelogFileName)).append("\n");
                    } else {
                        errors.append((CharSequence)this.processFiles(filesList, changeLogFile));
                    }
                }
            }
        }
        return errors;
    }

    public List<File> listFirstLevel(Path directoryPath) {
        File directory = directoryPath.toFile();
        File[] items = directory.listFiles();
        return items != null ? Arrays.asList(items) : new ArrayList<File>();
    }

    private File findChangeLogFile(List<File> files, String changeLogFileName) {
        if (!files.isEmpty()) {
            Optional<File> changelogFound = files.stream().filter(f -> f.getName().equalsIgnoreCase(changeLogFileName)).findFirst();
            return changelogFound.orElse(null);
        }
        return null;
    }

    private boolean checkInclude(File changelogFile, String includedFilePath, Boolean isApexAppChangelog) throws IOException {
        String cleanedChangeLogFileContent = FileUtils.readFileToString((File)changelogFile, (Charset)StandardCharsets.UTF_8).replaceAll("(?s)<!--.*?-->", "").trim();
        String lineToCheck = "@" + includedFilePath;
        if (!isApexAppChangelog.booleanValue()) {
            cleanedChangeLogFileContent = FileUtils.readFileToString((File)changelogFile, (Charset)StandardCharsets.UTF_8).replaceAll("(?s)<!--.*?-->", "").replaceAll("--[^\r\n]*", "").replaceAll("(?s)/\\*.*?\\*/", "").trim();
            lineToCheck = changelogFileExtension.equalsIgnoreCase(".xml") ? "<include file=\"" + includedFilePath + "\" relativeToChangelogFile=\"true\"/>" : "@@" + includedFilePath;
        }
        return !cleanedChangeLogFileContent.contains(lineToCheck);
    }

    private StringBuilder processFiles(List<File> files, File changelogFile) throws IOException {
        StringBuilder filesProcessingErrs = new StringBuilder();
        if (!files.isEmpty()) {
            for (File file : files) {
                String fileToCheck;
                if (file.equals(changelogFile)) continue;
                if (file.isDirectory()) {
                    filesProcessingErrs.append((CharSequence)this.processFiles(this.listFirstLevel(file.toPath()), changelogFile));
                    continue;
                }
                String fileExt = FilenameUtils.getExtension((String)file.getName());
                Path fileRelativePath = ProjectConfig.getCurrentWorkingProjectRoot().relativize(file.toPath());
                if (changelogFile.getName().equalsIgnoreCase("apex.changelog" + changelogFileExtension) && allowedExtensions.contains(fileExt)) {
                    String apexAppChangelogFileName = file.getParentFile().getName() + ".xml";
                    File apexAppChangelogFile = this.findChangeLogFile(files, apexAppChangelogFileName);
                    if (apexAppChangelogFile != null) {
                        if (this.checkInclude(apexAppChangelogFile, file.getName(), true)) {
                            filesProcessingErrs.append(VerifyMessages.format("STAGECHANGELOGCOMPLETE_FILE_HAS_NO_ENTRY", fileRelativePath, apexAppChangelogFileName));
                        }
                    } else {
                        filesProcessingErrs.append(VerifyMessages.format("STAGECHANGELOGCOMPLETE_FILE_NOT_FOUND", apexAppChangelogFileName)).append("\n");
                    }
                }
                if ((!allowedExtensions.contains(fileExt) || changelogFile.getName().equalsIgnoreCase("apex.changelog" + changelogFileExtension)) && (!fileExt.equalsIgnoreCase("xml") || !changelogFile.getName().equalsIgnoreCase("apex.changelog" + changelogFileExtension)) || !this.checkInclude(changelogFile, fileToCheck = changelogFile.toPath().relativize(file.toPath()).toString().replaceFirst("^\\.\\./", ""), false)) continue;
                filesProcessingErrs.append(VerifyMessages.format("STAGECHANGELOGCOMPLETE_FILE_HAS_NO_ENTRY", fileRelativePath, changelogFile.getName())).append("\n");
            }
        }
        return filesProcessingErrs;
    }
}

