/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.export;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.extension.project.commands.export.Export;
import oracle.dbtools.extension.project.commands.export.ExportMessages;
import oracle.dbtools.extension.project.commands.export.Filters;
import oracle.dbtools.extension.project.commands.verify.VerifyMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.jdbc.OracleDatabaseException;

public class ExportValidateFilters
implements VerifyServiceInterface {
    @Override
    public String getName() {
        return "exportvalidatefilters";
    }

    @Override
    public String getGroup() {
        return "export";
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        ScriptRunnerContext ctx = ScriptRunnerContext.getCurrentContext();
        try {
            List<String> schemas = ProjectSettings.getSettingAsList("schemas");
            ArrayList<String> objects = new ArrayList<String>();
            int threads = 5;
            boolean list = true;
            Export export = new Export(ctx, schemas, objects, threads, list);
            String errorMessage = this.verify(export.filters);
            if (errorMessage.isEmpty()) {
                this.addMessage(VerifyServiceInterface.MessageLevel.INFO, VerifyMessages.getString("EXPORTVALIDATEFILTERS_NO_ERROR"));
                return true;
            }
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.format("EXPORTVALIDATEFILTERS_ERROR", errorMessage));
            return false;
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            if (cause instanceof OracleDatabaseException) {
                OracleDatabaseException ode = (OracleDatabaseException)cause;
                String message = "*** " + VerifyMessages.getString("EXPORTVALIDATEFILTERS_RUN_FAIL") + " " + ode.getSql() + "\n";
                String msg = ode.getMessage();
                int nlPos = msg.indexOf("\n");
                if (0 < nlPos) {
                    msg = msg.substring(0, nlPos);
                }
                message = message + "*** " + msg;
                this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.format("EXPORTVALIDATEFILTERS_ERROR", message));
            } else {
                this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.format("EXPORTVALIDATEFILTERS_ERROR", t));
            }
            return false;
        }
    }

    private String verify(Map<String, String> filters) throws Exception {
        StringBuilder finalMessage = new StringBuilder();
        boolean oneErrorFound = false;
        for (String filter : filters.keySet()) {
            if (filter.isEmpty()) continue;
            Parsed parsedF = new Parsed(filter, (Earley)SqlEarley.getInstance(), "condition");
            SyntaxError error = parsedF.getSyntaxError();
            if (error != null) {
                finalMessage.append(oneErrorFound ? "\n" : "");
                oneErrorFound = true;
                finalMessage.append(MessageFormat.format(ExportMessages.getString("FILTER_SYNTAX_ERROR"), filter, filters.get(filter) + "\n" + error.getDetailedMessage()));
            }
            for (ParseNode node : Filters.descendants(parsedF.getRoot(), "subquery")) {
                String prefix;
                if (!node.contains("column") || node.from + 3 != node.to || Filters.isReferenced(prefix = ((LexerToken)parsedF.getSrc().get((int)node.from)).content)) continue;
                finalMessage.append(oneErrorFound ? "\n" : "");
                oneErrorFound = true;
                finalMessage.append(MessageFormat.format(ExportMessages.getString("FILTER_DOESNT_MATCH_ANY_VIEW"), filter, filters.get(filter)));
            }
        }
        return finalMessage.toString();
    }
}

