/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import oracle.dbtools.extension.project.commands.stage.StageMessages;
import oracle.dbtools.extension.project.commands.stage.objectclasses.DbDiffObject;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.ChangelogGenerationException;
import oracle.dbtools.extension.project.core.exceptions.GitRefException;
import oracle.dbtools.extension.project.core.exceptions.GitRepoException;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.utils.ConsoleColors;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathSuffixFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class GitUtils {
    public static final String ERRORS = "ERROR";
    public static final String TOBECOMMITED = "TOBECOMMITED";
    public static final String STAGEDFORCOMMIT = "STAGEDFORCOMMIT";
    public static final String UNTRACKED = "untracked";
    public static final String COMMITTED = "commited";
    public static final String STAGED = "staged";

    private GitUtils() {
    }

    public static Git findGitRepo(File path) throws InterruptedException, IOException {
        FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
        repositoryBuilder.findGitDir(path);
        File dir = null;
        for (int count = 0; dir == null && count < 5; ++count) {
            dir = repositoryBuilder.getGitDir();
            Thread.sleep(200L);
        }
        if (dir != null) {
            return GitUtils.openRepo(dir);
        }
        return null;
    }

    public static Git openRepo(File repoDir) throws IOException {
        Repository repo = ((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setMustExist(true)).setGitDir(repoDir)).build();
        return new Git(repo);
    }

    public static String getCurrentBranchName(Git git) throws GitAPIException, IOException {
        Optional<Ref> ref = GitUtils.findCurrentBranch(git);
        return ref.map(Ref::getName).orElse(null);
    }

    public static Optional<Ref> findCurrentBranch(Git git) throws IOException, GitAPIException {
        String currentBranch = git.getRepository().getFullBranch();
        return git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call().stream().filter(e -> e.getName().equals(currentBranch)).findFirst();
    }

    public static void printDiff(DiffEntry diff, ScriptRunnerContext ctx) {
        String p1 = diff.getOldPath().equals(diff.getNewPath()) ? diff.getNewPath() : diff.getOldPath();
        ctx.writeln(p1 + " -> " + diff.getNewPath());
    }

    public static Map<String, LinkedList<DbDiffObject>> diffBranches(Repository repo, String branch, String master) throws ChangelogGenerationException {
        HashMap<String, LinkedList<DbDiffObject>> diffs = new HashMap<String, LinkedList<DbDiffObject>>();
        ArrayList<DbDiffObject> baseObjects = new ArrayList<DbDiffObject>();
        GeneralMessages.debugMessage("source branch: " + branch + "\n master branch: " + master);
        String PROCESS = ProjectSettings.getSettingAsString("stage.changeSelection");
        Git git = new Git(repo);
        try {
            FileTreeIterator branchTreeIterator;
            if (PROCESS.equalsIgnoreCase(UNTRACKED)) {
                branchTreeIterator = new FileTreeIterator(git.getRepository());
            } else if (PROCESS.equalsIgnoreCase(COMMITTED)) {
                branchTreeIterator = GitUtils.prepareTreeParser(git.getRepository(), branch);
            } else if (PROCESS.equalsIgnoreCase(STAGED)) {
                branchTreeIterator = new DirCacheIterator(git.getRepository().readDirCache());
            } else {
                throw new ChangelogGenerationException(StageMessages.get("BAD_DIFF_PROCESS"));
            }
            ProjectConfig.ctx.writeln("");
            ProjectConfig.ctx.writeln(StageMessages.get("DIFF_HEADER"));
            ProjectConfig.ctx.writeln(ConsoleColors.YELLOW.code + StageMessages.get("MASTER_BRANCH") + "\t" + master + ConsoleColors.RESET.code);
            ProjectConfig.ctx.writeln(ConsoleColors.GREEN.code + StageMessages.get("WORKING_BRANCH") + "\t" + branch + ConsoleColors.RESET.code);
            ProjectConfig.ctx.writeln("");
            AbstractTreeIterator masterTreeIterator = GitUtils.prepareTreeParser(repo, master);
            PathSuffixFilter sqlFilter = PathSuffixFilter.create((String)".sql");
            PathSuffixFilter plsFilter = PathSuffixFilter.create((String)".pls");
            PathSuffixFilter pkbFilter = PathSuffixFilter.create((String)".pkb");
            PathSuffixFilter pksFilter = PathSuffixFilter.create((String)".pks");
            PathSuffixFilter trgFilter = PathSuffixFilter.create((String)".trg");
            TreeFilter[] FileSuffixListFilter = new TreeFilter[]{sqlFilter, plsFilter, pkbFilter, pksFilter, trgFilter};
            TreeFilter orFilter = OrTreeFilter.create((TreeFilter[])FileSuffixListFilter);
            String relativePath = Paths.get(repo.getDirectory().toPath().getParent().relativize(ProjectConfig.getCurrentWorkingProjectRoot()).toString(), "src", "database").toString().replace("\\", "/");
            PathFilter srcFilter = PathFilter.create((String)relativePath);
            ArrayList<Object> filters = new ArrayList<Object>();
            filters.add(srcFilter);
            filters.add(orFilter);
            List entries = git.diff().setOldTree(masterTreeIterator).setNewTree((AbstractTreeIterator)branchTreeIterator).setPathFilter(AndTreeFilter.create(filters)).call();
            for (DiffEntry entry : entries) {
                boolean skip = true;
                String branchFileContent = null;
                String masterFileContent = null;
                if (GitUtils.isOrdsOrMle(entry.getNewPath()) || GitUtils.isApexApplicationFiles(entry.getNewPath()) || GitUtils.isOrdsOrMle(entry.getOldPath()) || GitUtils.isApexApplicationFiles(entry.getOldPath())) continue;
                if (ProjectConfig.isDebug()) {
                    GitUtils.printDiff(entry, ProjectConfig.ctx);
                }
                if (!diffs.containsKey(entry.getChangeType().toString())) {
                    diffs.put(entry.getChangeType().toString(), new LinkedList());
                }
                if ("DELETE".equalsIgnoreCase(entry.getChangeType().toString()) || "MODIFY".equalsIgnoreCase(entry.getChangeType().toString())) {
                    ObjectLoader loader = repo.open((AnyObjectId)entry.getOldId().toObjectId());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    loader.copyTo((OutputStream)baos);
                    masterFileContent = baos.toString(StandardCharsets.UTF_8);
                    if (masterFileContent == null) {
                        throw new IOException("Unable to generate valid diff, master data not found for " + entry.getOldPath());
                    }
                }
                if ("ADD".equalsIgnoreCase(entry.getChangeType().toString()) || "MODIFY".equalsIgnoreCase(entry.getChangeType().toString())) {
                    String filePath = entry.getNewPath();
                    Path file = Paths.get(repo.getWorkTree().getAbsolutePath(), filePath);
                    if (Files.exists(file, new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
                        branchFileContent = Files.readString(file, StandardCharsets.UTF_8);
                    }
                    if (branchFileContent == null) {
                        throw new IOException("Unable to generate valid diff source data not found for file " + String.valueOf(file));
                    }
                }
                if ("ADD".equalsIgnoreCase(entry.getChangeType().toString()) || "DELETE".equalsIgnoreCase(entry.getChangeType().toString())) {
                    skip = false;
                }
                if ("MODIFY".equalsIgnoreCase(entry.getChangeType().toString())) {
                    EditList edits = new HistogramDiff().diff((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)(branchFileContent != null && !branchFileContent.isEmpty() ? new RawText(branchFileContent.getBytes()) : RawText.EMPTY_TEXT), (Sequence)(masterFileContent != null && !masterFileContent.isEmpty() ? new RawText(masterFileContent.getBytes()) : RawText.EMPTY_TEXT));
                    int hashA = GitUtils.getHashLineNumber(branchFileContent);
                    int hashB = GitUtils.getHashLineNumber(masterFileContent);
                    for (Edit edit : edits) {
                        if (GitUtils.isBetween(hashA, ((Edit)edits.get(0)).getBeginA(), ((Edit)edits.get(0)).getEndA()) || GitUtils.isBetween(hashB, ((Edit)edits.get(0)).getBeginB(), ((Edit)edits.get(0)).getEndB())) continue;
                        skip = false;
                        break;
                    }
                }
                if (!skip) {
                    DbDiffObject obj = new DbDiffObject(entry, branchFileContent, masterFileContent);
                    if (obj.getObjectType().equals("TABLE") && obj.getBaseObjectFromSql().isEmpty()) {
                        baseObjects.add(obj);
                    }
                    diffs.get(entry.getChangeType().toString()).add(obj);
                    continue;
                }
                GeneralMessages.debugMessage(ConsoleColors.YELLOW, "Skipping file: " + entry.getOldPath() + " becasue the only changes are in the sxml");
            }
            List<String> allowedObjects = Arrays.asList("INDEX", "MATERIALIZED_VIEW_LOG", "REF_CONSTRAINT", "TRIGGER");
            if (!diffs.isEmpty() && diffs.containsKey("DELETE")) {
                Iterator iterator = diffs.get("DELETE").iterator();
                block4: while (iterator.hasNext()) {
                    DbDiffObject dbObj = (DbDiffObject)iterator.next();
                    if (dbObj.getBaseObjectFromSql().isEmpty()) continue;
                    for (DbDiffObject dbObj2 : baseObjects) {
                        boolean condition;
                        if (dbObj.getObjectType().equals("REF_CONSTRAINT")) {
                            condition = dbObj.getBaseObjectFromSql().get(0).contains(dbObj2.getObjectName().toLowerCase()) && allowedObjects.contains(dbObj.getObjectType());
                        } else {
                            boolean bl = condition = dbObj.getBaseObjectFromSql().contains(dbObj2.getObjectName().toLowerCase()) && allowedObjects.contains(dbObj.getObjectType());
                        }
                        if (!condition) continue;
                        GeneralMessages.warnMessage(StageMessages.format("PREVENT_DEPENDENT_DROPS_WARN", dbObj.getObjectName(), dbObj.getObjectType(), dbObj2.getObjectName(), dbObj2.getObjectType()));
                        iterator.remove();
                        continue block4;
                    }
                }
            }
            return diffs;
        }
        catch (IOException | GitAPIException io) {
            throw new ChangelogGenerationException(io.getMessage(), io);
        }
    }

    public static boolean isBetween(int number, int lowerBound, int upperBound) {
        return number >= lowerBound && number <= upperBound;
    }

    private static int getHashLineNumber(String data) {
        try {
            LineNumberReader lines = new LineNumberReader(new StringReader(data));
            String line = lines.readLine();
            while (line != null) {
                if (line.startsWith("-- sqlcl_snapshot")) {
                    return lines.getLineNumber() - 1;
                }
                line = lines.readLine();
            }
            return 999999;
        }
        catch (IOException e) {
            return 999999;
        }
    }

    private static boolean isOrdsOrMle(String entryPath) {
        return FilenameUtils.wildcardMatch((String)entryPath, (String)"**/src/database/*/ords/*") || FilenameUtils.wildcardMatch((String)entryPath, (String)"src/database/*/ords/*");
    }

    private static boolean isApexApplicationFiles(String entryPath) {
        return FilenameUtils.wildcardMatch((String)entryPath, (String)"**/src/database/*/apex_apps/*") || FilenameUtils.wildcardMatch((String)entryPath, (String)"src/database/*/apex_apps/*");
    }

    private static AbstractTreeIterator prepareTreeParser(Repository repo, String ref) throws IOException, GitAPIException {
        Ref head = repo.exactRef(ref);
        if (null == head) {
            throw new GitRefException(StageMessages.getString("NULL_GIT_REF"));
        }
        try (RevWalk walk = new RevWalk(repo);){
            RevCommit commit = walk.parseCommit((AnyObjectId)head.getObjectId());
            RevTree tree = walk.parseTree((AnyObjectId)commit.getTree().getId());
            CanonicalTreeParser treeParser = new CanonicalTreeParser();
            try (ObjectReader reader = repo.newObjectReader();){
                treeParser.reset(reader, (AnyObjectId)tree.getId());
            }
            walk.dispose();
            CanonicalTreeParser canonicalTreeParser = treeParser;
            return canonicalTreeParser;
        }
    }

    public static void displayUncommited(Repository repo, String projectRoot, ScriptRunnerContext ctx) throws GitAPIException {
        try (Git git = new Git(repo);){
            Set removed;
            String project;
            Status status = projectRoot != null && !projectRoot.isEmpty() ? (!(project = Paths.get(repo.getDirectory().getParent(), new String[0]).relativize(Paths.get(projectRoot, new String[0])).toString()).isEmpty() ? git.status().addPath(project).call() : git.status().call()) : git.status().call();
            Set added = status.getAdded();
            if (!added.isEmpty()) {
                GeneralMessages.generalMessage(ConsoleColors.YELLOW, "Changes to be committed");
                for (String add : added) {
                    GeneralMessages.generalMessage(ConsoleColors.GREEN, "\tadded: " + add);
                }
                ctx.writeln("");
            }
            Set changed = status.getChanged();
            Set missing = status.getMissing();
            Set modified = status.getModified();
            if (!(changed.isEmpty() && missing.isEmpty() && modified.isEmpty())) {
                GeneralMessages.generalMessage(ConsoleColors.YELLOW, "Changes not staged for commit");
                for (String change : changed) {
                    GeneralMessages.generalMessage(ConsoleColors.RED, "\tchanged: " + change);
                }
                for (String miss : missing) {
                    GeneralMessages.generalMessage(ConsoleColors.RED, "\tdeleted: " + miss);
                }
                for (Object modify : modified) {
                    GeneralMessages.generalMessage(ConsoleColors.RED, "\tmodified: " + (String)modify);
                }
                ctx.writeln("");
            }
            if (!(removed = status.getRemoved()).isEmpty()) {
                GeneralMessages.generalMessage(ConsoleColors.YELLOW, "Changes to be removed");
                for (String remove : removed) {
                    GeneralMessages.generalMessage(ConsoleColors.RED, "\tremoved: " + remove);
                }
                ctx.writeln("");
            }
            GeneralMessages.generalMessage(ConsoleColors.YELLOW, " Untracked files:");
            Set untrackedFolders = status.getUntrackedFolders();
            for (String untrack : untrackedFolders) {
                GeneralMessages.generalMessage(ConsoleColors.RED, "\t" + untrack);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String detectDefaultBranch(Path root) throws GitRepoException, InterruptedException {
        try (Git git = GitUtils.findGitRepo(root.toFile());){
            String targetBranch;
            if (git == null) return ProjectSettings.getSettingAsString("git.defaultBranch");
            Repository repo = git.getRepository();
            Ref headRef = repo.findRef("refs/remotes/origin/HEAD");
            if (headRef != null && headRef.isSymbolic() && (targetBranch = headRef.getTarget().getName()).startsWith("refs/remotes/origin/")) {
                String string = targetBranch.substring("refs/remotes/origin/".length());
                return string;
            }
            Ref ref = repo.exactRef("HEAD");
            if (ref == null) return ProjectSettings.getSettingAsString("git.defaultBranch");
            if (!ref.isSymbolic()) return ProjectSettings.getSettingAsString("git.defaultBranch");
            String currentRef = ref.getTarget().getName();
            if (!currentRef.startsWith("refs/heads/")) return ProjectSettings.getSettingAsString("git.defaultBranch");
            String string = currentRef.substring("refs/heads/".length());
            return string;
        }
        catch (IOException e) {
            throw new GitRepoException(e);
        }
    }
}

