/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage.objectclasses;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.extension.project.commands.stage.objectclasses.SrcSnapShot;
import oracle.dbtools.extension.project.commands.stage.transforms.ObjectTypes;
import oracle.dbtools.extension.project.commands.stage.transforms.StageConstants;
import oracle.dbtools.extension.project.core.exceptions.ChangelogGenerationException;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.diff.ObjectDiff;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jgit.diff.DiffEntry;

public class DbDiffObject {
    DiffEntry diffEntry;
    String sourceFileContent;
    String fileName;
    String objectType;
    String objectName;
    String action;
    boolean isSoftObject;
    String schema;
    String masterFileContent;
    String branchFileContent;
    String masterHash;
    String branchHash;
    String masterSxml;
    SqlRecognizer masterSqlRecognizer;
    String branchSxml;
    SqlRecognizer branchSqlRecognizer;
    ChangelogGenerationException exception;
    String rawOutput;
    String cleanedOutput;
    boolean hasDelete;
    String logicalPath;
    Path destPath;
    List<String> mvLogDependentObjects = new ArrayList<String>();

    public DbDiffObject(DiffEntry diffEntry, String branchContent, String masterContent) throws JsonProcessingException {
        this.diffEntry = diffEntry;
        this.action = diffEntry.getChangeType().toString();
        this.masterFileContent = masterContent;
        this.branchFileContent = branchContent;
        SrcSnapShot snapShot = null;
        if ("ADD".equals(diffEntry.getChangeType().toString()) || "MODIFY".equals(diffEntry.getChangeType().toString())) {
            this.fileName = Paths.get(diffEntry.getNewPath(), new String[0]).getFileName().toString();
            this.fileName = this.fileName.replace(FilenameUtils.getExtension((String)this.fileName), "sql");
            this.sourceFileContent = this.branchFileContent;
            snapShot = SrcSnapShot.loadSnapShot(this.branchFileContent);
            if (snapShot != null) {
                this.branchSxml = snapShot.getSxml();
                this.branchHash = snapShot.getHash();
                if (this.objectType == null) {
                    this.objectType = snapShot.getType();
                }
                if (this.objectName == null) {
                    this.objectName = snapShot.getName();
                }
                if (this.schema == null) {
                    this.schema = snapShot.getSchemaName();
                }
            }
        }
        if ("DELETE".equals(diffEntry.getChangeType().toString()) || "MODIFY".equals(diffEntry.getChangeType().toString())) {
            this.fileName = Paths.get(diffEntry.getOldPath(), new String[0]).getFileName().toString();
            this.fileName = this.fileName.replace(FilenameUtils.getExtension((String)this.fileName), "sql");
            this.sourceFileContent = null;
            snapShot = SrcSnapShot.loadSnapShot(this.masterFileContent);
            if (snapShot != null) {
                this.masterSxml = snapShot.getSxml();
                this.masterHash = snapShot.getHash();
                if (this.objectType == null) {
                    this.objectType = snapShot.getType();
                }
                if (this.objectName == null) {
                    this.objectName = snapShot.getName();
                }
                if (this.schema == null) {
                    this.schema = snapShot.getSchemaName();
                }
            }
        }
        if ("DELETE".equals(diffEntry.getChangeType().toString()) && "MATERIALIZED_VIEW_LOG".equals(this.objectType)) {
            this.mvLogDependentObjects.addAll(this.getBaseObjectFromSql());
        }
        if (this.fileName == null) {
            this.fileName = Paths.get(diffEntry.getNewPath(), new String[0]).getFileName().toString();
            this.fileName = this.fileName.replace(FilenameUtils.getExtension((String)this.fileName), "sql");
        }
        if (this.objectType == null) {
            this.objectType = ObjectTypes.singular(Paths.get(diffEntry.getNewPath(), new String[0]).getParent().getFileName().toString().toUpperCase());
        }
        this.isSoftObject = StageConstants.SoftObjects.contains(this.objectType);
        if (this.schema == null) {
            this.schema = Paths.get(diffEntry.getNewPath(), new String[0]).getParent().getParent().getFileName().toString().toUpperCase();
        }
        if (this.getObjectType() != null && !this.getObjectType().equalsIgnoreCase("mle_module") && !this.getObjectType().equalsIgnoreCase("APEX_APPLICATIONS")) {
            if (masterContent != null && !masterContent.isEmpty()) {
                this.masterSqlRecognizer = new SqlRecognizer(masterContent);
            }
            if (branchContent != null && !branchContent.isEmpty()) {
                this.branchSqlRecognizer = new SqlRecognizer(branchContent);
            }
        }
        try {
            if (this.objectName == null && this.masterSqlRecognizer != null) {
                this.objectName = (String)this.branchSqlRecognizer.getObjectNames().get(0);
            } else if (this.objectName == null && this.masterSqlRecognizer == null) {
                this.objectName = this.fileName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<String> getBaseObjectFromSql() {
        if (this.masterSqlRecognizer == null) {
            return new ArrayList<String>();
        }
        return this.masterSqlRecognizer.getReferencedTypes();
    }

    public String getDestFileName() {
        return this.fileName;
    }

    public String objectDiff() {
        String ret = "";
        try {
            ret = ObjectDiff.instantiate(this.getMasterFileContent().substring(0, this.getMasterFileContent().indexOf("-- sqlcl_snapshot")).trim(), this.getBranchFileContent().substring(0, this.getBranchFileContent().indexOf("-- sqlcl_snapshot")).trim()).alters();
            this.setRawOutput(ret);
        }
        catch (Exception e) {
            GeneralMessages.debugException(e);
        }
        return ret;
    }

    @Generated
    public DiffEntry getDiffEntry() {
        return this.diffEntry;
    }

    @Generated
    public void setSourceFileContent(String sourceFileContent) {
        this.sourceFileContent = sourceFileContent;
    }

    @Generated
    public String getSourceFileContent() {
        return this.sourceFileContent;
    }

    @Generated
    public String getObjectType() {
        return this.objectType;
    }

    @Generated
    public String getObjectName() {
        return this.objectName;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public boolean isSoftObject() {
        return this.isSoftObject;
    }

    @Generated
    public void setSoftObject(boolean isSoftObject) {
        this.isSoftObject = isSoftObject;
    }

    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Generated
    public String getMasterFileContent() {
        return this.masterFileContent;
    }

    @Generated
    public String getBranchFileContent() {
        return this.branchFileContent;
    }

    @Generated
    public void setBranchFileContent(String branchFileContent) {
        this.branchFileContent = branchFileContent;
    }

    @Generated
    public String getMasterHash() {
        return this.masterHash;
    }

    @Generated
    public String getBranchHash() {
        return this.branchHash;
    }

    @Generated
    public void setBranchHash(String branchHash) {
        this.branchHash = branchHash;
    }

    @Generated
    public String getMasterSxml() {
        return this.masterSxml;
    }

    @Generated
    public SqlRecognizer getMasterSqlRecognizer() {
        return this.masterSqlRecognizer;
    }

    @Generated
    public void setMasterSqlRecognizer(SqlRecognizer masterSqlRecognizer) {
        this.masterSqlRecognizer = masterSqlRecognizer;
    }

    @Generated
    public String getBranchSxml() {
        return this.branchSxml;
    }

    @Generated
    public SqlRecognizer getBranchSqlRecognizer() {
        return this.branchSqlRecognizer;
    }

    @Generated
    public void setBranchSqlRecognizer(SqlRecognizer branchSqlRecognizer) {
        this.branchSqlRecognizer = branchSqlRecognizer;
    }

    @Generated
    public ChangelogGenerationException getException() {
        return this.exception;
    }

    @Generated
    public String getRawOutput() {
        return this.rawOutput;
    }

    @Generated
    public void setRawOutput(String rawOutput) {
        this.rawOutput = rawOutput;
    }

    @Generated
    public String getCleanedOutput() {
        return this.cleanedOutput;
    }

    @Generated
    public void setCleanedOutput(String cleanedOutput) {
        this.cleanedOutput = cleanedOutput;
    }

    @Generated
    public boolean hasDelete() {
        return this.hasDelete;
    }

    @Generated
    public DbDiffObject hasDelete(boolean hasDelete) {
        this.hasDelete = hasDelete;
        return this;
    }

    @Generated
    public String getLogicalPath() {
        return this.logicalPath;
    }

    @Generated
    public void setLogicalPath(String logicalPath) {
        this.logicalPath = logicalPath;
    }

    @Generated
    public Path getDestPath() {
        return this.destPath;
    }

    @Generated
    public void setDestPath(Path destPath) {
        this.destPath = destPath;
    }

    @Generated
    public List<String> getMvLogDependentObjects() {
        return this.mvLogDependentObjects;
    }

    @Generated
    public void setMvLogDependentObjects(List<String> mvLogDependentObjects) {
        this.mvLogDependentObjects = mvLogDependentObjects;
    }
}

