/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.init.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import oracle.dbtools.extension.project.commands.UtilMessages;
import oracle.dbtools.extension.project.commands.init.InitMessages;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.CreateFileException;
import oracle.dbtools.extension.project.core.exceptions.ProjectSettingsException;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.utils.ConsoleColors;
import oracle.dbtools.extension.project.core.utils.ProjectFileUtils;
import org.apache.commons.io.FileUtils;

public class InitUtils {
    Path projectRoot;
    Path cfgRoot;
    Path filterRoot;
    Path distRoot;
    Path srcRoot;
    Path dbRoot;
    Path rootReadme;
    Path projectConfig;
    Path sqlFormat;
    Path projectFilters;
    Path sysFilters;
    Path gitIgnore;

    public void checkDirectoriesAndFiles(Path root, LinkedList<String> schemas) throws CreateFileException, IOException {
        LinkedList<Path> dirs = new LinkedList<Path>();
        this.projectRoot = Paths.get(root.toString(), new String[0]);
        if (!this.projectRoot.toFile().exists()) {
            dirs.add(this.projectRoot);
        }
        this.cfgRoot = Paths.get(this.projectRoot.toString(), ".dbtools");
        if (!this.cfgRoot.toFile().exists()) {
            dirs.add(this.cfgRoot);
        }
        this.filterRoot = Paths.get(this.cfgRoot.toString(), "filters");
        if (!this.filterRoot.toFile().exists()) {
            dirs.add(this.filterRoot);
        }
        this.distRoot = Paths.get(this.projectRoot.toString(), "dist");
        if (!this.distRoot.toFile().exists()) {
            dirs.add(this.distRoot);
        }
        this.srcRoot = Paths.get(this.projectRoot.toString(), "src");
        if (!this.srcRoot.toFile().exists()) {
            dirs.add(this.srcRoot);
        }
        this.dbRoot = Paths.get(this.srcRoot.toString(), "database");
        if (!this.dbRoot.toFile().exists()) {
            dirs.add(this.dbRoot);
        }
        if (schemas != null) {
            for (String schema : schemas) {
                Path schemaDir = Paths.get(this.dbRoot.toString(), schema.toLowerCase());
                if (schemaDir.toFile().exists()) continue;
                dirs.add(schemaDir);
            }
        }
        this.createDirs(dirs);
        this.createFiles();
    }

    private void createDirs(LinkedList<Path> dirs) throws IOException {
        for (Path dir : dirs) {
            if (dir.toFile().exists()) continue;
            if (this.projectRoot.toString().equalsIgnoreCase(dir.toString())) {
                GeneralMessages.createDirMsg(this.projectRoot.toFile().getName());
            } else {
                GeneralMessages.createDirMsg(this.projectRoot.getParent().relativize(dir).toString());
            }
            FileUtils.forceMkdir((File)dir.toFile());
        }
    }

    public LinkedList<String> checkSchemas(LinkedList<String> schemas) throws ProjectSettingsException {
        if (schemas == null || schemas.isEmpty()) {
            if (ProjectConfig.getCurrentContext().getCurrentConnection() != null) {
                try {
                    String schema = ProjectConfig.getCurrentContext().getCurrentConnection().getSchema();
                    schemas = new LinkedList();
                    schemas.add(schema);
                }
                catch (SQLException e) {
                    throw new ProjectSettingsException(InitMessages.getString("NO_SCHEMA"));
                }
            } else {
                schemas = new LinkedList();
            }
        }
        return schemas;
    }

    private void createFiles() throws CreateFileException {
        if (this.cfgRoot != null && this.cfgRoot.toFile().exists()) {
            this.sqlFormat = this.createFileUsingTemplate(this.cfgRoot, "project.sqlformat.xml", "export/format/project.sqlformat.xml");
        }
        if (this.filterRoot != null && this.filterRoot.toFile().exists()) {
            this.projectFilters = this.createFileUsingTemplate(this.filterRoot, "project.filters", "export/filters/project.filters");
        }
        if (this.projectRoot != null && this.projectRoot.toFile().exists()) {
            this.gitIgnore = this.createOrAppendToFileUsingTemplate(this.projectRoot, ".gitignore", "oracle/dbtools/extension/project/commands/init/templates/gitIgnore.tmpl");
            this.rootReadme = this.createOrAppendToFileUsingTemplate(this.projectRoot, "README.md", "oracle/dbtools/extension/project/commands/init/templates/ProjectReadme.md.tmpl");
        }
    }

    public Path createOrAppendToFileUsingTemplate(Path directory, String fileName, String template) throws CreateFileException {
        return this.createFileUsingTemplate(directory, fileName, template, null, StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
    }

    public Path createOrAppendToFileUsingTemplate(Path directory, String fileName, String template, Map<String, String> replaceStrings) throws CreateFileException {
        return this.createFileUsingTemplate(directory, fileName, template, replaceStrings, StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
    }

    public Path createFileUsingTemplate(Path directory, String fileName, String template) throws CreateFileException {
        return this.createFileUsingTemplate(directory, fileName, template, null, new OpenOption[0]);
    }

    public Path createFileUsingTemplate(Path directory, String fileName, String template, Map<String, String> replaceStrings, OpenOption ... options) throws CreateFileException {
        Path file = Paths.get(directory.toString(), fileName);
        if (!file.toFile().exists()) {
            GeneralMessages.createFileMsg(this.projectRoot.getParent().relativize(file).toString());
        }
        try {
            ProjectFileUtils.createFileWithContent(file, ProjectFileUtils.getResourcesFileContent(Paths.get(template, new String[0])), replaceStrings, options);
        }
        catch (IOException e) {
            GeneralMessages.debugException(e);
            throw new CreateFileException(UtilMessages.format("FILE_CREATE_ERROR", ConsoleColors.RED.code, ConsoleColors.RESET.code, this.projectRoot.relativize(file).toString(), file, e));
        }
        return file;
    }

    public Path buildProjectRoot(String projectName, String dirStr, boolean makeRoot) throws IOException {
        Path dirPath;
        Path root = dirStr == null || dirStr.isEmpty() ? Paths.get(ProjectConfig.getCWD(), new String[0]) : (!(dirPath = Paths.get(dirStr, new String[0])).isAbsolute() ? Paths.get(ProjectConfig.getCWD(), dirPath.toString()) : Paths.get(dirPath.toString(), new String[0]));
        if (makeRoot) {
            root = Paths.get(root.toString(), projectName);
        }
        return root;
    }

    @Generated
    public Path getProjectRoot() {
        return this.projectRoot;
    }

    @Generated
    public Path getCfgRoot() {
        return this.cfgRoot;
    }

    @Generated
    public Path getFilterRoot() {
        return this.filterRoot;
    }

    @Generated
    public Path getDistRoot() {
        return this.distRoot;
    }

    @Generated
    public Path getSrcRoot() {
        return this.srcRoot;
    }

    @Generated
    public Path getDbRoot() {
        return this.dbRoot;
    }

    @Generated
    public Path getRootReadme() {
        return this.rootReadme;
    }
}

