/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.genartifact;

import java.io.File;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.Arrays;
import oracle.dbtools.extension.project.commands.Interfaces.CommandInterface;
import oracle.dbtools.extension.project.commands.ProjectMessages;
import oracle.dbtools.extension.project.commands.genartifact.GenArtifactMessages;
import oracle.dbtools.extension.project.commands.handler.ProjectOptions;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.ArtifactFormatException;
import oracle.dbtools.extension.project.core.exceptions.ProjectNotIdentifiedException;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.utils.FileCompressionUtils;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class GenArtifactCommand
implements CommandInterface {
    @Override
    public void run(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand command) {
        try {
            ProjectConfig.setupDebugVerbose(command);
            Object artifactName = (String)command.getOptionValue((Id)ProjectOptions.Options.NAME);
            String artifactVersion = (String)command.getOptionValue((Id)ProjectOptions.Options.VERSION);
            String artifactFormat = (String)command.getOptionValue((Id)ProjectOptions.Options.FORMAT);
            boolean force = command.isFlagSet((Id)ProjectOptions.Options.FORCE);
            Path root = ProjectConfig.getCurrentWorkingProjectRoot();
            if (root == null) {
                throw new ProjectNotIdentifiedException(ProjectMessages.getString("PROJECT_NOT_IDENTIFIED"));
            }
            if (artifactName == null || ((String)artifactName).isEmpty()) {
                artifactName = ProjectSettings.getSettingAsString("project");
            }
            if (artifactName == null || ((String)artifactName).isEmpty()) {
                throw new ArtifactFormatException(GenArtifactMessages.getString("ARTIFACT_NAME_NOT_FOUND"));
            }
            if (artifactVersion == null || artifactVersion.isEmpty()) {
                String relVer = ProjectSettings.getSettingAsString("lastReleaseVersion");
                if (relVer != null && !relVer.isEmpty()) {
                    artifactName = (String)artifactName + "-" + relVer;
                }
            } else {
                artifactName = (String)artifactName + "-" + artifactVersion;
            }
            if (!Arrays.asList("zip", "tgz").contains(artifactFormat)) {
                throw new ArtifactFormatException(GenArtifactMessages.getString("ARTIFACT_FORMAT_NOT_SUPPORTED"));
            }
            Path artifactPath = Path.of(root.toString(), "artifact", (String)artifactName + "." + artifactFormat);
            if (new File(artifactPath.toString()).exists() && !force) {
                throw new FileAlreadyExistsException(GenArtifactMessages.format("ARTIFACT_ALREADY_EXIST", artifactName));
            }
            FileCompressionUtils.compressFolder(Path.of(root.toString(), "dist"), Path.of(root.toString(), "artifact"), (String)artifactName, artifactFormat);
            GeneralMessages.successMessage("Your artifact has been generated " + (String)artifactName + "." + artifactFormat);
        }
        catch (Exception e) {
            GeneralMessages.errorMessage(ProjectMessages.format("PROCESSING_ERROR", e.getMessage()));
            GeneralMessages.debugException(e);
        }
    }
}

