/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.export;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.arbori.util.Pair;
import oracle.dbtools.extension.project.commands.export.DbObj;

public class TransitiveClosure {
    private Collection<Pair<DbObj, DbObj>> links = new LinkedList<Pair<DbObj, DbObj>>();
    private DbObj[] objectNames;
    private Map<DbObj, Integer> objectIndices = new HashMap<DbObj, Integer>();
    Map<Integer, Map<Integer, Integer>> adjacencyMatrix = new TreeMap<Integer, Map<Integer, Integer>>();
    Map<Integer, Map<Integer, Integer>> distance = new TreeMap<Integer, Map<Integer, Integer>>();
    boolean debug = false;

    public static TransitiveClosure getInstance(Collection<Pair<DbObj, DbObj>> links) throws SQLException {
        TransitiveClosure r = new TransitiveClosure();
        for (Pair<DbObj, DbObj> link : links) {
            r.addLink(link);
        }
        return r;
    }

    public static TransitiveClosure getInstance(Map<Pair<DbObj, DbObj>, Integer> distances) throws SQLException {
        TransitiveClosure r = new TransitiveClosure();
        for (Pair<DbObj, DbObj> link : distances.keySet()) {
            r.addLink(link);
            int from = r.objectIndices.get(link.first());
            int to = r.objectIndices.get(link.second());
            r.setDistance(from, to, distances.get(link));
        }
        return r;
    }

    void setDistance(int i, int j, int d) {
        Map<Integer, Integer> row = this.distance.get(i);
        if (row == null) {
            row = new TreeMap<Integer, Integer>();
            this.distance.put(i, row);
        }
        row.put(j, d);
    }

    int getDistance(int i, int j) {
        Map<Integer, Integer> row = this.distance.get(i);
        if (row == null) {
            return Integer.MAX_VALUE;
        }
        Integer ret = row.get(j);
        if (ret == null) {
            return Integer.MAX_VALUE;
        }
        return ret;
    }

    private void addLink(Pair<DbObj, DbObj> link) {
        this.links.add(link);
        if (!this.objectIndices.containsKey(link.first())) {
            this.objectIndices.put((DbObj)link.first(), this.objectIndices.size());
        }
        if (!this.objectIndices.containsKey(link.second())) {
            this.objectIndices.put((DbObj)link.second(), this.objectIndices.size());
        }
    }

    public void initAdjMatrix() {
        for (Pair<DbObj, DbObj> link : this.links) {
            int i = this.objectIndices.get(link.first());
            Map<Integer, Integer> row = this.adjacencyMatrix.get(i);
            if (row == null) {
                row = new TreeMap<Integer, Integer>();
                this.adjacencyMatrix.put(i, row);
            }
            row.put(this.objectIndices.get(link.second()), 1);
        }
    }

    private void initObjectNames() {
        this.objectNames = new DbObj[this.objectIndices.size()];
        Iterator<DbObj> iterator = this.objectIndices.keySet().iterator();
        while (iterator.hasNext()) {
            DbObj key;
            this.objectNames[this.objectIndices.get((Object)key).intValue()] = key = iterator.next();
        }
    }

    public void tc() {
        for (int i = 0; i < this.objectNames.length; ++i) {
            this.setDistance(i, i, 0);
        }
        for (int i : this.adjacencyMatrix.keySet()) {
            for (int j : this.adjacencyMatrix.get(i).keySet()) {
                this.setDistance(i, j, 1);
            }
        }
        for (int k = 0; k < this.objectNames.length; ++k) {
            Map<Integer, Integer> row2 = this.distance.get(k);
            if (row2 == null) continue;
            for (int i = 0; i < this.objectNames.length; ++i) {
                int ik = this.getDistance(i, k);
                if (ik == Integer.MAX_VALUE) continue;
                for (int j : row2.keySet()) {
                    int kj = this.getDistance(k, j);
                    if (kj == Integer.MAX_VALUE) continue;
                    int dist = this.getDistance(i, j);
                    int sum = ik + kj;
                    if (dist != Integer.MAX_VALUE) {
                        sum = Math.max(dist, sum);
                    }
                    this.setDistance(i, j, sum);
                }
            }
        }
    }

    public List<DbObj> order() {
        this.initObjectNames();
        if (this.distance.keySet().size() == 0) {
            this.initAdjMatrix();
            this.tc();
        }
        TreeMap<DbObj, Integer> maxGrades = new TreeMap<DbObj, Integer>();
        for (Pair<DbObj, DbObj> o : this.links) {
            maxGrades.put((DbObj)o.first(), 0);
        }
        for (int i = 0; i < this.objectNames.length; ++i) {
            for (int j = 0; j < this.objectNames.length; ++j) {
                Integer tmp;
                int dist = this.getDistance(i, j);
                if (dist >= Integer.MAX_VALUE) continue;
                DbObj from = this.objectNames[i];
                DbObj to = this.objectNames[j];
                if (dist != 0 && this.debug) {
                    System.out.println(String.valueOf(from) + "-->" + String.valueOf(to) + "  " + dist);
                }
                if ((tmp = (Integer)maxGrades.get(to)) != null && tmp >= dist) continue;
                maxGrades.put(to, dist);
            }
        }
        TreeMap<Integer, TreeSet<DbObj>> gradedObjects = new TreeMap<Integer, TreeSet<DbObj>>();
        for (DbObj key : maxGrades.keySet()) {
            TreeSet<DbObj> objects;
            Integer grade = (Integer)maxGrades.get(key);
            if (this.debug) {
                System.out.println(String.valueOf(key) + "=" + grade);
            }
            if ((objects = (TreeSet<DbObj>)gradedObjects.get(grade)) == null) {
                objects = new TreeSet<DbObj>();
                gradedObjects.put(grade, objects);
            }
            objects.add(key);
        }
        LinkedList<DbObj> ret = new LinkedList<DbObj>();
        for (Integer i : gradedObjects.keySet()) {
            for (DbObj o : (Set)gradedObjects.get(i)) {
                ret.add(o);
            }
        }
        return ret;
    }
}

