/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rest;

import java.sql.CallableStatement;
import java.sql.SQLException;
import oracle.dbtools.extension.rest.ORDSExportPackage;
import oracle.dbtools.extension.rest.ORDSItemType;
import oracle.dbtools.extension.rest.RestExportCall;
import oracle.dbtools.extension.rest.RestOptions;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.jdbc.OracleConnection;

public class RestExportClientCall
extends RestExportCall {
    String schemaName;
    Boolean runnableAsAdmin;
    ParsedCommand parsedCommand;
    private static final String EXPORT_FUNCTION_NAME = "EXPORT_OAUTH_CLIENT";

    public RestExportClientCall(ParsedCommand command) {
        super(ORDSItemType.CLIENT, (String)command.getParameterValue((Id)RestOptions.Symbol.ITEM_NAME));
        this.parsedCommand = command;
        this.setCommandOptions(this.parsedCommand);
    }

    @Override
    public CallableStatement getCallableStatement(OracleConnection conn) throws SQLException {
        String plSqlCode = super.getPLSQL_CODE_BLOCK_CALL();
        plSqlCode = plSqlCode.replace(":PACKAGE_FUNCTION", EXPORT_FUNCTION_NAME);
        String client_name = super.getOrdsItemName();
        ORDSExportPackage ordsExportPackage = "".equals(this.schemaName) ? ORDSExportPackage.PUBLIC : ORDSExportPackage.ADMIN;
        plSqlCode = plSqlCode.replace(":ORDS_PACKAGE", ordsExportPackage.getString());
        plSqlCode = plSqlCode.replace(":PARAMETERS", this.constructParameters(ordsExportPackage));
        CallableStatement stmt = conn.prepareCall(plSqlCode);
        stmt.registerOutParameter(1, 2005);
        return stmt;
    }

    private String constructParameters(ORDSExportPackage ordsExportPackage) {
        StringBuilder baseParameters = new StringBuilder("p_client_name => '" + super.getOrdsItemName() + "', p_include_security_definitions => true");
        StringBuilder parameters = new StringBuilder(baseParameters);
        if (ordsExportPackage.equals((Object)ORDSExportPackage.ADMIN)) {
            parameters.append(", p_schema => '" + this.schemaName + "'");
            parameters.append(", p_runnable_as_admin => " + this.runnableAsAdmin);
        }
        return parameters.toString();
    }

    private void setCommandOptions(ParsedCommand parsedCommand) {
        this.schemaName = (String)parsedCommand.getOptionValue((Id)RestOptions.Symbol.SCHEMA_NAME);
        this.runnableAsAdmin = (Boolean)parsedCommand.getOptionValue((Id)RestOptions.Symbol.RUNNABLE_AS_ADMIN);
    }
}

