/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.text;

import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.reports.text.TextReportContext;
import java.util.Collection;
import java.util.TreeMap;

public enum TextReportSectionName {
    REPORT_DETAILS(Part.MAIN, 0, HeaderDecoration.UNDERLINED),
    PDB_SUMMARY(Part.PDB_LIST, 1, HeaderDecoration.UNDERLINED),
    SRC_DATABASE_DETAILS(Part.MAIN, 2, HeaderDecoration.UNDERLINED),
    ANALYSIS_NOTES(Part.MAIN, 3, HeaderDecoration.UNDERLINED),
    VERSION_INFORMATION(Part.MAIN, 4, HeaderDecoration.UNDERLINED),
    PATCH_INFORMATION(Part.MAIN, 5, HeaderDecoration.UNDERLINED),
    CHECK_SUMMARY(Part.MAIN, 6, HeaderDecoration.SOLID_LINE_FULL_WIDTH),
    CHECK_LIST(Part.MAIN, 7, HeaderDecoration.SOLID_LINE_FULL_WIDTH),
    CHECK_TITLE(Part.CHECK_LIST, 1, HeaderDecoration.SUPPRESSED),
    CHECK_DETAILS(Part.CHECK_LIST, 2, HeaderDecoration.SUPPRESSED),
    REPORT_LEGEND(Part.MAIN, 8, HeaderDecoration.SOLID_LINE_FULL_WIDTH),
    RESULT_LEGEND(Part.REPORT_LEGEND, 1, HeaderDecoration.UNDERLINED),
    REPORT_NOTES(Part.REPORT_LEGEND, 2, HeaderDecoration.UNDERLINED);

    private final Part part;
    private final int order;
    private final HeaderDecoration headerDecoration;
    private final Language lang = Language.getInstance();

    private TextReportSectionName(Part part, int order, HeaderDecoration decoration) {
        this.order = order;
        this.part = part;
        this.headerDecoration = decoration;
    }

    public String getSectionHeader(TextReportContext reportContext) {
        StringBuilder builder = new StringBuilder();
        String NL = System.lineSeparator();
        switch (this.headerDecoration) {
            case SUPPRESSED: {
                break;
            }
            case UNDERLINED: {
                String headerText = this.getSectionHeaderText();
                builder.append(NL).append(headerText).append(NL).append(Utilities.repeatCharacter(headerText.length(), '~')).append(NL);
                break;
            }
            case SOLID_LINE_FULL_WIDTH: 
            case DASHED_LINE_FULL_WIDTH: {
                String headerText = this.getSectionHeaderText();
                String line = this.headerDecoration == HeaderDecoration.SOLID_LINE_FULL_WIDTH ? reportContext.getSolidLine() : reportContext.getDashedLine();
                builder.append(NL).append(line).append(NL).append(headerText).append(NL).append(line).append(NL);
                break;
            }
            default: {
                builder.append(this.getSectionHeaderText()).append(NL);
            }
        }
        return builder.toString();
    }

    private String getSectionHeaderText() {
        return this.lang.txt(this.name() + "_HEADER");
    }

    public static Collection<TextReportSectionName> getOrderForPart(Part part) {
        TreeMap<Integer, TextReportSectionName> orderedSectionNames = new TreeMap<Integer, TextReportSectionName>();
        for (TextReportSectionName name : TextReportSectionName.values()) {
            if (name.part != part) continue;
            orderedSectionNames.put(name.order, name);
        }
        return orderedSectionNames.values();
    }

    public static enum Part {
        MAIN,
        CHECK_LIST,
        PDB_LIST,
        REPORT_LEGEND;

    }

    private static enum HeaderDecoration {
        SUPPRESSED,
        UNDERLINED,
        SOLID_LINE_FULL_WIDTH,
        DASHED_LINE_FULL_WIDTH;

    }
}

