/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports;

import com.oracle.premigration.commons.enums.ReportNote;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.reports.CheckResultDescription;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.text.ReportNotes;
import com.oracle.premigration.reports.text.TextProperty;
import com.oracle.premigration.reports.text.TextReportSectionName;
import com.oracle.premigration.reports.text.TextValueHint;
import com.oracle.premigration.reports.text.serialization.TextReportNotesTable;
import com.oracle.premigration.reports.text.serialization.TextReportResultDescriptionTable;
import java.util.ArrayList;
import java.util.List;

public class ReportLegend {
    private static ReportLegend instance = null;
    @TextProperty(labelKey="<none>", section=TextReportSectionName.RESULT_LEGEND, serializationClass=TextReportResultDescriptionTable.class, valueHint=TextValueHint.NATURAL_LANGUAGE)
    @HtmlProperty(labelKey="<none>", section=HtmlReportSectionName.RESULT_DESCRIPTIONS, isClassInfo=false)
    private final List<CheckResultDescription> checkResultDescriptions;
    @TextProperty(labelKey="<none>", section=TextReportSectionName.REPORT_NOTES, serializationClass=TextReportNotesTable.class, valueHint=TextValueHint.NATURAL_LANGUAGE)
    @HtmlProperty(labelKey="<none>", section=HtmlReportSectionName.REPORT_NOTES, isClassInfo=false)
    private final List<ReportNotes> reportNotes;

    private ReportLegend(List<CheckResultDescription> checkResultDescriptions, List<ReportNotes> reportNotes) {
        this.checkResultDescriptions = checkResultDescriptions;
        this.reportNotes = reportNotes;
    }

    public static ReportLegend getInstance() {
        if (instance != null) {
            return instance;
        }
        Language lang = Language.getInstance();
        ArrayList<CheckResultDescription> checkResultDescriptions = new ArrayList<CheckResultDescription>();
        ArrayList<ReportNotes> reportNotes = new ArrayList<ReportNotes>(ReportNote.toReportNotesList());
        for (CheckResult checkResult : CheckResult.values()) {
            checkResultDescriptions.add(checkResult.toCheckResultDescription(lang));
        }
        instance = new ReportLegend(checkResultDescriptions, reportNotes);
        return instance;
    }

    public List<CheckResultDescription> getCheckResultDescriptions() {
        return this.checkResultDescriptions;
    }

    public List<ReportNotes> getReportNotes() {
        return this.reportNotes;
    }
}

