/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.loadpwd.security.keystorage;

import com.oracle.premigration.commons.Constants;
import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.exceptions.PremigrationException;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.loadpwd.helpers.Job;
import com.oracle.premigration.loadpwd.security.keystorage.CommonPasswordConsoleUtils;
import com.oracle.premigration.loadpwd.security.keystorage.KeyStorage;
import com.oracle.premigration.loadpwd.security.keystorage.KeyStoreManager;
import com.oracle.premigration.loadpwd.security.keystorage.KeyStorePasswordInfo;
import com.oracle.premigration.loadpwd.security.keystorage.ModifiableKeyStore;
import com.oracle.premigration.loadpwd.security.keystorage.PasswordConsoleOption;
import com.oracle.premigration.loadpwd.security.pojos.KeystoreEntryAdder;
import com.oracle.premigration.loadpwd.security.pojos.KeystoreEntryAdderGlobal;
import com.oracle.premigration.loadpwd.security.pojos.KeystoreEntryAdderUser;
import com.oracle.premigration.logger.PremigrationLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PasswordConsole {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(PasswordConsole.class.getName());
    private static final Language lang = Language.getInstance();
    private final KeyStoreManager keyStoreManager;
    private final EnvironmentContext envCtx;
    private final List<Job> jobList;
    private final Pattern commandPattern = Pattern.compile("^(\\w+)((\\s+(\\S+))*)\\s*$");
    private final Supplier<Reader> readerSupplier = () -> new InputStreamReader(System.in);

    public PasswordConsole(EnvironmentContext envCtx, List<Job> jobList) throws PremigrationException {
        this.envCtx = envCtx;
        this.jobList = jobList;
        KeyStorage currentKeyStore = KeyStorage.getInstance();
        this.keyStoreManager = currentKeyStore instanceof ModifiableKeyStore ? ((ModifiableKeyStore)currentKeyStore).getKeyStoreManager() : ModifiableKeyStore.newInstanceForEmptyKeystore(envCtx).getKeyStoreManager();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runKeyStoreConsole() throws IOException, PremigrationException {
        System.out.println();
        BufferedReader br = new BufferedReader(this.readerSupplier.get());
        block13: while (true) {
            block14: while (true) {
                String line;
                if ((line = PasswordConsole.getInput(">> ", br)) == null) {
                    this.exit(br);
                    return;
                }
                if (line.trim().isEmpty()) continue;
                Matcher optionMatcher = this.commandPattern.matcher(line);
                if (!optionMatcher.matches()) {
                    Utilities.printAndLogMessage(lang.txt("PC_UNSUPPORTED_OPTION"), this.envCtx, Level.INFO);
                    continue;
                }
                Optional<PasswordConsoleOption> optionO = PasswordConsoleOption.getOptionFromInput(optionMatcher.group(1));
                if (!optionO.isPresent()) {
                    Utilities.printAndLogErrorMessage(lang.txt("PC_UNSUPPORTED_OPTION"), this.envCtx, Level.INFO);
                    continue;
                }
                PasswordConsoleOption option = optionO.get();
                log.info(lang.entxt("PC_RUNNING_OPTION", new Object[]{option}));
                String optionParams = optionMatcher.group(2) == null ? "" : optionMatcher.group(2).trim();
                switch (option) {
                    case ADD: {
                        this.addAlias(optionParams);
                        continue block13;
                    }
                    case DELETE: {
                        this.deleteAlias(optionParams);
                        continue block13;
                    }
                    case LIST: {
                        PasswordConsole.listPasswordInfo(this.envCtx);
                        continue block13;
                    }
                    case HELP: {
                        Utilities.printAndLogMessage(this.getHelpMsg(), this.envCtx, Level.INFO);
                        continue block13;
                    }
                    case SAVE: {
                        this.saveKeyStore(br);
                        continue block13;
                    }
                    case EXIT: {
                        this.exit(br);
                        return;
                    }
                    default: {
                        String optionNotImplementedMsg = lang.txt("PC_OPTION_NOT_IMPLEMENTED", new Object[]{option});
                        Utilities.printAndLogErrorMessage(optionNotImplementedMsg, this.envCtx, Level.INFO);
                        continue block14;
                    }
                }
                break;
            }
            break;
        }
        finally {
            br.close();
        }
    }

    private void saveKeyStore(BufferedReader br) throws PremigrationException {
        this.keyStoreManager.save(br);
    }

    private void exit(BufferedReader br) throws IOException, PremigrationException {
        if (this.keyStoreManager.hasBeenModifiedSinceBeingSaved() && CommonPasswordConsoleUtils.getYesNo(lang.txt("PC_SAVE_BEFORE_EXIT") + " ", br)) {
            this.saveKeyStore(br);
        }
    }

    private String getHelpMsg() {
        StringBuilder helpMsg = new StringBuilder();
        helpMsg.append(lang.txt("PC_HELP")).append(Constants.NEW_LINE);
        helpMsg.append("-----------------------------------").append(Constants.NEW_LINE);
        int i = 1;
        for (PasswordConsoleOption o : PasswordConsoleOption.values()) {
            helpMsg.append(i++).append(" ").append(o.getOptionString()).append(Constants.NEW_LINE);
        }
        return helpMsg.toString();
    }

    private void addAlias(String allOptions) throws PremigrationException {
        KeyStorePasswordInfo passInfo = PasswordConsole.parseOptions(allOptions);
        if (passInfo == null) {
            String invalidOptionMsg = lang.txt("PWDP_INVALID_OPTIONS", PasswordConsoleOption.ADD.getOptionString());
            Utilities.printAndLogErrorMessage(invalidOptionMsg, this.envCtx, Level.INFO);
            return;
        }
        KeystoreEntryAdder adder = "global".equalsIgnoreCase(passInfo.getNameSpace()) ? new KeystoreEntryAdderGlobal(passInfo, this.jobList, this.keyStoreManager, this.envCtx) : new KeystoreEntryAdderUser(passInfo, this.jobList, this.keyStoreManager, this.envCtx);
        adder.addEntry();
    }

    private void deleteAlias(String allOptions) throws PremigrationException {
        KeyStorePasswordInfo passInfo = PasswordConsole.parseOptions(allOptions);
        if (passInfo == null) {
            String invalidOptionMsg = lang.txt("PWDP_INVALID_OPTIONS", PasswordConsoleOption.DELETE.getOptionString());
            Utilities.printAndLogErrorMessage(invalidOptionMsg, this.envCtx, Level.INFO);
            return;
        }
        log.info(passInfo.getNameSpace());
        log.info(passInfo.getUser());
        if (!this.keyStoreManager.deleteAlias(passInfo.getAlias())) {
            String noAliasMsg = lang.txt("PWDP_NO_ALIAS", passInfo.getNameSpace(), passInfo.getUser());
            Utilities.printAndLogErrorMessage(noAliasMsg, this.envCtx, Level.INFO);
        }
    }

    public static String getInput(String prompt, BufferedReader br) throws IOException {
        System.out.print(prompt);
        String line = br.readLine();
        log.info(lang.entxt("PCU_READ", line));
        return line;
    }

    public static KeyStorePasswordInfo parseOptions(String options) {
        String patternSid = "[A-Za-z][A-Za-z0-9_]{0,127}";
        String patternUser = "\\S+";
        Pattern optionPattern = Pattern.compile(String.format("^(%s)(?:\\s+-user\\s+(%s))?(?:\\s+-nocheck)?$", "[A-Za-z][A-Za-z0-9_]{0,127}", "\\S+"));
        Matcher matcher = optionPattern.matcher(options.trim());
        if (!matcher.matches()) {
            return null;
        }
        String inputNameSpace = matcher.group(1);
        String inputUser = matcher.group(2);
        boolean noCheck = options.contains("-nocheck");
        if (noCheck && inputUser == null) {
            return null;
        }
        return new KeyStorePasswordInfo(inputNameSpace.toLowerCase(), inputUser.toLowerCase(), noCheck);
    }

    public static String lookUpPasswordInfo(String nameSpace, String userPassInfo) throws PremigrationException {
        List<String> aliasList = KeyStorage.getInstance().getAllAliases();
        String username = null;
        if (aliasList != null && aliasList.size() >= 1) {
            for (String alias : aliasList) {
                String[] tokens = alias.split("\\.");
                if (tokens.length != 2 || !tokens[0].equalsIgnoreCase(nameSpace) || !tokens[1].equalsIgnoreCase(userPassInfo)) continue;
                username = tokens[1];
            }
        }
        return Optional.ofNullable(username).orElse(" ");
    }

    public static boolean existsPasswordInfo(String alias) throws PremigrationException {
        return KeyStorage.getInstance().getAllAliases().stream().anyMatch(value -> value.equalsIgnoreCase(alias));
    }

    public static String getAlias(String nameSpace, String username) {
        return String.format("%s.%s", nameSpace, username.toLowerCase(Locale.ROOT));
    }

    public static void listPasswordInfo(EnvironmentContext envCtx) throws PremigrationException {
        List<String> aliasList = KeyStorage.getInstance().getAllAliases();
        if (aliasList.size() > 0) {
            for (String alias : aliasList) {
                String[] tokens = alias.split("\\.");
                if (tokens.length != 2) continue;
                Utilities.printAndLogMessage(lang.txt("PWDP_LIST_ALIAS", tokens[0], tokens[1]), envCtx, Level.INFO);
            }
        }
    }
}

