/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.loadpwd.security.keystorage;

import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.logger.PremigrationLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonPasswordConsoleUtils {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(CommonPasswordConsoleUtils.class.getName());
    private static final Language lang = Language.getInstance();

    private CommonPasswordConsoleUtils() {
    }

    public static String getInput(String prompt, BufferedReader br) throws IOException {
        System.out.print(prompt);
        String line = br.readLine();
        log.info(lang.entxt("PCU_READ", line));
        return line;
    }

    public static boolean getYesNo(String prompt, BufferedReader br) throws IOException {
        Pattern yesNoPattern = Pattern.compile("^\\s*(YES|Y|NO|N)\\s*$", 2);
        String line;
        while ((line = CommonPasswordConsoleUtils.getInput(prompt, br)) != null) {
            Matcher yesNoMatcher = yesNoPattern.matcher(line);
            if (yesNoMatcher.matches()) {
                return yesNoMatcher.group(1).toUpperCase().startsWith("Y");
            }
            System.out.print(lang.txt("PCU_INVALID_YES_NO") + " ");
        }
        return false;
    }

    public static boolean isInvalidPasswordException(IOException e) {
        String msg = e.getMessage() != null ? e.getMessage() : "";
        return msg.contains("CipherException") || msg.contains("incorrect password");
    }
}

