/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.fixups;

import com.oracle.premigration.commons.io.ZipContributor;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.json.CpatJsonIgnore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public final class Fixup
implements ZipContributor {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(Fixup.class.getName());
    static Language lang = Language.getInstance();
    @NonNull
    private final FixupType type;
    @NonNull
    private final String fixupName;
    @NonNull
    private final Locus fixupLocus;
    @NonNull
    private final String relativeFilePath;
    private final Boolean restartRequired;
    private final Boolean runAtCDBLevel;
    @CpatJsonIgnore
    @NonNull
    private final String parentPath;
    private final List<String> notes = new ArrayList<String>();

    public String toString() {
        String fixupPath;
        try {
            fixupPath = this.getFile().getCanonicalPath();
        }
        catch (IOException e) {
            log.warning("Failed to get canonical path from Fixup", e);
            fixupPath = this.getFile().getPath();
        }
        String fixupFileInfo = lang.txt("CHECK_FIXUP_FILE_INFO", new Object[]{this.type, fixupPath});
        String fixupPurpose = lang.txt("CHECK_FIXUP_PURPOSE");
        String fixupLocusInfo = lang.txt("CHECK_FIXUP_LOCUS_PREFIX") + " " + (Object)((Object)this.fixupLocus);
        StringBuilder fixupBuilder = new StringBuilder().append(fixupFileInfo).append(" ").append(fixupPurpose).append(" ").append(fixupLocusInfo).append(". ");
        if (Boolean.TRUE.equals(this.runAtCDBLevel)) {
            fixupBuilder.append(lang.txt("CHECK_FIXUP_CDB_CONTEXT")).append(". ");
        }
        String restartOrNot = Boolean.TRUE.equals(this.restartRequired) ? lang.txt("CHECK_FIXUP_RESTART_REQUIRED_YES") : lang.txt("CHECK_FIXUP_RESTART_REQUIRED_NO");
        fixupBuilder.append(restartOrNot).append(".");
        return fixupBuilder.toString();
    }

    @CpatJsonIgnore
    public File getFile() {
        String filePath = this.getParentPath() + File.separator + this.getRelativeFilePath();
        return new File(filePath);
    }

    @Override
    @CpatJsonIgnore
    public String getZipRelativeFilePath() {
        String zipRelativeFilePath = this.getRelativeFilePath();
        if (zipRelativeFilePath.startsWith("./")) {
            return zipRelativeFilePath.substring(2);
        }
        return zipRelativeFilePath;
    }

    @Override
    @CpatJsonIgnore
    public InputStream getZipEntryStream() throws IOException {
        Path filePath = new File(this.getParentPath() + File.separator + this.getRelativeFilePath()).toPath();
        return Files.newInputStream(filePath, new OpenOption[0]);
    }

    public static FixupBuilder createStaticSqlFixupBuilder(String fixupName, Locus fixupLocus, String parentFolderPath) {
        String relPath = fixupLocus.getPathContribution() + File.separator + fixupName + ".sql";
        return Fixup.builder().type(FixupType.SQL_FILE).fixupLocus(fixupLocus).fixupName(fixupName).parentPath(parentFolderPath).relativeFilePath(relPath);
    }

    private static Boolean $default$restartRequired() {
        return Boolean.FALSE;
    }

    private static Boolean $default$runAtCDBLevel() {
        return Boolean.FALSE;
    }

    Fixup(@NonNull FixupType type, @NonNull String fixupName, @NonNull Locus fixupLocus, @NonNull String relativeFilePath, Boolean restartRequired, Boolean runAtCDBLevel, @NonNull String parentPath) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (fixupName == null) {
            throw new NullPointerException("fixupName is marked non-null but is null");
        }
        if (fixupLocus == null) {
            throw new NullPointerException("fixupLocus is marked non-null but is null");
        }
        if (relativeFilePath == null) {
            throw new NullPointerException("relativeFilePath is marked non-null but is null");
        }
        if (parentPath == null) {
            throw new NullPointerException("parentPath is marked non-null but is null");
        }
        this.type = type;
        this.fixupName = fixupName;
        this.fixupLocus = fixupLocus;
        this.relativeFilePath = relativeFilePath;
        this.restartRequired = restartRequired;
        this.runAtCDBLevel = runAtCDBLevel;
        this.parentPath = parentPath;
    }

    public static FixupBuilder builder() {
        return new FixupBuilder();
    }

    @NonNull
    public FixupType getType() {
        return this.type;
    }

    @NonNull
    public String getFixupName() {
        return this.fixupName;
    }

    @NonNull
    public Locus getFixupLocus() {
        return this.fixupLocus;
    }

    @NonNull
    public String getRelativeFilePath() {
        return this.relativeFilePath;
    }

    public Boolean getRestartRequired() {
        return this.restartRequired;
    }

    public Boolean getRunAtCDBLevel() {
        return this.runAtCDBLevel;
    }

    public List<String> getNotes() {
        return this.notes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Fixup)) {
            return false;
        }
        Fixup other = (Fixup)o;
        Boolean this$restartRequired = this.getRestartRequired();
        Boolean other$restartRequired = other.getRestartRequired();
        if (this$restartRequired == null ? other$restartRequired != null : !((Object)this$restartRequired).equals(other$restartRequired)) {
            return false;
        }
        Boolean this$runAtCDBLevel = this.getRunAtCDBLevel();
        Boolean other$runAtCDBLevel = other.getRunAtCDBLevel();
        if (this$runAtCDBLevel == null ? other$runAtCDBLevel != null : !((Object)this$runAtCDBLevel).equals(other$runAtCDBLevel)) {
            return false;
        }
        FixupType this$type = this.getType();
        FixupType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$fixupName = this.getFixupName();
        String other$fixupName = other.getFixupName();
        if (this$fixupName == null ? other$fixupName != null : !this$fixupName.equals(other$fixupName)) {
            return false;
        }
        Locus this$fixupLocus = this.getFixupLocus();
        Locus other$fixupLocus = other.getFixupLocus();
        if (this$fixupLocus == null ? other$fixupLocus != null : !((Object)((Object)this$fixupLocus)).equals((Object)other$fixupLocus)) {
            return false;
        }
        String this$relativeFilePath = this.getRelativeFilePath();
        String other$relativeFilePath = other.getRelativeFilePath();
        if (this$relativeFilePath == null ? other$relativeFilePath != null : !this$relativeFilePath.equals(other$relativeFilePath)) {
            return false;
        }
        String this$parentPath = this.getParentPath();
        String other$parentPath = other.getParentPath();
        if (this$parentPath == null ? other$parentPath != null : !this$parentPath.equals(other$parentPath)) {
            return false;
        }
        List<String> this$notes = this.getNotes();
        List<String> other$notes = other.getNotes();
        return !(this$notes == null ? other$notes != null : !((Object)this$notes).equals(other$notes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $restartRequired = this.getRestartRequired();
        result = result * 59 + ($restartRequired == null ? 43 : ((Object)$restartRequired).hashCode());
        Boolean $runAtCDBLevel = this.getRunAtCDBLevel();
        result = result * 59 + ($runAtCDBLevel == null ? 43 : ((Object)$runAtCDBLevel).hashCode());
        FixupType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $fixupName = this.getFixupName();
        result = result * 59 + ($fixupName == null ? 43 : $fixupName.hashCode());
        Locus $fixupLocus = this.getFixupLocus();
        result = result * 59 + ($fixupLocus == null ? 43 : ((Object)((Object)$fixupLocus)).hashCode());
        String $relativeFilePath = this.getRelativeFilePath();
        result = result * 59 + ($relativeFilePath == null ? 43 : $relativeFilePath.hashCode());
        String $parentPath = this.getParentPath();
        result = result * 59 + ($parentPath == null ? 43 : $parentPath.hashCode());
        List<String> $notes = this.getNotes();
        result = result * 59 + ($notes == null ? 43 : ((Object)$notes).hashCode());
        return result;
    }

    @CpatJsonIgnore
    @NonNull
    public String getParentPath() {
        return this.parentPath;
    }

    public static enum FixupType {
        SQL_FILE;

    }

    public static enum Locus {
        source("CHECK_FIXUP_LOCUS_SOURCE"),
        target("CHECK_FIXUP_LOCUS_TARGET");

        private final String textRepresentation;

        private Locus(String textProperty) {
            this.textRepresentation = lang.txt(textProperty);
        }

        public String getPathContribution() {
            return this.name();
        }

        public String toString() {
            return this.textRepresentation;
        }
    }

    public static class FixupBuilder {
        private FixupType type;
        private String fixupName;
        private Locus fixupLocus;
        private String relativeFilePath;
        private boolean restartRequired$set;
        private Boolean restartRequired$value;
        private boolean runAtCDBLevel$set;
        private Boolean runAtCDBLevel$value;
        private String parentPath;

        FixupBuilder() {
        }

        public FixupBuilder type(@NonNull FixupType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public FixupBuilder fixupName(@NonNull String fixupName) {
            if (fixupName == null) {
                throw new NullPointerException("fixupName is marked non-null but is null");
            }
            this.fixupName = fixupName;
            return this;
        }

        public FixupBuilder fixupLocus(@NonNull Locus fixupLocus) {
            if (fixupLocus == null) {
                throw new NullPointerException("fixupLocus is marked non-null but is null");
            }
            this.fixupLocus = fixupLocus;
            return this;
        }

        public FixupBuilder relativeFilePath(@NonNull String relativeFilePath) {
            if (relativeFilePath == null) {
                throw new NullPointerException("relativeFilePath is marked non-null but is null");
            }
            this.relativeFilePath = relativeFilePath;
            return this;
        }

        public FixupBuilder restartRequired(Boolean restartRequired) {
            this.restartRequired$value = restartRequired;
            this.restartRequired$set = true;
            return this;
        }

        public FixupBuilder runAtCDBLevel(Boolean runAtCDBLevel) {
            this.runAtCDBLevel$value = runAtCDBLevel;
            this.runAtCDBLevel$set = true;
            return this;
        }

        public FixupBuilder parentPath(@NonNull String parentPath) {
            if (parentPath == null) {
                throw new NullPointerException("parentPath is marked non-null but is null");
            }
            this.parentPath = parentPath;
            return this;
        }

        public Fixup build() {
            Boolean restartRequired$value = this.restartRequired$value;
            if (!this.restartRequired$set) {
                restartRequired$value = Fixup.$default$restartRequired();
            }
            Boolean runAtCDBLevel$value = this.runAtCDBLevel$value;
            if (!this.runAtCDBLevel$set) {
                runAtCDBLevel$value = Fixup.$default$runAtCDBLevel();
            }
            return new Fixup(this.type, this.fixupName, this.fixupLocus, this.relativeFilePath, restartRequired$value, runAtCDBLevel$value, this.parentPath);
        }

        public String toString() {
            return "Fixup.FixupBuilder(type=" + (Object)((Object)this.type) + ", fixupName=" + this.fixupName + ", fixupLocus=" + (Object)((Object)this.fixupLocus) + ", relativeFilePath=" + this.relativeFilePath + ", restartRequired$value=" + this.restartRequired$value + ", runAtCDBLevel$value=" + this.runAtCDBLevel$value + ", parentPath=" + this.parentPath + ")";
        }
    }
}

