/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.logger.PremigrationLogger;
import java.util.Arrays;

public class xdb_resource_view_has_entries
extends Check {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(xdb_resource_view_has_entries.class.getName());

    public xdb_resource_view_has_entries() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ADWD, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.INSTANCE);
        this.setDeclarativeResult(CheckResult.INFORMATIONAL);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        boolean hasResourceView = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("XDB").view("RESOURCE_VIEW").build());
        if (hasResourceView) {
            String query = exeCtx.hasOracleMaintained() ? "SELECT DISTINCT(EXTRACTVALUE (R.RES,'/Resource/Owner'))  OWNER ,R.ANY_PATH FROM RESOURCE_VIEW R, SYS.DBA_USERS A WHERE EXTRACTVALUE (R.RES,'/Resource/Owner') = A.USERNAME AND A.ORACLE_MAINTAINED <> 'Y'" : "SELECT DISTINCT(EXTRACTVALUE (R.RES,'/Resource/Owner')) OWNER, R.ANY_PATH FROM RESOURCE_VIEW R";
            this.setSqlQuery(query);
        } else {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_OBJECT_MISSING", this.getName(), "RESOURCE_VIEW", "VIEW"), CheckResult.PASS);
        }
    }
}

