/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.dbinspector.fixups.Fixable;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import com.oracle.premigration.dbinspector.fixups.FixupFileHelper;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class has_users_objects_no_quota
extends FilterableCheck
implements Fixable {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_users_objects_no_quota.class.getName());

    public has_users_objects_no_quota() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.NONE, LockdownProfile.DWCS_ADWS, LockdownProfile.OLTP_ATPS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.GOLDENGATE, MigrationMethod.DATAPUMP_DBLINK));
        this.setScope(Check.Scope.INSTANCE);
        this.setDeclarativeResult(CheckResult.BLOCKER);
        this.setGrouping(Check.Group.SOURCE);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("USERNAME").objectNameColumn("USERNAME").objectTypeFixed("USER").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "u.username");
        String sqlQuery = "select u.username, decode(p.privilege,'UNLIMITED TABLESPACE','YES','NO') unlimited_tablespace, decode(q.tablespace_name, null, '<NONE>', q.tablespace_name) tablespace_name, CASE    WHEN q.max_bytes = -1 THEN 'UNLIMITED'     WHEN q.max_bytes IS NULL THEN '<NONE>'     ELSE to_char(q.max_bytes) END AS max_bytes, nvl(decode(p.privilege,'UNLIMITED TABLESPACE','NO',decode(q.max_bytes,-1,'NO')),'YES') analyze_seg_size from dba_users u ,dba_sys_privs p,dba_ts_quotas q " + whereClause + "and exists(select 1 from dba_segments s where s.owner=u.username and rownum=1) and p.grantee(+)=u.username and p.privilege(+) = 'UNLIMITED TABLESPACE' and q.username(+)=u.username AND NVL(        DECODE(p.privilege, 'UNLIMITED TABLESPACE', 'NO', DECODE(q.max_bytes, -1, 'NO')),        'YES'    ) = 'YES'order by username, tablespace_name";
        this.setSqlQuery(sqlQuery);
    }

    @Override
    public List<String> fetchNotesMessages(ExecutionContext exeCtx) {
        ArrayList<String> notes = new ArrayList<String>();
        String schemaNamesFormatted = "";
        try {
            List<String> schemaNames = SqlUtils.getAnalysedSchemaNames(exeCtx);
            schemaNamesFormatted = schemaNames.stream().map(name -> "'" + name.trim() + "'").collect(Collectors.joining(","));
            notes.add(this.lang.txt("CHECK.HAS_USERS_OBJECTS_NO_QUOTA.ANALYSIS_NOTE_TEXT", new Object[]{this.getResult(), this.lang.txt("CHECK.HAS_USERS_OBJECTS_NO_QUOTA.ANALYSIS_NOTE_QUERY", schemaNamesFormatted)}));
        }
        catch (SQLException e) {
            log.severe("Exception calling SqlUtils.getAnalysedSchemaNames with '" + schemaNamesFormatted + "'", e);
        }
        return notes;
    }

    @Override
    public void generateFixups(ExecutionContext exeCtx) throws IOException {
        String parentFolderPath = exeCtx.getOutputFilenamesContainer().getOutDir();
        String fixupNameRevoke = "revoke_unlimited_tablespace";
        String fixupNameGrant = "grant_unlimited_tablespace";
        Fixup.Locus locus = Fixup.Locus.target;
        String relPathRevoke = locus.getPathContribution() + File.separator + "revoke_unlimited_tablespace" + ".sql";
        String relPathGrant = locus.getPathContribution() + File.separator + "grant_unlimited_tablespace" + ".sql";
        Fixup sqlFixupRevoke = Fixup.builder().type(Fixup.FixupType.SQL_FILE).fixupLocus(locus).fixupName("revoke_unlimited_tablespace").parentPath(parentFolderPath).relativeFilePath(relPathRevoke).build();
        Fixup sqlFixupGrant = Fixup.builder().type(Fixup.FixupType.SQL_FILE).fixupLocus(locus).fixupName("grant_unlimited_tablespace").parentPath(parentFolderPath).relativeFilePath(relPathGrant).build();
        try (FixupFileHelper fileHelperRevoke = new FixupFileHelper(this, sqlFixupRevoke);
             FixupFileHelper fileHelperGrant = new FixupFileHelper(this, sqlFixupGrant);){
            String dcl;
            ArrayList<String> dclStatementsRevoke = new ArrayList<String>();
            ArrayList<String> dclStatementsGrant = new ArrayList<String>();
            sqlFixupGrant.getNotes().add(this.lang.txt("CHECK.HAS_USERS_OBJECTS_NO_QUOTA.FIXUP_BEFORE_IMPORT_OBJECTS"));
            sqlFixupRevoke.getNotes().add(this.lang.txt("CHECK.HAS_USERS_OBJECTS_NO_QUOTA.FIXUP_AFTER_IMPORT_OBJECTS"));
            fileHelperRevoke.writeNotes();
            fileHelperGrant.writeNotes();
            for (Map<String, String> relevantObject : this.getRelevantObjectsData()) {
                dcl = "REVOKE UNLIMITED TABLESPACE FROM " + relevantObject.get("USERNAME") + ";";
                dclStatementsRevoke.add(dcl);
            }
            for (Map<String, String> relevantObject : this.getRelevantObjectsData()) {
                dcl = "GRANT UNLIMITED TABLESPACE TO " + relevantObject.get("USERNAME") + ";";
                dclStatementsGrant.add(dcl);
            }
            fileHelperGrant.writeFixupText(dclStatementsGrant, 1);
            fileHelperRevoke.writeFixupText(dclStatementsRevoke, 1);
            this.addFixup(sqlFixupGrant);
            this.addFixup(sqlFixupRevoke);
        }
        catch (Exception e) {
            String errorMesg = Utilities.getErrorText("ERROR3005", e, "revoke_unlimited_tablespace", this.getName());
            Utilities.printAndLogErrorMessage(errorMesg, exeCtx.getEnvCtx(), Level.SEVERE);
            throw new IOException(errorMesg, e);
        }
    }
}

