/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class has_sys_privileges
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_sys_privileges.class.getName());

    public has_sys_privileges() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.ADWD, TargetCloud.ADWS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("GRANTEE").objectNameColumn("PRIVILEGE").objectTypeFixed("GRANT").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        ArrayList<String> sysPrivilegesList;
        boolean hasTargetPrivsProp = true;
        String targetPrivProp = exeCtx.getAnalysisProperty(TargetInstanceProp.SYSPRIVILEGE.getKey());
        if (targetPrivProp == null || targetPrivProp.trim().length() == 0) {
            hasTargetPrivsProp = false;
        }
        if (hasTargetPrivsProp) {
            sysPrivilegesList = new ArrayList<String>(Arrays.asList(targetPrivProp.split(",")));
        } else {
            String defaultPrivProp = exeCtx.getDefaultAnalysisProperties().getProperty(TargetInstanceProp.SYSPRIVILEGE.getKey());
            sysPrivilegesList = new ArrayList<String>(Arrays.asList(defaultPrivProp.split(",")));
            String msg = this.lang.txt("CHECK.HAS_ROLES_OR_SYS_PRIVS.ALLOWED_LIST_INFERRED", TargetInstanceProp.SYSPRIVILEGE.getKey());
            this.setErrorMessage(msg);
            this.setDeclarativeResult(CheckResult.WARNING);
        }
        List<Object> srcPrivList = new ArrayList();
        String granteeWhereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "grantee");
        String srcPrivQuery = "SELECT PRIVILEGE FROM SYS.DBA_SYS_PRIVS " + granteeWhereClause;
        try {
            srcPrivList = SqlUtils.getStringList(srcPrivQuery, exeCtx);
        }
        catch (SQLException e) {
            log.severe("Exception calling SqlUtils.getStringList with '" + srcPrivQuery + "'", e);
        }
        srcPrivList.removeAll(sysPrivilegesList);
        String privilegeClause = srcPrivList.isEmpty() ? SqlUtils.createAndClause("PRIVILEGE", false, sysPrivilegesList) : SqlUtils.createAndClause("PRIVILEGE", true, srcPrivList);
        String sqlQuery = "SELECT GRANTEE, PRIVILEGE FROM SYS.DBA_SYS_PRIVS " + granteeWhereClause + " AND GRANTEE IN (SELECT USERNAME FROM SYS.DBA_USERS) " + privilegeClause;
        this.setSqlQuery(sqlQuery);
    }
}

