/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.AnalysisMode;
import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class has_role_privileges
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_role_privileges.class.getName());

    public has_role_privileges() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.ADWD, TargetCloud.ADWS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("GRANTEE").objectNameColumn("GRANTED_ROLE").objectTypeFixed("ROLE GRANT").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String expandedGrantedRoleListClause;
        String grantedRoleClause;
        ArrayList<String> roleList;
        boolean hasTargetRoleProperty = true;
        String targetRoleProperty = exeCtx.getAnalysisProperty(TargetInstanceProp.ROLEPRIVILEGE.getKey());
        if (targetRoleProperty == null || targetRoleProperty.trim().isEmpty()) {
            hasTargetRoleProperty = false;
        }
        String granteeWhereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "GRANTEE");
        String srcRolesQuery = "SELECT DISTINCT GRANTED_ROLE FROM SYS.DBA_ROLE_PRIVS " + granteeWhereClause;
        List<Object> srcRoleList = new ArrayList();
        try {
            srcRoleList = SqlUtils.getStringList(srcRolesQuery, exeCtx);
        }
        catch (SQLException e) {
            log.severe("Exception calling SqlUtils.getStringList with '" + srcRolesQuery + "'", e);
        }
        if (hasTargetRoleProperty) {
            roleList = new ArrayList<String>(Arrays.asList(targetRoleProperty.split(",")));
        } else {
            String defaultPrivProp = exeCtx.getDefaultAnalysisProperties().getProperty(TargetInstanceProp.ROLEPRIVILEGE.getKey());
            roleList = new ArrayList<String>(Arrays.asList(defaultPrivProp.split(",")));
            String msg = this.lang.txt("CHECK.HAS_ROLES_OR_SYS_PRIVS.ALLOWED_LIST_INFERRED", TargetInstanceProp.ROLEPRIVILEGE.getKey());
            this.setErrorMessage(msg);
        }
        srcRoleList.removeAll(roleList);
        if (exeCtx.getAnalysisMode() == AnalysisMode.FULL && exeCtx.hasOracleMaintained()) {
            String userDefinedRolesQuery = "SELECT ROLE FROM SYS.DBA_ROLES WHERE ORACLE_MAINTAINED <> 'Y'";
            List<Object> userDefinedRoles = new ArrayList();
            try {
                userDefinedRoles = SqlUtils.getStringList("SELECT ROLE FROM SYS.DBA_ROLES WHERE ORACLE_MAINTAINED <> 'Y'", exeCtx);
            }
            catch (SQLException e) {
                log.severe("Exception calling SqlUtils.getStringList with 'SELECT ROLE FROM SYS.DBA_ROLES WHERE ORACLE_MAINTAINED <> 'Y''", e);
            }
            ArrayList<Object> oracleDefinedRoles = new ArrayList<Object>(srcRoleList);
            oracleDefinedRoles.removeAll(userDefinedRoles);
            String oracleDefinedRolesClause = SqlUtils.createWhereClause("GRANTED_ROLE", true, oracleDefinedRoles);
            String grantedRoleClause2 = SqlUtils.createAndClause("GRANTED_ROLE", true, srcRoleList);
            int whereIndex = granteeWhereClause.indexOf("WHERE");
            String granteeWhereClauseModified = granteeWhereClause.substring(0, whereIndex + 5) + " (" + granteeWhereClause.substring(whereIndex + 5);
            String rolesToFlagQuery = "WITH NOT_ORACLE_MAINTAINED (GRANTEE, GRANTED_ROLE, LVL) AS (  SELECT DISTINCT GRANTEE, GRANTED_ROLE, 1 AS LVL  FROM SYS.DBA_ROLE_PRIVS" + granteeWhereClauseModified + "    OR GRANTEE IN (      SELECT ROLE      FROM SYS.DBA_ROLES DR      WHERE DR.ORACLE_MAINTAINED <> 'Y'    ))" + grantedRoleClause2 + "  UNION ALL  SELECT NOM.GRANTEE, DRP.GRANTED_ROLE, NOM.LVL + 1  FROM NOT_ORACLE_MAINTAINED NOM  JOIN SYS.DBA_ROLE_PRIVS DRP ON NOM.GRANTED_ROLE = DRP.GRANTEE  WHERE NOT EXISTS (    SELECT 1    FROM SYS.DBA_ROLES DR    WHERE DR.ROLE = DRP.GRANTED_ROLE      AND DR.ORACLE_MAINTAINED = 'Y'  ) ), NOT_SUPPORTED_ADB_ROLES(GRANTEE, GRANTED_ROLE, LVL) AS (  SELECT NOM.GRANTEE, NOM.GRANTED_ROLE, 1 AS LVL  FROM NOT_ORACLE_MAINTAINED NOM" + oracleDefinedRolesClause + "  UNION ALL  SELECT NOM2.GRANTEE, NOM2.GRANTED_ROLE, NOM2.LVL + 1  FROM NOT_ORACLE_MAINTAINED NOM2, NOT_SUPPORTED_ADB_ROLES NSAR  WHERE NSAR.GRANTEE = NOM2.GRANTED_ROLE ) SELECT DISTINCT GRANTED_ROLE  FROM NOT_SUPPORTED_ADB_ROLES" + granteeWhereClause + " AND GRANTED_ROLE NOT IN (  SELECT ROLE  FROM SYS.DBA_ROLES DR  WHERE DR.ORACLE_MAINTAINED = 'Y' )";
            HashSet<String> rolesToFlag = new HashSet<String>();
            try {
                rolesToFlag.addAll(SqlUtils.getStringList(rolesToFlagQuery, exeCtx));
            }
            catch (SQLException e) {
                log.severe("Exception calling SqlUtils.getStringList with '" + rolesToFlagQuery + "'", e);
            }
            srcRoleList.removeAll(userDefinedRoles);
            srcRoleList.addAll(rolesToFlag);
        }
        if (srcRoleList.isEmpty()) {
            grantedRoleClause = SqlUtils.createAndClause("GRANTED_ROLE", false, roleList);
            String childrenRoleStartWithClause = SqlUtils.createStartWithClause("GRANTEE", true, roleList);
            expandedGrantedRoleListClause = " AND GRANTED_ROLE NOT IN (    SELECT DISTINCT GRANTED_ROLE    FROM SYS.DBA_ROLE_PRIVS " + childrenRoleStartWithClause + "   CONNECT BY GRANTEE = PRIOR GRANTED_ROLE  )";
        } else {
            grantedRoleClause = SqlUtils.createAndClause("GRANTED_ROLE", true, srcRoleList);
            expandedGrantedRoleListClause = "";
        }
        String granteeStartWithClause = granteeWhereClause.replace("WHERE", "START WITH");
        String sqlQuery = "SELECT GRANTEE, GRANTED_ROLE FROM (    SELECT DISTINCT CONNECT_BY_ROOT GRANTEE AS GRANTEE, GRANTED_ROLE    FROM SYS.DBA_ROLE_PRIVS " + granteeStartWithClause + "   CONNECT BY GRANTEE = PRIOR GRANTED_ROLE  ) " + granteeWhereClause + " AND GRANTEE IN (SELECT USERNAME FROM SYS.DBA_USERS)  AND GRANTED_ROLE <> 'SQLT_USER_ROLE' " + grantedRoleClause + " " + expandedGrantedRoleListClause + " ORDER BY GRANTED_ROLE";
        this.setSqlQuery(sqlQuery);
    }
}

