/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;

public abstract class has_libraries
extends FilterableCheck {
    protected has_libraries() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("LIBRARY_NAME").objectTypeFixed("LIBRARY").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String sqlQuery = "SELECT OWNER, LIBRARY_NAME, NVL(FILE_SPEC, ' ') AS FILE_SPEC FROM SYS.DBA_LIBRARIES" + whereClause + " ORDER BY 1,2";
        this.setSqlQuery(sqlQuery);
    }
}

