/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.AnalysisMode;
import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import java.util.Arrays;

public class has_enabled_scheduler_jobs
extends Check {
    public has_enabled_scheduler_jobs() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK));
        this.setScope(Check.Scope.INSTANCE);
        this.setDeclarativeResult(CheckResult.INFORMATIONAL);
        this.setGrouping(Check.Group.SOURCE);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        if (exeCtx.getAnalysisMode() == AnalysisMode.FULL) {
            this.setSqlQuery("SELECT OWNER, JOB_NAME, ENABLED, COMMENTS FROM SYS.DBA_SCHEDULER_JOBS WHERE ENABLED='TRUE'");
        } else {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_NOT_FULL_MODE", this.getName()), CheckResult.PASS);
        }
    }
}

