/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.dbinspector.fixups.Fixable;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.io.IOException;
import java.util.Arrays;

public class has_columns_of_rowid_type
extends FilterableCheck
implements Fixable {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_columns_of_rowid_type.class.getName());

    public has_columns_of_rowid_type() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.DWCS_ADWS, LockdownProfile.OLTP_ATPS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPD, TargetCloud.ADWD));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed("TABLE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String targetAllowsRowIdType = exeCtx.getAnalysisProperty(TargetInstanceProp.ALLOW_ROWID_COLUMN_TYPE.getKey());
        if ("TRUE".equalsIgnoreCase(targetAllowsRowIdType)) {
            this.skipCheck(this.lang.txt("CHECK.HAS_COLUMNS_OF_ROWID_TYPE.SKIPPED_TARGET_ALLOWS"), CheckResult.PASS);
        } else {
            String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
            String sqlQuery = "SELECT OWNER, TABLE_NAME, COLUMN_NAME  FROM SYS.DBA_TAB_COLS " + whereClause + " AND DATA_TYPE IN ('ROWID','UROWID')";
            this.setSqlQuery(sqlQuery);
        }
    }

    @Override
    public void generateFixups(ExecutionContext exeCtx) throws IOException {
        String parentFolderPath = exeCtx.getOutputFilenamesContainer().getOutDir();
        String fixupName = "enable_rowid";
        Fixup.Locus locus = Fixup.Locus.target;
        Fixup fixupObject = Fixup.createStaticSqlFixupBuilder("enable_rowid", locus, parentFolderPath).build();
        this.generateStaticFixup(fixupObject);
    }
}

