/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.tablespace;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TablespaceDetails {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(TablespaceDetails.class.getName());
    @HtmlProperty(labelKey="SRC_DB_TBS_TABLESPACE_NAME", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The name of the tablespace.")
    private String tablespaceName;
    @HtmlProperty(labelKey="SRC_DB_TBS_BLOCK_SIZE", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The block size for the tablespace.")
    private Double blockSize;
    @HtmlProperty(labelKey="SRC_DB_TBS_MAX_SIZE", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The maximum size for the segments in the tablespace.")
    private Double maxSize;
    @HtmlProperty(labelKey="SRC_DB_TBS_STATUS", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The status of the tablespace.")
    private String status;
    @HtmlProperty(labelKey="SRC_DB_TBS_CONTENTS", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The type of tablespace (the type of content it holds).")
    private String contents;
    @HtmlProperty(labelKey="SRC_DB_TBS_LOGGING", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Whether logging is enabled for this tablespace.")
    private String logging;
    @HtmlProperty(labelKey="SRC_DB_TBS_FORCE_LOGGING", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Whether force logging mode is enabled for this tablespace.")
    private String forceLogging;
    @HtmlProperty(labelKey="SRC_DB_TBS_EXTENT_MANAGEMENT", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates how the extents in the tablespace are managed.")
    private String extentManagement;
    @HtmlProperty(labelKey="SRC_DB_TBS_ALLOCATION_TYPE", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Type of extent allocation in effect for the tablespace.")
    private String allocationType;
    @HtmlProperty(labelKey="SRC_DB_TBS_SEGMENT_MANAGEMENT", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates how the free and used segment space in the tablespace is managed.")
    private String segmentSpaceManagement;
    @HtmlProperty(labelKey="SRC_DB_TBS_BIGFILE", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates whether the tablespace is a bigfile tablespace.")
    private String bigfile;
    @HtmlProperty(labelKey="SRC_DB_TBS_ENCRYPTED", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates whether the tablespace is encrypted.")
    private String encrypted;
    @HtmlProperty(labelKey="SRC_DB_TBS_COMPRESS_FOR", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Default compression type for the tablespace.")
    private String compressFor;
    @HtmlProperty(labelKey="SRC_DB_TBS_CURRENT_SIZE", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The size of the tablespace that has been used (GB).")
    private Double currentSizeGB;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TablespaceDetails> getTablespaceDetails(ExecutionContext exeCtx) throws SQLException {
        ArrayList<TablespaceDetails> tablespaceDetailsList = new ArrayList<TablespaceDetails>();
        long startTime = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String tablespaceQuery = "SELECT   TABLESPACE_NAME,   BLOCK_SIZE,   MAX_SIZE,   STATUS,   CONTENTS,   LOGGING,   FORCE_LOGGING,   EXTENT_MANAGEMENT,   ALLOCATION_TYPE,   SEGMENT_SPACE_MANAGEMENT,   BIGFILE,   ENCRYPTED,   NVL(COMPRESS_FOR, 'NO COMPRESSION') AS COMPRESS_FOR,   CASE     WHEN tbs.CONTENTS = 'TEMPORARY' THEN (       SELECT ROUND(ALLOCATED_SPACE / 1024 / 1024 / 1024, 1)       FROM DBA_TEMP_FREE_SPACE       WHERE TABLESPACE_NAME = tbs.TABLESPACE_NAME     )     ELSE (       SELECT SIZE_GB       FROM (         SELECT TABLESPACE_NAME, ROUND(SUM( bytes) / 1024 / 1024 / 1024, 1) AS SIZE_GB         FROM DBA_DATA_FILES         GROUP BY TABLESPACE_NAME       )       WHERE TABLESPACE_NAME = tbs.TABLESPACE_NAME     )   END AS CURRENT_SIZE_GB FROM DBA_TABLESPACES tbs ORDER BY TABLESPACE_NAME";
        log.fine("Fetching tablespace information with query: SELECT   TABLESPACE_NAME,   BLOCK_SIZE,   MAX_SIZE,   STATUS,   CONTENTS,   LOGGING,   FORCE_LOGGING,   EXTENT_MANAGEMENT,   ALLOCATION_TYPE,   SEGMENT_SPACE_MANAGEMENT,   BIGFILE,   ENCRYPTED,   NVL(COMPRESS_FOR, 'NO COMPRESSION') AS COMPRESS_FOR,   CASE     WHEN tbs.CONTENTS = 'TEMPORARY' THEN (       SELECT ROUND(ALLOCATED_SPACE / 1024 / 1024 / 1024, 1)       FROM DBA_TEMP_FREE_SPACE       WHERE TABLESPACE_NAME = tbs.TABLESPACE_NAME     )     ELSE (       SELECT SIZE_GB       FROM (         SELECT TABLESPACE_NAME, ROUND(SUM( bytes) / 1024 / 1024 / 1024, 1) AS SIZE_GB         FROM DBA_DATA_FILES         GROUP BY TABLESPACE_NAME       )       WHERE TABLESPACE_NAME = tbs.TABLESPACE_NAME     )   END AS CURRENT_SIZE_GB FROM DBA_TABLESPACES tbs ORDER BY TABLESPACE_NAME");
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, "SELECT   TABLESPACE_NAME,   BLOCK_SIZE,   MAX_SIZE,   STATUS,   CONTENTS,   LOGGING,   FORCE_LOGGING,   EXTENT_MANAGEMENT,   ALLOCATION_TYPE,   SEGMENT_SPACE_MANAGEMENT,   BIGFILE,   ENCRYPTED,   NVL(COMPRESS_FOR, 'NO COMPRESSION') AS COMPRESS_FOR,   CASE     WHEN tbs.CONTENTS = 'TEMPORARY' THEN (       SELECT ROUND(ALLOCATED_SPACE / 1024 / 1024 / 1024, 1)       FROM DBA_TEMP_FREE_SPACE       WHERE TABLESPACE_NAME = tbs.TABLESPACE_NAME     )     ELSE (       SELECT SIZE_GB       FROM (         SELECT TABLESPACE_NAME, ROUND(SUM( bytes) / 1024 / 1024 / 1024, 1) AS SIZE_GB         FROM DBA_DATA_FILES         GROUP BY TABLESPACE_NAME       )       WHERE TABLESPACE_NAME = tbs.TABLESPACE_NAME     )   END AS CURRENT_SIZE_GB FROM DBA_TABLESPACES tbs ORDER BY TABLESPACE_NAME");
            rs = stmt.executeQuery();
            while (rs.next()) {
                tablespaceDetailsList.add(TablespaceDetails.builder().tablespaceName(rs.getString("TABLESPACE_NAME")).blockSize(rs.getDouble("BLOCK_SIZE")).maxSize(rs.getDouble("MAX_SIZE")).status(rs.getString("STATUS")).contents(rs.getString("CONTENTS")).logging(rs.getString("LOGGING")).forceLogging(rs.getString("FORCE_LOGGING")).extentManagement(rs.getString("EXTENT_MANAGEMENT")).allocationType(rs.getString("ALLOCATION_TYPE")).segmentSpaceManagement(rs.getString("SEGMENT_SPACE_MANAGEMENT")).bigfile(rs.getString("BIGFILE")).encrypted(rs.getString("ENCRYPTED")).compressFor(rs.getString("COMPRESS_FOR")).currentSizeGB(rs.getDouble("CURRENT_SIZE_GB")).build());
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return tablespaceDetailsList;
    }

    public static TablespaceDetailsBuilder builder() {
        return new TablespaceDetailsBuilder();
    }

    private TablespaceDetails(String tablespaceName, Double blockSize, Double maxSize, String status, String contents, String logging, String forceLogging, String extentManagement, String allocationType, String segmentSpaceManagement, String bigfile, String encrypted, String compressFor, Double currentSizeGB) {
        this.tablespaceName = tablespaceName;
        this.blockSize = blockSize;
        this.maxSize = maxSize;
        this.status = status;
        this.contents = contents;
        this.logging = logging;
        this.forceLogging = forceLogging;
        this.extentManagement = extentManagement;
        this.allocationType = allocationType;
        this.segmentSpaceManagement = segmentSpaceManagement;
        this.bigfile = bigfile;
        this.encrypted = encrypted;
        this.compressFor = compressFor;
        this.currentSizeGB = currentSizeGB;
    }

    public String getTablespaceName() {
        return this.tablespaceName;
    }

    public Double getBlockSize() {
        return this.blockSize;
    }

    public Double getMaxSize() {
        return this.maxSize;
    }

    public String getStatus() {
        return this.status;
    }

    public String getContents() {
        return this.contents;
    }

    public String getLogging() {
        return this.logging;
    }

    public String getForceLogging() {
        return this.forceLogging;
    }

    public String getExtentManagement() {
        return this.extentManagement;
    }

    public String getAllocationType() {
        return this.allocationType;
    }

    public String getSegmentSpaceManagement() {
        return this.segmentSpaceManagement;
    }

    public String getBigfile() {
        return this.bigfile;
    }

    public String getEncrypted() {
        return this.encrypted;
    }

    public String getCompressFor() {
        return this.compressFor;
    }

    public Double getCurrentSizeGB() {
        return this.currentSizeGB;
    }

    public static class TablespaceDetailsBuilder {
        private String tablespaceName;
        private Double blockSize;
        private Double maxSize;
        private String status;
        private String contents;
        private String logging;
        private String forceLogging;
        private String extentManagement;
        private String allocationType;
        private String segmentSpaceManagement;
        private String bigfile;
        private String encrypted;
        private String compressFor;
        private Double currentSizeGB;

        TablespaceDetailsBuilder() {
        }

        public TablespaceDetailsBuilder tablespaceName(String tablespaceName) {
            this.tablespaceName = tablespaceName;
            return this;
        }

        public TablespaceDetailsBuilder blockSize(Double blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public TablespaceDetailsBuilder maxSize(Double maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public TablespaceDetailsBuilder status(String status) {
            this.status = status;
            return this;
        }

        public TablespaceDetailsBuilder contents(String contents) {
            this.contents = contents;
            return this;
        }

        public TablespaceDetailsBuilder logging(String logging) {
            this.logging = logging;
            return this;
        }

        public TablespaceDetailsBuilder forceLogging(String forceLogging) {
            this.forceLogging = forceLogging;
            return this;
        }

        public TablespaceDetailsBuilder extentManagement(String extentManagement) {
            this.extentManagement = extentManagement;
            return this;
        }

        public TablespaceDetailsBuilder allocationType(String allocationType) {
            this.allocationType = allocationType;
            return this;
        }

        public TablespaceDetailsBuilder segmentSpaceManagement(String segmentSpaceManagement) {
            this.segmentSpaceManagement = segmentSpaceManagement;
            return this;
        }

        public TablespaceDetailsBuilder bigfile(String bigfile) {
            this.bigfile = bigfile;
            return this;
        }

        public TablespaceDetailsBuilder encrypted(String encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public TablespaceDetailsBuilder compressFor(String compressFor) {
            this.compressFor = compressFor;
            return this;
        }

        public TablespaceDetailsBuilder currentSizeGB(Double currentSizeGB) {
            this.currentSizeGB = currentSizeGB;
            return this;
        }

        public TablespaceDetails build() {
            return new TablespaceDetails(this.tablespaceName, this.blockSize, this.maxSize, this.status, this.contents, this.logging, this.forceLogging, this.extentManagement, this.allocationType, this.segmentSpaceManagement, this.bigfile, this.encrypted, this.compressFor, this.currentSizeGB);
        }

        public String toString() {
            return "TablespaceDetails.TablespaceDetailsBuilder(tablespaceName=" + this.tablespaceName + ", blockSize=" + this.blockSize + ", maxSize=" + this.maxSize + ", status=" + this.status + ", contents=" + this.contents + ", logging=" + this.logging + ", forceLogging=" + this.forceLogging + ", extentManagement=" + this.extentManagement + ", allocationType=" + this.allocationType + ", segmentSpaceManagement=" + this.segmentSpaceManagement + ", bigfile=" + this.bigfile + ", encrypted=" + this.encrypted + ", compressFor=" + this.compressFor + ", currentSizeGB=" + this.currentSizeGB + ")";
        }
    }
}

