/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.schemasummary;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class OwnerTableSegments {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(OwnerTableSegments.class.getName());
    @HtmlProperty(labelKey="SRC_SCH_SUMM_OWNER", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The owner of the table")
    private String owner;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_SEGMENTS", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The total number of table segments")
    private long segments;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_SIZE_GB", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The total size of table segments in gigabytes")
    private double gigabytes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<OwnerTableSegments> getOwnerTableSegmentStats(ExecutionContext exeCtx) throws SQLException {
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "S.OWNER");
        String query = "SELECT S.OWNER, COUNT(1) AS SEGMENTS, ROUND(SUM(BYTES)/1073741824, 6) GIGABYTES FROM DBA_SEGMENTS S JOIN DBA_TABLES T ON S.OWNER=T.OWNER AND S.SEGMENT_NAME=T.TABLE_NAME " + whereClause + "AND S.SEGMENT_TYPE LIKE '%TABLE%' AND T.TABLE_NAME NOT LIKE 'BIN$%' GROUP BY S.OWNER ORDER BY 1";
        log.fine("Fetching Owner TABLE Segments stats with query: " + query);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<OwnerTableSegments> ownerTableSegmentStats = new ArrayList<OwnerTableSegments>();
        long startTime = System.currentTimeMillis();
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                OwnerTableSegments ownerTableSegmentStat = new OwnerTableSegments(rs.getString("OWNER"), rs.getLong("SEGMENTS"), rs.getDouble("GIGABYTES"));
                ownerTableSegmentStats.add(ownerTableSegmentStat);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return ownerTableSegmentStats;
    }

    public static OwnerTableSegmentsBuilder builder() {
        return new OwnerTableSegmentsBuilder();
    }

    private OwnerTableSegments(String owner, long segments, double gigabytes) {
        this.owner = owner;
        this.segments = segments;
        this.gigabytes = gigabytes;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getSegments() {
        return this.segments;
    }

    public double getGigabytes() {
        return this.gigabytes;
    }

    public static class OwnerTableSegmentsBuilder {
        private String owner;
        private long segments;
        private double gigabytes;

        OwnerTableSegmentsBuilder() {
        }

        public OwnerTableSegmentsBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public OwnerTableSegmentsBuilder segments(long segments) {
            this.segments = segments;
            return this;
        }

        public OwnerTableSegmentsBuilder gigabytes(double gigabytes) {
            this.gigabytes = gigabytes;
            return this;
        }

        public OwnerTableSegments build() {
            return new OwnerTableSegments(this.owner, this.segments, this.gigabytes);
        }

        public String toString() {
            return "OwnerTableSegments.OwnerTableSegmentsBuilder(owner=" + this.owner + ", segments=" + this.segments + ", gigabytes=" + this.gigabytes + ")";
        }
    }
}

