/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.schemasummary;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class OwnerLobSegments {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(OwnerLobSegments.class.getName());
    @HtmlProperty(labelKey="SRC_SCH_SUMM_OWNER", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The owner of the LOB segment")
    private String owner;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_SEGMENTS", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The total number of LOB segments")
    private long segments;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_SIZE_GB", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The total size of LOB segments in gigabytes")
    private double gigabytes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<OwnerLobSegments> getOwnerLobSegmentStats(ExecutionContext exeCtx) throws SQLException {
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "S.OWNER");
        String query = "SELECT OWNER, SEGMENTS, TOTAL_IN_GIGABYTES FROM (  SELECT S.OWNER, COUNT(1) AS SEGMENTS, ROUND(SUM(BYTES)/1073741824, 6) TOTAL_IN_GIGABYTES   FROM DBA_SEGMENTS S JOIN DBA_LOBS L ON S.OWNER=L.OWNER AND S.SEGMENT_NAME=L.SEGMENT_NAME " + whereClause + "    AND S.SEGMENT_TYPE LIKE 'LOB%'     AND L.SEGMENT_NAME NOT LIKE 'BIN$%'   GROUP BY S.OWNER   ORDER BY 1 )";
        log.fine("Fetching Owner LOB Segments stats with query: " + query);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<OwnerLobSegments> ownerLobSegmentStats = new ArrayList<OwnerLobSegments>();
        long startTime = System.currentTimeMillis();
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                OwnerLobSegments ownerLobSegmentStat = new OwnerLobSegments(rs.getString("OWNER"), rs.getLong("SEGMENTS"), rs.getDouble("TOTAL_IN_GIGABYTES"));
                ownerLobSegmentStats.add(ownerLobSegmentStat);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return ownerLobSegmentStats;
    }

    public static OwnerLobSegmentsBuilder builder() {
        return new OwnerLobSegmentsBuilder();
    }

    private OwnerLobSegments(String owner, long segments, double gigabytes) {
        this.owner = owner;
        this.segments = segments;
        this.gigabytes = gigabytes;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getSegments() {
        return this.segments;
    }

    public double getGigabytes() {
        return this.gigabytes;
    }

    public static class OwnerLobSegmentsBuilder {
        private String owner;
        private long segments;
        private double gigabytes;

        OwnerLobSegmentsBuilder() {
        }

        public OwnerLobSegmentsBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public OwnerLobSegmentsBuilder segments(long segments) {
            this.segments = segments;
            return this;
        }

        public OwnerLobSegmentsBuilder gigabytes(double gigabytes) {
            this.gigabytes = gigabytes;
            return this;
        }

        public OwnerLobSegments build() {
            return new OwnerLobSegments(this.owner, this.segments, this.gigabytes);
        }

        public String toString() {
            return "OwnerLobSegments.OwnerLobSegmentsBuilder(owner=" + this.owner + ", segments=" + this.segments + ", gigabytes=" + this.gigabytes + ")";
        }
    }
}

