/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.schemasummary;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class OwnerIndexSegments {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(OwnerIndexSegments.class.getName());
    @HtmlProperty(labelKey="SRC_SCH_SUMM_OWNER", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The owner of the index")
    private String owner;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_SEGMENTS", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The total number of index segments")
    private long segments;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_SIZE_GB", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The total size of index segments in gigabytes")
    private double gigabytes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<OwnerIndexSegments> getOwnerIndexSegmentStats(ExecutionContext exeCtx) throws SQLException {
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "S.OWNER");
        String query = "SELECT S.OWNER, COUNT(*) AS SEGMENTS, ROUND(SUM(BYTES)/1073741824, 6) AS TOTALGB  FROM DBA_SEGMENTS S JOIN DBA_INDEXES I ON S.OWNER=I.OWNER AND S.SEGMENT_NAME=I.INDEX_NAME " + whereClause + " AND S.SEGMENT_TYPE LIKE '%INDEX%'  AND I.INDEX_NAME NOT LIKE 'BIN$%'  GROUP BY S.OWNER  ORDER BY 1";
        log.fine("Fetching Owner INDEX Segments stats with query: " + query);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<OwnerIndexSegments> ownerIndexSegmentStats = new ArrayList<OwnerIndexSegments>();
        long startTime = System.currentTimeMillis();
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                OwnerIndexSegments ownerIndexSegmentStat = new OwnerIndexSegments(rs.getString("OWNER"), rs.getLong("SEGMENTS"), rs.getDouble("TOTALGB"));
                ownerIndexSegmentStats.add(ownerIndexSegmentStat);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return ownerIndexSegmentStats;
    }

    public static OwnerIndexSegmentsBuilder builder() {
        return new OwnerIndexSegmentsBuilder();
    }

    private OwnerIndexSegments(String owner, long segments, double gigabytes) {
        this.owner = owner;
        this.segments = segments;
        this.gigabytes = gigabytes;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getSegments() {
        return this.segments;
    }

    public double getGigabytes() {
        return this.gigabytes;
    }

    public static class OwnerIndexSegmentsBuilder {
        private String owner;
        private long segments;
        private double gigabytes;

        OwnerIndexSegmentsBuilder() {
        }

        public OwnerIndexSegmentsBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public OwnerIndexSegmentsBuilder segments(long segments) {
            this.segments = segments;
            return this;
        }

        public OwnerIndexSegmentsBuilder gigabytes(double gigabytes) {
            this.gigabytes = gigabytes;
            return this;
        }

        public OwnerIndexSegments build() {
            return new OwnerIndexSegments(this.owner, this.segments, this.gigabytes);
        }

        public String toString() {
            return "OwnerIndexSegments.OwnerIndexSegmentsBuilder(owner=" + this.owner + ", segments=" + this.segments + ", gigabytes=" + this.gigabytes + ")";
        }
    }
}

